/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import java.util.ArrayList;

/**
 * Holder for datasource info parsed from request.
 *
 */
public class SourceObject {

	private ArrayList<String> t6 = new ArrayList<String>();
	private ArrayList<String> t10 = new ArrayList<String>();
	private ArrayList<String> t11 = new ArrayList<String>();
	private String ds_all="false",ds_lter="false",ds_ilter="false";
	private String facet_ds="";
	public SourceObject(){}

	public void init(){
		
		this.t6 = new ArrayList<String>();
		this.t10 = new ArrayList<String>();
		this.t11 = new ArrayList<String>();
		this.ds_all = "false";
		this.ds_lter = "false";
		this.ds_ilter = "false";
		this.facet_ds = "";
		
	}
		
	
	public SourceObject(ArrayList<String> t6, ArrayList<String> t10, ArrayList<String> t11,
			String ds_all, String ds_lter, String ds_ilter) {
		super();
		this.t6 = t6;
		this.t10 = t10;
		this.t11 = t11;
		this.ds_all = ds_all;
		this.ds_lter = ds_lter;
		this.ds_ilter = ds_ilter;
		this.facet_ds = facet_ds;
	}

	public ArrayList<String> getT6() {
		return t6;
	}

	public void setT6(ArrayList<String> t6) {
		this.t6 = t6;
	}

	public ArrayList<String> getT10() {
		return t10;
	}

	public void setT10(ArrayList<String> t10) {
		this.t10 = t10;
	}

	public ArrayList<String> getT11() {
		return t11;
	}

	public void setT11(ArrayList<String> t11) {
		this.t11 = t11;
	}

	public String getDs_all() {
		return ds_all;
	}

	public void setDs_all(String ds_all) {
		this.ds_all = ds_all;
	}

	public String getDs_lter() {
		return ds_lter;
	}

	public void setDs_lter(String ds_lter) {
		this.ds_lter = ds_lter;
	}

	public String getDs_ilter() {
		return ds_ilter;
	}

	public void setDs_ilter(String ds_ilter) {
		this.ds_ilter = ds_ilter;
	}

	public String getFacet_ds() {
		return facet_ds;
	}

	public void setFacet_ds(String facet_ds) {
		this.facet_ds = facet_ds;
	}


	
	
}
