/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import gov.ornl.mercury3.commands.Search_Terms;
import gov.ornl.mercury3.commands.SolrTransactionDetail;

import java.util.ArrayList;
import java.util.List;

import org.dataone.service.types.v1.Session;

public class SolrTransactionServiceVersion1_1 implements SolrTransactionService {

    private String hideObsoleteFqPart = "";
    private String filterSciMetaFqPart = "";

    private SolrTransactionServiceDelegate solrTxServiceDelegate = null;

    public SolrTransactionServiceVersion1_1() {
        solrTxServiceDelegate = new SolrTransactionServiceDelegate();
        boolean hideObsolete = Boolean.parseBoolean((String) (solrTxServiceDelegate.getProps()
                .get("hide_obsolete")));
        if (hideObsolete) {
            hideObsoleteFqPart = (String) solrTxServiceDelegate.getProps().get(
                    "hide_obsolete_fq_part");
        }

        boolean filterSciMeta = Boolean.parseBoolean((String) (solrTxServiceDelegate.getProps()
                .get("filter_sci_meta")));
        if (filterSciMeta) {
            filterSciMetaFqPart = (String) solrTxServiceDelegate.getProps().get(
                    "filter_sci_meta_fq_part");
        }
    }

    @Override
    public SolrTransactionDetail getSolrTransactionDetail(Search_Terms st, Session d1Session) {
        List<String> queryFilters = new ArrayList<String>();
        if (!hideObsoleteFqPart.isEmpty()) {
            queryFilters.add(hideObsoleteFqPart);
        }
        if (!filterSciMetaFqPart.isEmpty()) {
            queryFilters.add(filterSciMetaFqPart);
        }
        SolrTransactionDetail solrTransDetail = solrTxServiceDelegate.getSolrTransactionDetail(st,
                d1Session, queryFilters);
        solrTransDetail.setFilterForData(st.getFilterForData());
        return solrTransDetail;
    }

    @Override
    public SolrTransactionDetail get_browse_details(Search_Terms st) {
        SolrTransactionDetail solrTransDetail = solrTxServiceDelegate.get_browse_details(st);
        solrTransDetail.setFilterForData(st.getFilterForData());
        return solrTransDetail;
    }
}