/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import gov.ornl.mercury3.commands.CitationDateDisplayUtil;
import gov.ornl.mercury3.commands.Configuration;
import gov.ornl.mercury3.commands.DatasourceBean;
import gov.ornl.mercury3.commands.Field;
import gov.ornl.mercury3.commands.FilterCatField;
import gov.ornl.mercury3.commands.Geo;
import gov.ornl.mercury3.commands.InstanceBean;
import gov.ornl.mercury3.commands.Response;
import gov.ornl.mercury3.commands.Search_Terms;
import gov.ornl.mercury3.commands.SolrDate;
import gov.ornl.mercury3.commands.SolrTransactionDetail;
import gov.ornl.mercury3.commands.Terms;
import gov.ornl.mercury3.web.util.MemberNodeSourcesMapCache;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.UrlValidator;
import org.dataone.service.types.v1.Session;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SolrTransactionServiceDelegate {

    private static final String dataFilterString = "has direct data";

    /** Holder for datasource_map_names. */
    private DataSourceMapNamesBean dsmnb = new DataSourceMapNamesBean();

    /** Maps solr keyword terms to text display values. */
    private MercuryTermMapBean km = new MercuryTermMapBean();

    /** The build cart ur ls. */
    private boolean buildCartURLs = false;

    /** Instance properties. */
    private HashMap<String, Object> hmProps = new HashMap<String, Object>();

    /** Context. */
    private ApplicationContext factory3 = null;

    /** Boolean to signal usage of Geo search restrictions. */
    private boolean globalOverlaps = false;
    private boolean globalEncloses = false;

    /** Boolean for identifying whether this is a faceted datasource. */
    private boolean IsfacetDS = false;

    /** The map of datasource names to aliased display strings.. */
    private Map<String, String> datasourceMapNames = new HashMap<String, String>();

    /** Response object for the Brief jsp view page. */
    private HashMap<String, String> briefRes2 = new HashMap<String, String>();

    /** The solr select url. */
    private String solrSelectURL = "";

    /** The data source. */
    private String source = "";

    /** The solrdb. */
    private String solrdb = "";

    /** The key map. */
    private HashMap<String, String> keyMap = new HashMap<String, String>();

    private boolean use_mn_source_cache = false;

    public SolrTransactionServiceDelegate() {
        ApplicationContext factory = new ClassPathXmlApplicationContext("Mercury3Properties.xml");//
        Configuration cv = (Configuration) factory.getBean("propertiesBean");
        hmProps = cv.getProperties();
        buildCartURLs = Boolean.parseBoolean((String) (hmProps.get("buildCartURLs")));
        solrdb = (String) (hmProps.get("solrdb"));
        solrSelectURL = (String) (hmProps.get("solrSelectURL"));

        try {
            globalOverlaps = Boolean.parseBoolean((String) (hmProps.get("globalOverlaps")));
            globalEncloses = Boolean.parseBoolean((String) (hmProps.get("globalEncloses")));
        } catch (Exception ex) {
            System.out
                    .println(" globalOverlaps or globalEncloses was not retrieved from Mercury3Properties.xml ");
            ex.printStackTrace();
        }

        factory3 = new ClassPathXmlApplicationContext(
                "gov/ornl/mercury3/services/Mercury_term_maps.xml");

        dsmnb = (DataSourceMapNamesBean) factory3.getBean("datasource_map_names");
        km = (MercuryTermMapBean) factory3.getBean("query_string_map");
        datasourceMapNames = dsmnb.getDatasourceMapNames();

        use_mn_source_cache = Boolean.parseBoolean((String) (hmProps.get("use_mn_source_cache")));
        if (use_mn_source_cache) {
            datasourceMapNames = MemberNodeSourcesMapCache.INSTANCE.getMNSourceMap();
        }
        keyMap = km.getTermMap();
    }

    /**
     * Date Conversion method from SOLR format to abbreviated brief page format.
     * 
     * @param date
     *            the date to convert
     * 
     * @return the string representation of the date
     */
    private String convertToBrief(String date) {
        SimpleDateFormat Solr_ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat Brief_Format = new SimpleDateFormat("MM/dd/yyyy");
        try {
            Solr_ISO8601FORMAT.parse(date, new ParsePosition(0));
        } catch (Exception pex) {
            pex.printStackTrace();
        }
        return Brief_Format.format(Solr_ISO8601FORMAT.getCalendar().getTime());
    }

    /**
     * Date Conversion method from Brief to print format.
     * 
     * @param date
     *            the date
     * 
     * @return the string
     */
    private String convertToPRT(String date) {
        SimpleDateFormat PRT_Format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat Brief_Format = new SimpleDateFormat("MM/dd/yyyy");
        try {
            Brief_Format.parse(date, new ParsePosition(0));
        } catch (Exception pex) {
            pex.printStackTrace();
        }
        return PRT_Format.format(Brief_Format.getCalendar().getTime());
    }

    /**
     * Uses the search terms and parameters injected to build a map of URI -vs-
     * datasource.
     * 
     * @param st
     *            a Search terms object conaining request parameters & etc.
     * @return a map of datasource to URI for the shopping cart
     */
    private HashMap buildShopnCartURL(Search_Terms st) {
        ApplicationContext jims_beanfactory = new ClassPathXmlApplicationContext(
                "gov/ornl/mercury3/services/instanceConfig.xml");
        HashMap<String, String> t_prt = st.getParsed_request_terms();
        InstanceBean instance = (InstanceBean) jims_beanfactory.getBean(st.getWebAppRoot());
        DatasourceBean dsb = instance.getDatasources().get(st.getDatasource());
        if (!(null == dsb)) {
            HashMap t_hm = dsb.getDataSourceParameters();

            StringBuilder t_url = new StringBuilder();

            if (null != t_hm.get("url")) {
                t_url.append((String) t_hm.get("url"));
            } else {
                t_url.append("Look for problem in spring xml file");
            }
            Iterator t_it = t_hm.keySet().iterator();
            int t_item = 0;
            HashMap cart_urls2 = new HashMap();
            while (t_it.hasNext()) {
                String key = (String) t_it.next();
                if (key.trim().length() > 0) {

                    String value2 = (String) t_hm.get(key);
                    if (!(key.equalsIgnoreCase("url"))) {
                        if ((null != t_prt.get(key)) && (((String) t_prt.get(key))).length() > 0) {
                            if (t_item > 0) {
                                t_url.append("&" + value2 + "=" + t_prt.get(key));
                            } else {
                                t_url.append(value2 + "=" + t_prt.get(key));
                                t_item += 1;
                            }
                        }
                        cart_urls2.put(key, value2);
                    }
                }
            }
            t_url.append("&" + (String) t_hm.get("ID") + "=");

            cart_urls2.put(st.getDatasource(), t_url.toString());
            return cart_urls2;
        } else {
            HashMap cart_urls3 = new HashMap();
            return cart_urls3;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * gov.ornl.mercury3.services.SolrTransactionService#getSolrTransactionDetail
     * (gov.ornl.mercury3.commands.Search_Terms)
     */
    public SolrTransactionDetail getSolrTransactionDetail(Search_Terms st, Session d1Session,
            List<String> queryFilters) {

        String new_term2 = "";
        String _dismaxSort = null;
        String new_term22 = "";

        String fs = "";
        String descr = "";

        Geo geom = new Geo();
        SolrDate sdate = new SolrDate();
        SolrDate sdate2 = new SolrDate();

        HashMap<String, String> prt = new HashMap<String, String>();
        HashMap getDataValue = new HashMap();
        boolean noQuery = false;

        ArrayList j_Docs = new ArrayList();

        boolean term2 = false;

        boolean term12 = false;

        boolean browse = false;

        boolean solr_facets = false;

        ApplicationContext xf = new ClassPathXmlApplicationContext(
                "gov/ornl/mercury3/services/facets.xml");

        StringBuffer displaySB = new StringBuffer();

        // System.out.println("USING=" + solrSelectURL);

        StringBuffer sb2 = new StringBuffer("");
        boolean DataSourceClauseGenerated = false;

        boolean DataSourceFacetClauseGenerated = false;
        boolean LTERSiteFacetClauseGenerated = false;
        boolean LTERFacet = false;
        boolean DataSourceIsAll = false;
        boolean NoLTERGranules = false;
        if ((!(null == st) && (!(null == st.getGui_queryString())))) {
            sb2.append(st.getGui_queryString());
        }

        SolrTransactionDetail solrTransactionDetail = new SolrTransactionDetail();
        String query = "";
        List arrayList = new ArrayList();
        ArrayList j_facets = null;

        solrTransactionDetail.setAccountsList(arrayList);

        Response res = new Response();
        LinkedHashMap<FilterCatField, List> facets = null;
        List<Map<String, Field>> documents = null;

        ArrayList<HashMap<String, Object>> briefList2 = new ArrayList<HashMap<String, Object>>();// 1/2/09
                                                                                                 // -jmg

        SolrFacets sf = (SolrFacets) xf.getBean("facetsBean");

        SolrFields sfld = (SolrFields) xf.getBean("fieldBean");

        List facetsList = (ArrayList) (sf.getFacets());
        List filedsList = (ArrayList) (sfld.getFields());

        try {
            SolrSearcher solrSearcher = new SolrSearcher(solrSelectURL);

            StringBuffer sb = new StringBuffer();

            if (!(null == st.getTerm1())
                    && ((!(null == st.getTerm1().getValue())) && st.getTerm1().getValue().trim()
                            .length() > 0)
                    && ((!(null == st.getTerm1().getAttribute())) && st.getTerm1().getAttribute()
                            .trim().length() > 0)) {

                String t1 = st.getTerm1().getValue().trim();
                sb.append(" ( " + t1 + " ) ");
                displaySB.append(" " + t1);
            }

            // changes here for iterating term2 as an arraylist of Terms objects

            ArrayList alt2 = st.getTerm2_list();
            /*
             * // looks like we need a Change of structure for this part of the
             * query builder want to set it such that we have the list of Terms
             * objects logically within a grouping
             * 
             * AND ( terms2 op3 Terms3 )
             */
            // find the valid terms (value, attrib, operate)
            // create list of valid terms
            // iterate over valid terms, add operator if iterator hasNext
            boolean hasterm2 = false;
            List<Terms> filledInTerms = new ArrayList<Terms>();

            for (Iterator pmit = alt2.iterator(); pmit.hasNext();) {
                Terms tl2 = (Terms) pmit.next();
                if (!(null == tl2)
                        && ((!(null == tl2.getValue())) && tl2.getValue().trim().length() > 0)
                        && ((!(null == tl2.getAttribute())) && tl2.getAttribute().trim().length() > 0)) {
                    hasterm2 = true;
                    filledInTerms.add(tl2);
                }
            }

            if (hasterm2) {
                if (sb.length() > 0) {
                    sb.append(" AND ( ");
                    displaySB.append(" AND ( ");
                } else {
                    sb.append(" ( ");
                    displaySB.append(" ( ");
                }
            }

            for (Iterator<Terms> iterator = filledInTerms.iterator(); iterator.hasNext();) {
                Terms term = (Terms) iterator.next();

                if ((!(term.getAttribute().trim().contains("fullText")))
                        && (term.getAttribute().trim().contains("Text"))) {
                    sb.append(" ( "

                    // part of query parse change to allow nested
                    // parenthesis in term2 strings jmg 07/27/2009
                    // don't include an extra attribute

                            + term.getValue() + " )");
                    displaySB.append(term.getValue().trim());
                    term2 = true;
                    // making surgical change here to try and insert values
                    // for longer elements which
                    // might contain boolean pieces needing extra
                    // qualifiers.
                    // jim 07/24/2009

                } else {
                    String tmp = term.getValue().trim();
                    String temp = term.getAttribute().trim();
                    String temp1 = tmp.replaceAll("AND", "AND " + temp + ":").replaceAll("OR",
                            "OR " + temp + ":");

                    // sb.append(" ( " + tl2.getAttribute().trim() + ":"+
                    // tl2.getValue().trim() + " )");
                    // sb.append(" ( " + tl2.getAttribute().trim() + ":"+
                    // temp1 + " )");
                    sb.append(" ( " + tmp + " )");
                    // displaySB.append(tl2.getAttribute().trim() + ":"+
                    // tl2.getValue().trim());
                    if (displaySB.length() > 0) {

                        displaySB.append(" ( " + tmp + " )");
                    } else {
                        displaySB.append(" ( " + tmp + " )");
                    }

                    term2 = true;
                }

                if (!(null == term.getOperation()) && (term.getOperation().trim().length() > 0)) {
                    if (iterator.hasNext()) {
                        sb.append(" " + term.getOperation().trim() + " ");
                        displaySB.append(" " + term.getOperation().trim() + " ");
                    }
                }
            }

            if (hasterm2) {
                sb.append(" )");
                displaySB.append(")");
            }

            if (!(null == st.getTerm12())
                    && ((!(null == st.getTerm12().getValue())) && st.getTerm12().getValue()
                            .length() > 0)
                    && ((!(null == st.getTerm12().getAttribute())) && st.getTerm12().getAttribute()
                            .length() > 0)) {

                if (sb.length() > 0) {
                    if (!(null == st.getTerm12().getOperation())
                            && (st.getTerm12().getOperation().trim().length() > 0)) {
                        sb.append(" " + st.getTerm12().getOperation().trim() + " ");
                        displaySB.append(" " + getDisplay(st.getTerm12().getOperation().trim())
                                + " ");
                    }
                }

                if ((!(st.getTerm12().getAttribute().trim().contains("fullText")))
                        && (st.getTerm12().getAttribute().trim().contains("Text"))) {

                    sb.append(" ( "

                    + st.getTerm12().getAttribute().trim() + ":" + "\""
                            + st.getTerm12().getValue().trim().replaceAll("\"", "") + "\"" + " )");

                    displaySB.append(getDisplay(st.getTerm12().getAttribute().trim()) + ":"
                            + st.getTerm12().getValue().trim());

                    term12 = true;
                } else {
                    sb.append(" ( " + st.getTerm12().getAttribute().trim() + ":"
                            + st.getTerm12().getValue().trim() + " )");
                    displaySB.append(st.getTerm12().getAttribute().trim() + ":"
                            + st.getTerm12().getValue().trim());
                    term12 = true;
                }

            }

            if (st.getFilterForData()) {
                if (sb.length() > 0) {
                    sb.append(" AND ");
                    displaySB.append(" AND ");
                }
                sb.append("resourceMap:*");
                displaySB.append(dataFilterString);
            }

            if (!(null == st.getBrowse())
                    && ((!(null == st.getBrowse().getValue())) && st.getBrowse().getValue().trim()
                            .length() > 0)
                    && ((!(null == st.getBrowse().getAttribute())) && st.getBrowse().getAttribute()
                            .trim().length() > 0)) {

                if (sb.length() > 0) {

                    sb.append(" AND ");
                    displaySB.append(" AND ");

                }
                sb.append(st.getBrowse().getAttribute().trim() + ":"
                        + st.getBrowse().getValue().trim());
                displaySB.append(getDisplay(st.getBrowse().getAttribute().trim()) + ":"
                        + st.getBrowse().getValue().trim());
                browse = true;
            }

            if ((!(null == st.getTerm3())) && st.getTerm3().getAttribute().length() > 0
                    && st.getTerm3().getValue().length() > 0) {

                if (geom.setbounds(st.getTerm3().getValue())) {

                    prt.put("SouthBoundCoord", Float.toString(geom.getSouthBoundCoord()));
                    prt.put("EastBoundCoord", Float.toString(geom.getEastBoundCoord()));
                    prt.put("NorthBoundCoord", Float.toString(geom.getNorthBoundCoord()));
                    prt.put("WestBoundCoord", Float.toString(geom.getWestBoundCoord()));

                    String geoFragment = "";// string for holding the solr query
                                            // testing exclusion: e/w is OUTSIDE
                                            // the bounding box
                    String ew_in_range_test = "";// string for holding the solr
                                                 // query testing inclusion: e/w
                                                 // is INSIDE the bounding box
                    String corner_test = "";// string for finding e/w corner in
                                            // a range
                    String east_in_range = "";
                    String west_in_range = "";
                    String ew_out_of__range_test = "";

                    // case D
                    if (geom.getWestBoundCoord() >= 0 && geom.getEastBoundCoord() < 0) {
                        corner_test = "";

                        /*
                         * geoFragment = "((westBoundCoord:[ 0.0  TO "
                         * +geom.getWestBoundCoord()+ "]) " +
                         * "AND (eastBoundCoord:[" +geom.getEastBoundCoord()+
                         * " TO 0.0]))" ;
                         */
                        geoFragment = "(( eastBoundCoord:[" + geom.getEastBoundCoord()
                                + " TO 0.0] " + " ) " + "AND (westBoundCoord:[0.0 TO "
                                + geom.getWestBoundCoord() + " ]" +

                                " ))";

                        ew_in_range_test = "((eastBoundCoord:[-180.0 TO "
                                + geom.getEastBoundCoord() + "] OR " + "(eastBoundCoord:["
                                + geom.getWestBoundCoord() + " TO 180.0]) OR "
                                + "(westBoundCoord:[-180 TO " + geom.getEastBoundCoord() + "]) OR "
                                + "(westBoundCoord:[" + geom.getWestBoundCoord() + " TO 180])))";

                        east_in_range = "((eastBoundCoord:[-180.0 TO " + geom.getEastBoundCoord()
                                + "] OR " + "(eastBoundCoord:[" + geom.getWestBoundCoord()
                                + " TO 180.0]))) ";

                        west_in_range = "((westBoundCoord:[-180 TO " + geom.getEastBoundCoord()
                                + "]) OR " + "(westBoundCoord:[" + geom.getWestBoundCoord()
                                + " TO 180]))";

                        corner_test = ew_in_range_test;

                        ew_out_of__range_test = geoFragment;
                        // case C
                    } else if (geom.getWestBoundCoord() >= 0 && geom.getEastBoundCoord() >= 0) {
                        corner_test = " (( westBoundCoord:[" + geom.getEastBoundCoord() + " TO "
                                + geom.getWestBoundCoord() + "]) OR " + "eastBoundCoord:["
                                + geom.getEastBoundCoord() + " TO " + geom.getWestBoundCoord()
                                + "]) )";

                        /*
                         * geoFragment = "((westBoundCoord:[ 0.0  TO "
                         * +geom.getWestBoundCoord()+ "]) " +
                         * "AND (((eastBoundCoord:[" +geom.getEastBoundCoord()+
                         * " TO 180.0]))" +
                         * " OR (eastBoundCoord:[ -180.0  TO 0.0])))" ;
                         */
                        geoFragment = "(( eastBoundCoord:[" + geom.getEastBoundCoord()
                                + " TO 180.0] " + " ) " + "AND (westBoundCoord:[0.0 TO "
                                + geom.getWestBoundCoord() + " ]" +

                                " OR westBoundCoord:[ -180.0  TO 0.0]))";

                        if (geom.getEastBoundCoord() > geom.getWestBoundCoord()) {
                            ew_in_range_test = "((eastBoundCoord:[" + geom.getWestBoundCoord()
                                    + " TO " + geom.getEastBoundCoord() + "]) OR "
                                    + "(westBoundCoord:[" + geom.getWestBoundCoord() + " TO "
                                    + geom.getEastBoundCoord() + "]))";

                            east_in_range = "(eastBoundCoord:[" + geom.getWestBoundCoord() + " TO "
                                    + geom.getEastBoundCoord() + "])";

                            west_in_range = "(westBoundCoord:[" + geom.getWestBoundCoord() + " TO "
                                    + geom.getEastBoundCoord() + "])";
                        } else {
                            ew_in_range_test = " (( westBoundCoord:[" + geom.getEastBoundCoord()
                                    + " TO " + geom.getWestBoundCoord() + "]) OR "
                                    + "eastBoundCoord:[" + geom.getEastBoundCoord() + " TO "
                                    + geom.getWestBoundCoord() + "]) )";

                            east_in_range = "(eastBoundCoord:[" + geom.getEastBoundCoord() + " TO "
                                    + geom.getWestBoundCoord() + "])";

                            west_in_range = "( westBoundCoord:[" + geom.getEastBoundCoord()
                                    + " TO " + geom.getWestBoundCoord() + "]) ";
                        }

                        corner_test = " ( " + east_in_range + " OR " + west_in_range + " ) ";
                        // case A
                    } else if (geom.getWestBoundCoord() < 0 && geom.getEastBoundCoord() < 0) {
                        corner_test = "";
                        /*
                         * geoFragment = "((eastBoundCoord:["+
                         * geom.getEastBoundCoord() +" TO 0.0]) " +
                         * "AND (((westBoundCoord:[-180.0 TO "
                         * +geom.getWestBoundCoord()+ " ]))" +
                         * " OR (westBoundCoord:[ 0.0  TO 180.0])))" ;
                         */
                        geoFragment = "(( " + " eastBoundCoord:[" + geom.getEastBoundCoord()
                                + " TO 0.0] " + " OR eastBoundCoord:[0.0  TO 180.0]) "
                                + "AND (westBoundCoord:[-180.0 TO " + geom.getWestBoundCoord()
                                + " ]" + "  " + " ))";

                        if (geom.getEastBoundCoord() > geom.getWestBoundCoord()) {
                            ew_in_range_test = "((eastBoundCoord:[" + geom.getWestBoundCoord()
                                    + " TO " + geom.getEastBoundCoord() + "]) OR "
                                    + "(westBoundCoord:[" + geom.getWestBoundCoord() + " TO "
                                    + geom.getEastBoundCoord() + "]))";

                            east_in_range = "((eastBoundCoord:[" + geom.getWestBoundCoord()
                                    + " TO " + geom.getEastBoundCoord() + "]))";

                            west_in_range = "((westBoundCoord:[" + geom.getWestBoundCoord()
                                    + " TO " + geom.getEastBoundCoord() + "]))";

                        } else if (geom.getEastBoundCoord() < geom.getWestBoundCoord()) {
                            ew_in_range_test = "((eastBoundCoord:[0.0 TO "
                                    + geom.getWestBoundCoord() + " ]) OR "
                                    + "(eastBoundCoord:[0.0 TO 180.0 ]) OR "
                                    + "(eastBoundCoord:[-180 TO " + geom.getEastBoundCoord()
                                    + " ]) OR " + "(westBoundCoord:[0.0 TO "
                                    + geom.getWestBoundCoord() + " ]) OR "
                                    + "(westBoundCoord:[0.0 TO 180.0 ]) OR "
                                    + "(westBoundCoord:[-180 TO " + geom.getEastBoundCoord()
                                    + " ]) ) ";

                            east_in_range = "((eastBoundCoord:[0.0 TO " + geom.getWestBoundCoord()
                                    + " ]) OR " + "(eastBoundCoord:[0.0 TO 180.0 ]) OR "
                                    + "(eastBoundCoord:[-180 TO " + geom.getEastBoundCoord()
                                    + " ]))  ";

                            west_in_range = "((westBoundCoord:[0.0 TO " + geom.getWestBoundCoord()
                                    + " ]) OR " + "(westBoundCoord:[0.0 TO 180.0 ]) OR "
                                    + "(westBoundCoord:[-180 TO " + geom.getEastBoundCoord()
                                    + " ]) ) ";

                        }
                        corner_test = ew_in_range_test;
                        // case B
                    } else if (geom.getWestBoundCoord() < 0 && geom.getEastBoundCoord() > 0) {
                        corner_test = "";

                        /*
                         * geoFragment = "((westBoundCoord:[ 0.0  TO "
                         * +geom.getWestBoundCoord()+ "]) " +
                         * "AND (eastBoundCoord:[" +geom.getEastBoundCoord()+
                         * " TO 0.0]))" ;
                         */
                        geoFragment = "(( eastBoundCoord:[" + geom.getEastBoundCoord()
                                + " TO 180.0] " + " ) " + "AND (westBoundCoord:[-180.0 TO "
                                + geom.getWestBoundCoord() + " ]" + "  " + " ))";

                        ew_in_range_test = "((eastBoundCoord:[0.0 TO " + geom.getEastBoundCoord()
                                + "]) OR " + "(eastBoundCoord:[" + geom.getWestBoundCoord()
                                + " TO 0.0]) OR " + "(westBoundCoord:[0 TO "
                                + geom.getEastBoundCoord() + "]) OR " + "(westBoundCoord:["
                                + geom.getWestBoundCoord() + " TO 0.0]))";

                        corner_test = ew_in_range_test;

                        east_in_range = "((eastBoundCoord:[0.0 TO " + geom.getEastBoundCoord()
                                + "]) OR " + "(eastBoundCoord:[" + geom.getWestBoundCoord()
                                + " TO 0.0]))  ";

                        west_in_range = "((westBoundCoord:[0 TO " + geom.getEastBoundCoord()
                                + "]) OR " + "(westBoundCoord:[" + geom.getWestBoundCoord()
                                + " TO 0.0]))";

                    }

                    if (st.getTerm3().getAttribute().trim().equalsIgnoreCase("ENCLOSES")) {

                        if (sb.length() > 0) {
                            sb.append(" AND  ");
                            displaySB.append(" AND ");
                        }

                        sb.append("((((northBoundCoord:[" + geom.getSouthBoundCoord() + " TO "
                                + geom.getNorthBoundCoord() + "]" +

                                " AND " +

                                "southBoundCoord:[" + geom.getSouthBoundCoord() + " TO "
                                + geom.getNorthBoundCoord() + "]" +

                                " AND " +

                                east_in_range +

                                " AND " +

                                west_in_range + " )) "

                        );

                        // code to specifically include global records
                        // new bool from gui / xml to use this... Boolean
                        // includeGlobal
                        // sb.append(" OR (northBoundCoord:\"90.0\" AND southBoundCoord:\"-90.0\" AND westBoundCoord:\"-180.0\" AND eastBoundCoord:\"180.0\") )");

                        if (globalEncloses) {

                            sb.append(" ) OR  isSpatial:true )");

                        } else {
                            sb.append(" ) NOT  isSpatial:true )");
                        }
                        displaySB.append(" encloses coordinates (N,W,S,E)= ("
                                + geom.getNorthBoundCoord() + "," + geom.getWestBoundCoord() + "," +

                                geom.getSouthBoundCoord() + "," + geom.getEastBoundCoord() + ") ");

                    }

                    if (st.getTerm3().getAttribute().trim().equalsIgnoreCase("OVERLAPS")) {

                        if (sb.length() > 0) {
                            sb.append(" AND ( ");
                        } else {
                            sb.append("  ( ");
                        }

                        sb.append("( (" +
                        // nw & ne
                                "northBoundCoord:["
                                + (geom.getSouthBoundCoord())
                                + " TO "
                                + geom.getNorthBoundCoord()
                                + "]"
                                +

                                " AND "
                                + corner_test
                                + ")"
                                + " OR ("
                                +
                                // sw & se
                                "southBoundCoord:["
                                + geom.getSouthBoundCoord()
                                + " TO "
                                + geom.getNorthBoundCoord()
                                + "] "
                                +

                                " AND "
                                + corner_test
                                + ")"
                                +

                                // ////////////////////////////////////////////////////////////////////////////////////////////////

                                " OR ("
                                +
                                // N&S out of range
                                "northBoundCoord:[" + geom.getNorthBoundCoord() + " TO 90.0" + " ]"
                                +

                                " AND " +

                                "southBoundCoord:[ -90.0 " + " TO "
                                + geom.getSouthBoundCoord()
                                + "] "
                                +

                                " AND "
                                +

                                ew_in_range_test
                                +

                                ")"
                                +

                                // N or S in range and e/w out of range
                                " OR (( northBoundCoord:[" + (geom.getSouthBoundCoord()) + " TO "
                                + geom.getNorthBoundCoord() + "] OR "
                                + "southBoundCoord:["
                                + geom.getSouthBoundCoord()
                                + " TO "
                                + geom.getNorthBoundCoord()
                                + "] )"
                                + " AND "
                                + geoFragment
                                + " )"
                                +

                                // /////////////start new case jmg 08142009 N or
                                // S in range and e/w out of range
                                // /////////////////

                                " OR ("
                                +
                                // N&S out of range
                                "northBoundCoord:[" + geom.getNorthBoundCoord() + " TO 90.0" + " ]"
                                +

                                " AND " +

                                "southBoundCoord:[ -90.0 " + " TO " + geom.getSouthBoundCoord()
                                + "] " +

                                " AND " +

                                geoFragment + " )"

                        // /////////////end new case jmg 08142009 N or S in
                        // range and e/w out of range /////////////////
                        );

                        displaySB.append(" overlaps coordinates (N,W,S,E)= ("
                                + geom.getNorthBoundCoord() + "," + geom.getWestBoundCoord() + "," +

                                geom.getSouthBoundCoord() + "," + geom.getEastBoundCoord() + ") ");

                        if (globalOverlaps) {

                            sb.append(" ) OR  isSpatial:true )");

                        } else {
                            sb.append(" ) NOT  isSpatial:true )");
                        }

                    }
                } else {
                    solrTransactionDetail.setGeoError(true);
                }

            }

            String prt_BeginDate = "";
            try {
                prt_BeginDate = convertToPRT(st.getTerm4().getValue().trim());
            } catch (Exception ex) {

            }
            prt.put("BeginDate", prt_BeginDate);

            String prt_EndDate = "";
            try {
                prt_EndDate = convertToPRT(st.getTerm5().getValue().trim());
            } catch (Exception ex) {

            }
            prt.put("EndDate", prt_EndDate);

            if ((!(null == st.getSearchmode())) && (!(null == (st.getSearchmode().getValue())))
                    && (!("" == (st.getSearchmode().getValue())))) {
                String sourceData = st.getSearchmode().getValue().trim();
                // System.out.println("sourceData" + sourceData);
                if (sourceData.equalsIgnoreCase("webdb")) {

                } else {
                    sb.append(" ( " + st.getSearchmode().getAttribute().trim() + ":" + sourceData
                            + " ) ");

                }

            } else {

            }

            st.setParsed_request_terms(prt);
            st.setDataValue(getDataValue);

            if (!(null == st.getTerm4())) { // &&

                if (st.getTerm4().getOperation().trim().equalsIgnoreCase("after")) {
                    if ((!(null == st.getTerm4().getAttribute()))
                            && st.getTerm4().getAttribute().length() > 0) {
                        if (sdate.setDate(st.getTerm4().getValue().trim())) {
                            if (sb.length() > 0) {
                                sb.append(" AND "); //
                            }
                            sb.append(st.getTerm4().getAttribute().trim() + ":[");
                            sb.append(sdate.getYear().trim() + "-" + sdate.getMonth().trim() + "-"
                                    + sdate.getDay().trim() + "T23:59:59Z");
                            sb.append(" TO *]");

                            displaySB.append(" AND " + st.getTerm4().getOperation().trim() + " "
                                    + sdate.getMonth().trim() + "/" + sdate.getDay().trim() + "/"
                                    + sdate.getYear().trim());

                        }
                    }
                }
                if (st.getTerm4().getOperation().trim().equalsIgnoreCase("before")) {
                    if ((!(null == st.getTerm4().getAttribute()))
                            && st.getTerm4().getAttribute().length() > 0) {
                        if (sdate.setDate(st.getTerm4().getValue().trim())) {
                            if (sb.length() > 0) {
                                sb.append(" AND ");
                            }
                            sb.append(st.getTerm4().getAttribute().trim() + ":[* TO ");
                            sb.append(sdate.getYear() + "-" + sdate.getMonth() + "-"
                                    + sdate.getDay().trim() + "T23:59:59Z]");
                            displaySB.append(" AND " + st.getTerm4().getOperation().trim() + " "
                                    + sdate.getMonth().trim() + "/" + sdate.getDay().trim() + "/"
                                    + sdate.getYear().trim());

                        }
                    }
                }

                if ((st.getTerm4().getOperation().trim().equalsIgnoreCase("during"))
                        && (!(null == st.getTerm5()))) {
                    if (((!(null == st.getTerm4().getAttribute())) && st.getTerm4().getAttribute()
                            .length() > 0)
                            && ((!(null == st.getTerm5().getAttribute())) && st.getTerm5()
                                    .getAttribute().length() > 0)) {
                        if ((sdate.setDate(st.getTerm4().getValue().trim()))
                                && (sdate2.setDate(st.getTerm5().getValue().trim()))) {
                            if (sb.length() > 0) {
                                sb.append(" AND  ( "); // add extra ( for
                                                       // overlaps
                            } else {
                                sb.append("  ( ");
                            }
                            sb.append(st.getTerm4().getAttribute().trim() + ":[");
                            sb.append(sdate.getYear().trim() + "-" + sdate.getMonth().trim() + "-"
                                    + sdate.getDay().trim() + "T23:59:59Z");
                            sb.append(" TO ");
                            sb.append(sdate2.getYear() + "-" + sdate2.getMonth() + "-"
                                    + sdate2.getDay().trim() + "T23:59:59Z]");

                            displaySB.append(" " + st.getTerm4().getOperation().trim() + " "
                                    + sdate.getMonth().trim() + "/" + sdate.getDay().trim() + "/"
                                    + sdate.getYear().trim());
                            displaySB.append(" to " + sdate2.getMonth().trim() + "/"
                                    + sdate2.getDay().trim() + "/" + sdate2.getYear().trim());

                            sb.append(" OR ");

                            sb.append(st.getTerm5().getAttribute().trim() + ":[");
                            sb.append(sdate.getYear().trim() + "-" + sdate.getMonth().trim() + "-"
                                    + sdate.getDay().trim() + "T23:59:59Z");
                            sb.append(" TO ");
                            sb.append(sdate2.getYear() + "-" + sdate2.getMonth() + "-"
                                    + sdate2.getDay().trim() + "T23:59:59Z]");

                            // added to implement overlaps

                            sb.append(" OR ( ( ");
                            // insert before logic
                            if ((!(null == st.getTerm4().getAttribute()))
                                    && st.getTerm4().getAttribute().length() > 0) {
                                if (sdate.setDate(st.getTerm4().getValue().trim())) {

                                    sb.append(st.getTerm4().getAttribute().trim() + ":[* TO ");
                                    sb.append(sdate.getYear() + "-" + sdate.getMonth() + "-"
                                            + sdate.getDay().trim() + "T23:59:59Z]");

                                }
                            }
                            sb.append(" ) AND ( ");

                            // insert after logic
                            // fix to use enddate
                            if ((!(null == st.getTerm5().getAttribute()))
                                    && st.getTerm5().getAttribute().length() > 0) {
                                if (sdate.setDate(st.getTerm5().getValue().trim())) {

                                    sb.append(st.getTerm5().getAttribute().trim() + ":[");
                                    sb.append(sdate.getYear().trim() + "-"
                                            + sdate.getMonth().trim() + "-" + sdate.getDay().trim()
                                            + "T23:59:59Z");
                                    sb.append(" TO *]");
                                }
                            }
                            sb.append(" ) ) ) ");
                        }
                    }
                }
            }

            // test inserted here to account for t1 & t2 null conditions i.e.
            // the query being not one solr would be able to apply
            if (sb.toString().trim().length() > 0) {

                // ///////////////////////////////////////////////////////////////////////////////////
                SourceQuery sq = new SourceQuery(st.getSo());
                sb.append(sq.buildQuery());
                displaySB.append(sq.build_display_query());
                // ////////////////////////////////////////////////////////////////////////
            }
            // code remaining should be only for handling non_datasource facet
            // details...not much

            // if the solr facets map has stuff in it
            if ((!(null == st.getSolr_facets_map())) && (st.getSolr_facets_map().size() > 0)) {
                Iterator fmit2 = st.getSolr_facets_map().keySet().iterator();
                // iterate the facets map
                while (fmit2.hasNext()) {
                    String facetkey = (String) fmit2.next();
                    // get a key
                    if ((null != facetkey) && (facetkey.trim().length() > 0)) {
                        String value2 = (String) st.getSolr_facets_map().get(facetkey);
                        if (!(facetkey.contains("datasource"))) {
                            sb.append(" AND  ");
                            sb.append(facetkey + ":" + "\"" + value2 + "\"");
                            displaySB.append(" AND " + getDisplay(facetkey) + ":" + value2);
                        }
                        solr_facets = true;
                    }
                }
            }

            boolean hideDataSource = false;
            // if we have datasources...now a t6 array
            if (!(null == st.getDatasources()) && (st.getDatasources().size() > 0)) {
                ArrayList temp_src = st.getDatasources();
                // get the facets and manage the adding / removing from the list
                // of objects eventually displayed
                if (solr_facets) {
                    if (!(null == st.getFacet())
                            && !(st.getFacet().getAttribute().equalsIgnoreCase("datasource"))) {
                        if (temp_src.contains(st.getFacet().getValue())) {
                            temp_src.remove(st.getFacet().getValue());
                        }
                    } else if (!(null == st.getFacet())
                            && (st.getFacet().getAttribute().equalsIgnoreCase("datasource"))) {

                        hideDataSource = true;
                        st.setHideDS("true");
                        solrTransactionDetail.setHideDS("true");
                    }
                }
                String datasourcesString = "";
                if (!LTERSiteFacetClauseGenerated) {
                    if ((((Boolean.getBoolean(st.getHideDS()))) == false || (hideDataSource == false))
                            && !IsfacetDS) {
                        if (temp_src.size() > 0) {

                            if (temp_src.size() > 0 && !hideDataSource && !IsfacetDS) {
                            }
                            for (int i = 0; i < temp_src.size(); i++) {
                                if ((!((String) temp_src.get(i)).trim().equalsIgnoreCase("all"))
                                        && !DataSourceIsAll) {
                                    if ((sb.length() > 0) && (i == 0)) {
                                        DataSourceClauseGenerated = true;
                                    }
                                    if ((sb.length() > 0) && (i > 0)) {
                                    }
                                    if (!hideDataSource && !IsfacetDS) {
                                        datasourcesString = datasourcesString
                                                .concat((String) temp_src.get(i) + " ");
                                        if (((String) (temp_src.get(i))).equalsIgnoreCase("lter")) {
                                            NoLTERGranules = true;
                                        }
                                    }
                                } else {
                                    DataSourceIsAll = true;
                                }
                            }
                            if (temp_src.size() > 0 && !hideDataSource && !IsfacetDS
                                    && !DataSourceIsAll) {
                            }
                        }
                    }
                }
            }

            // changed to handle generic term2 array
            if ((term2) && (facetsList.size() > 0)) {
                // we remove the "Text" from the attribute for some copy fields
                ArrayList alt22 = st.getTerm2_list();

                for (Iterator pmit = alt22.iterator(); pmit.hasNext();) {
                    Terms tl2 = (Terms) pmit.next();
                    if (facetsList.contains((tl2.getAttribute()).replaceAll("Text", ""))) {
                        facetsList.remove(facetsList.indexOf((tl2.getAttribute()).replaceAll(
                                "Text", "")));
                    }
                }

            }

            if (facetsList.size() > 0) {

                if ((!(null == st.getSolr_facets_map())) && (st.getSolr_facets_map().size() > 0)) {

                    Iterator fmit = st.getSolr_facets_map().keySet().iterator();

                    while (fmit.hasNext()) {
                        String facetkey = (String) fmit.next();

                        // jmg 06272008 for facet re-map

                        if (facetkey.trim().length() > 0) {
                            if (facetsList.contains(facetkey.replaceAll("Text", ""))) {
                                facetsList.remove(facetkey.replaceAll("Text", ""));
                            }

                        }
                    }

                }

                if (!(null == st.getDatasources()) && (st.getDatasources().size() == 1)) {

                    ArrayList local_list = st.getDatasources();
                    if ((facetsList.contains("datasource"))
                            && (!((String) local_list.get(0)).trim().equalsIgnoreCase("all"))) {
                        facetsList.remove("datasource");
                    }
                }

            }
            if (!(null == st.getTerm7())
                    && ((!(null == st.getTerm7().getValue())) && st.getTerm7().getValue().length() > 0)
                    && ((!(null == st.getTerm7().getAttribute())) && st.getTerm7().getAttribute()
                            .length() > 0)) {

                if (sb.length() > 0) {

                    sb.append(" AND ");
                    displaySB.append(" AND ");

                }
                sb.append(st.getTerm7().getAttribute().trim() + ":"
                        + st.getTerm7().getValue().trim());
                displaySB.append(st.getTerm7().getAttribute().trim() + ":"
                        + st.getTerm7().getValue().trim());

            }

            if (!(null == st.getTerm9())
                    && ((!(null == st.getTerm9().getValue())) && st.getTerm9().getValue().length() > 0)
                    && ((!(null == st.getTerm9().getAttribute())) && st.getTerm9().getAttribute()
                            .length() > 0)) {

                String t9value = st.getTerm9().getValue().toLowerCase();

                if (!(t9value.contains("all"))) {

                    if (sb.length() > 0) {

                        sb.append(" AND ");
                        displaySB.append(" AND ");

                    }

                    sb.append(st.getTerm9().getAttribute().trim() + ":" + "\""
                            + st.getTerm9().getValue().trim() + "\"");
                    displaySB.append(st.getTerm9().getAttribute().trim() + ":"
                            + st.getTerm9().getValue().trim());

                }

            }
            // re-arrange order of terms for the sort attribute declaration.
            // Must be at end of query
            // set up sanity test here for query actually has something i it
            if (sb.toString().trim().length() > 0) {

                query = " ( " + sb.toString() + " ) ";

                if ((!(null == st.getAdditional_datasource()))
                        && (st.getAdditional_datasource().trim().length() > 0)) {
                    query = "( (" + sb.toString() + ") OR datasource:"
                            + st.getAdditional_datasource().trim() + " )";

                }

                // // changed here as p/o 1.4 migration jmg
                // // original syntax was deprecated in SOLR 1.3 & removed in
                // 1.4

                String sorttest;

                if (!(null == st.getSortattribute())) {
                    sorttest = st.getSortattribute().trim();
                    solrTransactionDetail.setSortattribute(sorttest);
                    if (!(sorttest.equalsIgnoreCase("default"))) {
                        if ((sorttest.contains("Date")) || (sorttest.contains("date"))
                                || (sorttest.contains("metrd"))) {
                            _dismaxSort = (sorttest + " desc");
                        } else {
                            _dismaxSort = (sorttest + " asc");
                        }

                    }

                }

            }

            // System.out.println("Query => \n" + query);

            // parameterize the search in properties per instance.(below)
            if (st.isMLT()) {
                if ((st.getMlt_request_terms().size() > 0)
                        && (null != (st.getMlt_request_terms()).get("q")[0])) {
                    query = (st.getMlt_request_terms()).get("q")[0];
                } else {
                    query = "";
                }
            }
            String term1Value = "";
            term1Value = st.getRawTerm1().trim();

            if (query.trim().length() > 0) {
                // System.out.println("st.getTerm1().getValue() => "+st.getTerm1().getValue());
                res = solrSearcher.search(query, st.getStart(), st.getPageSize(), filedsList, "",
                        null, _dismaxSort, "true", "100", facetsList, "datasource", "100",
                        st.getIsRSS(), st.getFeedValue(), st.isMLT(), term1Value, queryFilters,
                        d1Session);
            } else {
                noQuery = true;
            }

            //PrintStream out8 = new PrintStream(System.out, true, "UTF-8");

            if (!(noQuery)) {
                ArrayList<String> gkw = new ArrayList<String>();
                documents = res.getDocuments();

                for (int i = 0; i < documents.size(); i++) {
                    HashMap aField = (HashMap) documents.get(i);
                    HashMap<String, Object> aBriefRes2 = new HashMap<String, Object>();// 1/2/09
                                                                                       // -jmg
                    HashMap art = new HashMap();
                    HashMap getdataValue = new HashMap();
                    String thisType = "";
                    String thisName = "";
                    String thisValue = "";
                    ArrayList tl = new ArrayList();
                    for (Iterator iter = aField.keySet().iterator(); iter.hasNext();) {
                        String fieldNameStr = (String) iter.next();
                        Field fieldStr = (Field) aField.get(fieldNameStr);

                        thisType = fieldStr.getType();
                        thisName = fieldStr.getName();
                        thisValue = fieldStr.getValue();
                        tl = fieldStr.getValueList();

                        //          out8.println("Solr query result value for " + thisName
                        //                + " value is: " + thisValue);

                        if ((thisType.contains("arr")) && (thisName.length() > 0)
                                && (tl.size() > 0)) {

                            // show first ten investigators/originating organizations
                            if (thisName.equals("origin")) {
                                String investigatorString = "";
                                int count = 0;
                                for (Object obj : tl) {
                                    String investigatorValue = (String) obj;
                                    investigatorString += investigatorValue + "; ";
                                    count++;
                                    if (count > 9) {
                                        investigatorString += "et al.";
                                        break;
                                    }
                                }
                                aBriefRes2.put("investigators",
                                        StringUtils.removeEnd(investigatorString, "; "));
                                continue;
                            }
                            aBriefRes2.put(thisName, tl);
                            if ((fieldStr.getName()).equalsIgnoreCase("gcmdKeyword")) {
                                gkw = fieldStr.getValueList();
                                aBriefRes2.put("gcmdList", gkw);
                            } else if ((fieldStr.getName()).equalsIgnoreCase("data_url")) {
                                if (!(null == fieldStr.getValue())) {
                                    if (fieldStr.getValue().contains("WMS")) {
                                        List viewdataurl = fieldStr.getValueList();
                                        for (int url = 0; url < viewdataurl.size(); url++) {
                                            String parseURL = viewdataurl.get(url).toString();
                                            if (parseURL.contains("WMS")) {
                                                art.put("NsidcData_url", parseURL);
                                            }
                                        }
                                    } else {
                                        List data_url_Value = fieldStr.getValueList();
                                        getdataValue.put("data_url", data_url_Value.get(0));
                                        st.setDataValue(getdataValue);
                                        art.put("Data_url", fieldStr.getValue());
                                    }
                                }
                            }

                        } else if ((thisType.contains("str")) && (thisName.length() > 0)
                                && (thisValue.length() > 0)) {

                            aBriefRes2.put(thisName, thisValue);
                            // ////////////////////

                            if (thisName.equals("id")) {
                                String mlt_id = thisValue;// (String)(aBriefRes2.get("id"));
                                String mlt_id2 = "";

                                if ((mlt_id != null) && (mlt_id.length() > 0)) {
                                    mlt_id2 = mlt_id.replaceAll("\\\\", "\\\\\\\\");
                                    aBriefRes2.put("mlt_id", mlt_id2);
                                }

                            }

                            // ////////////////

                            if (thisName.equals("author")) {
                                aBriefRes2.put("author", thisValue);
                                continue;
                            }
                            if (thisName.equals("dataUrl")) {
                                aBriefRes2.put("dataUrl", thisValue);
                                continue;
                            }

                            if (thisName.contains("abstract")) {
                                if (thisValue.length() > 600) {
                                    aBriefRes2.put("subabstractStr", thisValue.substring(0, 600));
                                    aBriefRes2.put("abstractStr", thisValue.substring(0, 600));
                                } else {
                                    aBriefRes2.put("subabstractStr", thisValue);
                                    aBriefRes2.put("abstractStr", thisValue);
                                }

                            }
                            if (thisName.contains("data_url")) {
                                String[] schemes = { "http", "https", "ftp" };
                                UrlValidator urlValidator = new UrlValidator(schemes);
                                String actURL = thisValue.toString().replaceAll("<", "")
                                        .replaceAll(">", "");
                                if (urlValidator.isValid(actURL)) {
                                    aBriefRes2.put("data_url", actURL);
                                } else {
                                    aBriefRes2.put("data_url", "");
                                }

                            }

                            if ((fieldStr.getName()).equalsIgnoreCase("datasource")) {
                                fs = fieldStr.getValue();
                                descr = datasourceMapNames.get(fs);

                                if ((null != descr) && (descr.length() > 0)) {
                                    aBriefRes2.put(fieldStr.getName(), descr);
                                } else {
                                    aBriefRes2.put(fieldStr.getName(), fs);
                                }
                                aBriefRes2.put("actualDatasource", fieldStr.getValue());
                                if (!(null == fieldStr.getValue())) {
                                    st.setDatasource(fieldStr.getValue());
                                } else {
                                    st.setDatasource("default");
                                }

                                if (buildCartURLs) {
                                    HashMap hm = buildShopnCartURL(st);
                                    String shoppingCartUrl = (String) hm.get(fieldStr.getValue());
                                    solrTransactionDetail.setCart_urls(hm);
                                    aBriefRes2.put("complete_shoppingcart_url", shoppingCartUrl);
                                    String view_data_base = (String) hm.get("view_data_url");
                                    String view_data = view_data_base + "="
                                            + (String) art.get("NsidcData_url");
                                    if (!(null == (String) art.get("NsidcData_url"))) {
                                        aBriefRes2.put("view_dataURL", view_data);
                                    }
                                }
                            }
                        } else if ((thisType.contains("date")) && (thisName.length() > 0)
                                && (thisValue.length() > 0)) {
                            aBriefRes2.put(thisName, convertToBrief(thisValue));
                            if (thisName.contains("beginDate")) {
                                aBriefRes2.put("startDate", convertToBrief(thisValue));
                            }
                        } else if ((thisType.contains("float")) && (thisName.length() > 0)
                                && (thisValue.length() > 0)) {
                            aBriefRes2.put(thisName, thisValue);
                            if (thisName.contains("north")) {
                                aBriefRes2.put("NBound", thisValue);
                            }
                            if (thisName.contains("south")) {
                                aBriefRes2.put("SBound", thisValue);
                            }
                            if (thisName.contains("east")) {
                                aBriefRes2.put("EBound", thisValue);
                            }
                            if (thisName.contains("west")) {
                                aBriefRes2.put("WBound", thisValue);
                            }

                            try {

                                aBriefRes2.put("pSouthBoundCoord", prt.get("SouthBoundCoord"));
                                aBriefRes2.put("pEastBoundCoord", prt.get("EastBoundCoord"));
                                aBriefRes2.put("pNorthBoundCoord", prt.get("NorthBoundCoord"));
                                aBriefRes2.put("pWestBoundCoord", prt.get("WestBoundCoord"));

                            } catch (Exception ex) {

                            }

                        }
                        if (null != res.getMaxScore()) {
                            aBriefRes2.put("maxScore", res.getMaxScore());
                        }
                        aBriefRes2.put("starCounter", "star_" + i);
                        aBriefRes2.put("mapCounter", "map_" + i);

                    }
                    // /////////
                    if ((aBriefRes2.get("mlt_id") == null)
                            || ((String) (aBriefRes2.get("mlt_id"))).length() == 0) {
                        if (aBriefRes2.get("id") != null) {
                            String mlt_id = (String) aBriefRes2.get("id");// (String)(aBriefRes2.get("id"));
                            String mlt_id2 = "";
                            if ((mlt_id != null) && (mlt_id.length() > 0)) {
                                mlt_id2 = mlt_id.replaceAll("\\\\", "\\\\\\\\");
                                aBriefRes2.put("mlt_id", mlt_id2);
                            }
                        }
                    }

                    String citationDate = CitationDateDisplayUtil.getCitationDate(
                            (String) aBriefRes2.get("pubDate"),
                            (String) aBriefRes2.get("beginDate"),
                            (String) aBriefRes2.get("dateUploaded"));
                    aBriefRes2.put("citationDate", citationDate);

                    briefList2.add(aBriefRes2);
                }
                facets = res.getFacets();
                j_Docs = res.getJ_Docs();
                j_facets = new ArrayList(facets.entrySet());

                if ((!(null == st.getSolr_facets_map())) && (st.getSolr_facets_map().size() > 0)) {

                    Iterator fmit = st.getSolr_facets_map().keySet().iterator();
                    String facet_str = "<strong style='color:red;'>Filters: </strong> ";
                    String facet_str2 = "<strong style='color:red;'>Filters: </strong> ";// jmg

                    while (fmit.hasNext()) {
                        String facetkey = (String) fmit.next();
                        String value = (String) st.getSolr_facets_map().get(facetkey);
                        if (facetkey.equals("datasource") && use_mn_source_cache
                                && this.datasourceMapNames.containsKey(value)) {
                            value = this.datasourceMapNames.get(value);
                        }
                        facet_str += "  ";
                        String temp_queryString = st.getMercury3_query_string();
                        facet_str += getDisplay(facetkey) + " : " + value + " (<a href=\""
                                + "../send/facetsQuerry2?" + temp_queryString + "&del_facet="
                                + facetkey + "&from=brief\">remove</a>) ";
                        facet_str2 += getDisplay(facetkey) + " : " + value + " (<a href=\""
                                + "../send/facetsQuerry2?" + temp_queryString + "&del_facet="
                                + facetkey + "&from=brief\">remove</a>) ";

                        sb2.append(" AND " + facetkey + " : " + value);
                    }
                    solrTransactionDetail.setFacet_str(facet_str);
                    solrTransactionDetail.setFacet_str2(facet_str2);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR=" + e.getMessage());
        }
        if (!(noQuery)) {

            solrTransactionDetail.setSuggestion(res.getSuggestion());
            solrTransactionDetail.setFacets(facets);
            solrTransactionDetail.setDocuments(documents);
            solrTransactionDetail.setBriefResList(briefList2);// 1/2/09 -jmg
            solrTransactionDetail.setMlt_list(res.getMlt_list());// 7/20/09 -jmg
            solrTransactionDetail.setMaxScore(res.getMaxScore());
            solrTransactionDetail.setPageSize(st.getPageSize());

            if ((null != facets) && (!facets.isEmpty())) {
                solrTransactionDetail.setJ_facets(j_facets);
            }

            solrTransactionDetail.setJ_Docs(j_Docs);
            solrTransactionDetail.setQueryString(query);

            try {
                if (null != res.getStatus() && res.getStatus().intValue() != 0) {
                    solrTransactionDetail.setSearchStatus(res.getStatus().toString());
                } else {
                    solrTransactionDetail.setSearchStatus("200");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (!(null == res.getFound())) {
                    solrTransactionDetail.setFound(res.getFound());
                    st.setResponses(res.getFound());
                } else {
                    solrTransactionDetail.setFound(0);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            try {
                if (!(null == res.getStart())) {
                    solrTransactionDetail.setStart(res.getStart());
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            try {
                solrTransactionDetail.setCurrent_page(st.getCurrent_page());
            } catch (Exception e) {
                e.printStackTrace();
            }

            try {
                solrTransactionDetail.setNum_pages(st.getNum_pages());
            } catch (Exception e) {
                e.printStackTrace();
            }
            try {
                solrTransactionDetail.setPage_max_count(st.getPage_max_count());
                solrTransactionDetail.setGui_queryString((displaySB.toString()).replaceAll("[\"]",
                        "%22"));
            } catch (Exception e) {
                e.printStackTrace();
            }

            st.setSource(source);
            st.setSolrdb(solrdb);
        } else {
            // This is the place to set flags so that the view will know that
            // solr was never called
            solrTransactionDetail.setFound(0);
        }
        solrTransactionDetail.setRes(res);
        return solrTransactionDetail;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * gov.ornl.mercury3.services.SolrTransactionService#get_browse_details(
     * gov.ornl.mercury3.commands.Search_Terms)
     */
    public SolrTransactionDetail get_browse_details(Search_Terms st) {

        ArrayList j_Docs = new ArrayList();

        boolean browse = false;

        // System.out.println("USING=" + solrSelectURL);

        SolrTransactionDetail solrTransactionDetail = new SolrTransactionDetail();
        String query = "";

        ArrayList j_facets = null;

        Response res = new Response();
        Map<FilterCatField, List> facets = null;
        List<Map<String, Field>> documents = null;
        StringBuffer sb = new StringBuffer();

        try {
            SolrSearcher solrSearcher = new SolrSearcher(solrSelectURL);
            List filedsList = new ArrayList();

            try {
                filedsList.add(st.getBrowse_field());
            } catch (Exception ex) {
                // System.out.println("The field list must NOT be empty for a browsed search");
                ex.printStackTrace();
                throw (ex);
            }

            if (!(null == st.getTerm1())
                    && ((!(null == st.getTerm1().getValue())) && st.getTerm1().getValue().length() > 0)
                    && ((!(null == st.getTerm1().getAttribute())) && st.getTerm1().getAttribute()
                            .length() > 0)) {

                sb.append(st.getTerm1().getAttribute().trim() + ":" + "\""
                        + st.getTerm1().getValue().trim() + "\"");
            }

            if (!(null == st.getTerm2())
                    && ((!(null == st.getTerm2().getValue())) && st.getTerm2().getValue().trim()
                            .length() > 0)
                    && ((!(null == st.getTerm2().getAttribute())) && st.getTerm2().getAttribute()
                            .trim().length() > 0)) {

                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                sb.append(st.getTerm2().getAttribute().trim() + ":" + "\""
                        + st.getTerm2().getValue().trim() + "\"");
            }

            if (!(null == st.getBrowse())
                    && ((!(null == st.getBrowse().getValue())) && st.getBrowse().getValue().trim()
                            .length() > 0)
                    && ((!(null == st.getBrowse().getAttribute())) && st.getBrowse().getAttribute()
                            .trim().length() > 0)) {

                if (sb.length() > 0) {
                    sb.append(" AND ");
                }

                sb.append(st.getBrowse().getAttribute().trim() + ":" + "\""
                        + st.getBrowse().getValue().trim() + "\"");
                browse = true;
            }

            if (!(null == st.getBrowse_source()) && (st.getBrowse_source().length() > 0)) {
                if (sb.length() > 0) {
                    sb.append(" AND datasource:" + st.getBrowse_source());
                }
            }

            List facetsList = new ArrayList();
            query = sb.toString();
            res = solrSearcher.search(query, 0, 50000, filedsList, "", null, null, "true", "-1",
                    facetsList, null, null);
            documents = res.getDocuments();
            j_Docs = res.getJ_Docs();

        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR=" + e.getMessage());
        }

        solrTransactionDetail.setFacets(facets);
        solrTransactionDetail.setDocuments(documents);
        solrTransactionDetail.setMaxScore(res.getMaxScore());
        solrTransactionDetail.setPageSize(st.getPageSize());
        solrTransactionDetail.setJ_facets(j_facets);
        solrTransactionDetail.setJ_Docs(j_Docs);
        solrTransactionDetail.setQueryString(query);

        try {
            if (!(null == res.getStatus())) {
                solrTransactionDetail.setSearchStatus(res.getStatus().toString());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            if (!(null == res.getFound())) {
                solrTransactionDetail.setFound(res.getFound());
                st.setResponses(res.getFound());
            } else {
                solrTransactionDetail.setFound(0);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            if (!(null == res.getStart())) {
                solrTransactionDetail.setStart(res.getStart());
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        st.setSource(source);
        st.setSolrdb(solrdb);
        solrTransactionDetail.setRes(res);
        return solrTransactionDetail;

    }

    /**
     * Gets a more appropriate string for displaying in the view.
     * 
     * @param s1
     *            the key value to do a lookup on
     * 
     * @return an alias for the given string
     */
    private String getDisplay(String s1) {
        String s2 = "";
        try {
            s2 = keyMap.get(s1);
        } catch (Exception ex) {
            System.out.println("Problem with getDisplay lookup");
        }
        if ((null != s2) && (s2.length() > 0)) {
            return s2;
        } else {
            return s1;
        }
    }

    public HashMap<String, Object> getProps() {
        return this.hmProps;
    }
}
