/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

/*
 * Changed 1/2/09 for new briefres functionality / re-factoring.  -jmg
 * need to change corresponding jsp to use the solr schema defined names for these data on 
 * the Brief page or others which use data from the solr response documents
 * 
 * changed position of sort attribute in query   ...must be at end. -jmg 02202009
 * 
 * redesign of datasource handling for building solr query. -jmg 03302009
 *  
 * bug fix for overlaps geoFragment construction  jmg 02032011
 *  
 */

import gov.ornl.mercury3.commands.Search_Terms;
import gov.ornl.mercury3.commands.SolrTransactionDetail;

import org.dataone.service.types.v1.Session;

/**
 * The Class SolrTransactionServices.
 */
public class SolrTransactionServiceDefault implements SolrTransactionService {

    private SolrTransactionServiceDelegate solrTxServiceDelegate = null;

    /**
     * Instantiates a new solr transaction services.
     */
    public SolrTransactionServiceDefault() {
        solrTxServiceDelegate = new SolrTransactionServiceDelegate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * gov.ornl.mercury3.services.SolrTransactionService#getSolrTransactionDetail
     * (gov.ornl.mercury3.commands.Search_Terms)
     */
    @Override
    public SolrTransactionDetail getSolrTransactionDetail(Search_Terms st, Session d1Session) {
        return solrTxServiceDelegate.getSolrTransactionDetail(st, d1Session, null);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * gov.ornl.mercury3.services.SolrTransactionService#get_browse_details(
     * gov.ornl.mercury3.commands.Search_Terms)
     */
    @Override
    public SolrTransactionDetail get_browse_details(Search_Terms st) {
        return solrTxServiceDelegate.get_browse_details(st);
    }

}
