/**
 * This work was created by participants in the DataONE project, and is jointly copyrighted by participating
 * institutions in DataONE. For more information on DataONE, see our web site at http://dataone.org.
 *
 * Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * $Id$
 */
package gov.ornl.mercury3.services;

import gov.ornl.mercury3.commands.Search_Terms;
import gov.ornl.mercury3.commands.SolrTransactionDetail;

import org.dataone.service.types.v1.Session;

public interface SolrTransactionService {

    /**
     * Embeds most of the mercury query building business logic and uses it to
     * build and return the solr transaction detail object.
     * 
     * @param st
     *            a Search terms object conaining request parameters & etc.
     * @param d1Session
     *            TODO
     * @return a populated SolrTransactionDetail object
     */
    public SolrTransactionDetail getSolrTransactionDetail(Search_Terms st, Session d1Session);

    /**
     * Gets the _browse_details for the web browse tree.
     * 
     * @param st
     *            the search terms object
     * 
     * @return the _browse_details
     */
    public SolrTransactionDetail get_browse_details(Search_Terms st);

}