/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import org.springframework.orm.hibernate3.*;
import org.springframework.transaction.support.*;
import org.springframework.transaction.*;
import org.springframework.transaction.support.TransactionCallback;

// TODO: Auto-generated Javadoc
/**
 * Programmatic  database transaction service implementation Mercury_db_ServiceImpl.
 */
public class Mercury_db_ServiceImpl {

	private TransactionTemplate transactionTemplate;// transactionTemplate

	private TransformedFilesDAO tfdao;
	
	private SessionDAO sdao;
	
	private QueryDAO qdao;
	
	private TermDAO tdao;
	
	private ResultSetDAO rsdao;
	
	private RetrievalDAO rdao;
	
	private ReferralDAO refdao;
	
	private MercuryRateusDAO ratedao;
	

	/**
	 * Sets the transaction manager.
	 * 
	 * @param transactionManager the new transaction manager
	 */
	public void setTransactionManager(
			PlatformTransactionManager transactionManager) {

		this.transactionTemplate = new TransactionTemplate(transactionManager);

	}

	/**
	 * Sets the transaction template.
	 * 
	 * @param transactionTemplate the new transaction template
	 */
	public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
		this.transactionTemplate = transactionTemplate;
	}

	/**
	 * Sets the TransformedFiles Data Access Object.
	 * 
	 * @param tfdao the new tfdao
	 */
	public void setTfdao(TransformedFilesDAO tfdao) {
		this.tfdao = tfdao;
	}
	
	/**
	 * Sets the Session Data Access Object.
	 * 
	 * @param sdao the new sdao
	 */
	public void setSdao(SessionDAO sdao) {
		this.sdao = sdao;
	}

	/**
	 * Findby id.
	 * 
	 * @param ID the iD
	 * 
	 * @return the transformed files
	 */
	public TransformedFiles findbyID(final Integer ID) {
		TransformedFiles tf3 = (TransformedFiles) this.transactionTemplate
				.execute(new TransactionCallback() {
					public TransformedFiles doInTransaction(
							TransactionStatus status) {
						
						TransformedFiles tf2 = new TransformedFiles();
						tf2 = tfdao.findById(ID);
						return tf2;
					}

				});
		return tf3;
	}
	
	
	/**
	 * Findby url.
	 * 
	 * @param ID the iD
	 * 
	 * @return the transformed files
	 */
	public TransformedFiles findbyURL(final String ID) {
		TransformedFiles tf3 = (TransformedFiles) this.transactionTemplate
				.execute(new TransactionCallback() {
					public TransformedFiles doInTransaction(
							TransactionStatus status) {
						
						TransformedFiles tf2 = new TransformedFiles();
						//tf2 = tfdao.findById(ID);
						tf2 = (TransformedFiles)tfdao.findByFileUrl(ID).get(0);
						return tf2;
					}

				});
		return tf3;
	}

	/**
	 * Findbyfile url.
	 * 
	 * @param ID the iD
	 * 
	 * @return the transformed files
	 */
	public TransformedFiles findbyfileURL(final String ID) {
		TransformedFiles tf3 = (TransformedFiles) this.transactionTemplate
				.execute(new TransactionCallback() {
					public TransformedFiles doInTransaction(
							TransactionStatus status) {
						
						TransformedFiles tf2 = new TransformedFiles();
						tf2 = (TransformedFiles)tfdao.findByFileUrl(ID).get(0);
						return tf2;
					}

				});
		return tf3;
	}
	
	
	/**
	 * Sets the qdao.
	 * 
	 * @param qdao the new qdao
	 */
	public void setQdao(QueryDAO qdao) {
		this.qdao = qdao;
	}

	/**
	 * Sets the tdao.
	 * 
	 * @param tdao the new tdao
	 */
	public void setTdao(TermDAO tdao) {
		this.tdao = tdao;
	}

	/**
	 * Sets the rsdao.
	 * 
	 * @param rsdao the new rsdao
	 */
	public void setRsdao(ResultSetDAO rsdao) {
		this.rsdao = rsdao;
	}

	/**
	 * Sets the rdao.
	 * 
	 * @param rdao the new rdao
	 */
	public void setRdao(RetrievalDAO rdao) {
		this.rdao = rdao;
	}

	/**
	 * Sets the refdao.
	 * 
	 * @param refdao the new refdao
	 */
	public void setRefdao(ReferralDAO refdao) {
		this.refdao = refdao;
	}	
	
/**
 * Save session.
 * 
 * @param s1 the s1
 */
public void saveSession(final Session s1){
	this.transactionTemplate.execute(new TransactionCallbackWithoutResult() {
		protected void doInTransactionWithoutResult(TransactionStatus status) {
		sdao.save(s1);
		
		}
		});
}


/**
 * Save term.
 * 
 * @param t1 the t1
 */
public void saveTerm(final Term t1){
	this.transactionTemplate.execute(new TransactionCallbackWithoutResult() {
		protected void doInTransactionWithoutResult(TransactionStatus status) {
		tdao.save(t1);
		
		}
		});
}

/**
 * Save query.
 * 
 * @param q1 the q1
 */
public void saveQuery(final Query q1){
	this.transactionTemplate.execute(new TransactionCallbackWithoutResult() {
		protected void doInTransactionWithoutResult(TransactionStatus status) {
		qdao.save(q1);
		
		}
		});
}

/**
 * Save result set.
 * 
 * @param rs1 the rs1
 */
public void saveResultSet(final ResultSet rs1){
	this.transactionTemplate.execute(new TransactionCallbackWithoutResult() {
		protected void doInTransactionWithoutResult(TransactionStatus status) {
		rsdao.save(rs1);
		
		}
		});
}

/**
 * Save retrieval.
 * 
 * @param r1 the r1
 */
public void saveRetrieval(final Retrieval r1){
	this.transactionTemplate.execute(new TransactionCallbackWithoutResult() {
		protected void doInTransactionWithoutResult(TransactionStatus status) {
		rdao.save(r1);
		
		}
		});
}

/**
 * Save referral.
 * 
 * @param ref1 the ref1
 */
public void saveReferral(final Referral ref1){
	this.transactionTemplate.execute(new TransactionCallbackWithoutResult() {
		protected void doInTransactionWithoutResult(TransactionStatus status) {
		refdao.save(ref1);
		
		}
		});
}

/**
 * Save rate us.
 * 
 * @param rateus the rateus
 */
public void saveRateUs(final MercuryRateus rateus){
	this.transactionTemplate.execute(new TransactionCallbackWithoutResult() {
		protected void doInTransactionWithoutResult(TransactionStatus status) {
		ratedao.save(rateus);
		
		}
		});
}

/**
 * Sets the ratedao.
 * 
 * @param ratedao the new ratedao
 */
public void setRatedao(MercuryRateusDAO ratedao) {
	this.ratedao = ratedao;
}
	
	

}
