/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import java.io.*;
import java.util.*;

import org.jdom.*;
import org.jdom.input.*;
import org.jdom.xpath.*;

/**
 * @author jgreen
 * 
 *         Handle parsing fixed elements from a BioPortal service response and
 *         return this as Object[][] for a JTable.
 *         or
 *         just the list of names
 * 
 */
public class JdomBioPortalXPATHParser {

	public static void main(String[] args) throws IOException, JDOMException {
		String term1 = "carbon";
		JdomBioPortalXPATHParser sxp = new JdomBioPortalXPATHParser();
		//sxp.getTblObj(term1);
		for(String s1:sxp.getnames(term1)){
			System.out.println(s1);
		}
		
		
	}

	public Object[][] getTblObj(String term1) throws IOException, JDOMException {

		Object[][] tbl_obj = null;
		ArrayList<String[]> als_main = new ArrayList<String[]>();

		SAXBuilder builder = new SAXBuilder();
		Document doc = builder.build("bioportal_carbon.xml");

		// Document doc =
		// builder.parse("http://localhost:8280/Mercury3_MN2/mn/xml/123");
		// Document doc =
		// builder.parse("http://mercury-ncbo.ornl.gov:8080/bioportal/search/carbon");

		// Document doc =
		// builder.parse("http://mercury-ncbo.ornl.gov:8080/bioportal/search/"+
		// term1);

		String xexprBean = "//success/ data/ page/ contents/ searchResultList/ searchBean";

		XPath beans = XPath.newInstance(xexprBean);

		List beanList = beans.selectNodes(doc);
		System.out.println("This document has " + beanList.size()
				+ " searchBeans.");
		Iterator i = beanList.iterator();
		CamelSplitter cs = new CamelSplitter();
		while (i.hasNext()) {
			String[] row = new String[2];
			Element bean = (Element) i.next();
			String s1 = bean.getChild("conceptIdShort").getTextTrim();
			String s2 = bean.getChild("preferredName").getTextTrim();

			System.out.println(s1.substring(s1.lastIndexOf("/") + 1).trim()
					+ "\t " + s2);

			row[0] = s1.substring(s1.lastIndexOf("/") + 1).trim();
			// row[1]=s2;
			row[1] = cs.splitCamelCase(s2);
			als_main.add(row);
		}
		tbl_obj = als_main
				.toArray(new Object[als_main.size()][als_main.get(0).length]);

		return tbl_obj;

	}

	public Set<String> getnames(String term1) throws IOException,
			JDOMException {

		SAXBuilder builder = new SAXBuilder();
		Document doc = builder.build("bioportal_carbon.xml");

		// Document doc =
		// builder.parse("http://localhost:8280/Mercury3_MN2/mn/xml/123");
		// Document doc =
		// builder.parse("http://mercury-ncbo.ornl.gov:8080/bioportal/search/carbon");

		// Document doc =
		// builder.parse("http://mercury-ncbo.ornl.gov:8080/bioportal/search/"+
		// term1);

		String xexprBean = "//success/ data/ page/ contents/ searchResultList/ searchBean";

		XPath beans = XPath.newInstance(xexprBean);

		List beanList = beans.selectNodes(doc);
		System.out.println("This document has " + beanList.size()
				+ " searchBeans.");
		Iterator i = beanList.iterator();
		CamelSplitter cs = new CamelSplitter();
		Set<String> uniqueList = new TreeSet<String>();
		String name ="";
		while (i.hasNext()) {
			Element bean = (Element) i.next();
			String s2 = bean.getChild("preferredName").getTextTrim();
			name = cs.splitCamelCase(s2);
			uniqueList.add(name);
			
		}

		return uniqueList;

	}

}
