/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import gov.ornl.mercury3.commands.Configuration;
import gov.ornl.mercury3.commands.DatasourceBean;
import gov.ornl.mercury3.commands.InstanceBean;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.*;
import java.io.*;
import java.io.*;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.w3c.dom.*;
import org.xml.sax.*;

import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import java.io.IOException;
import org.w3c.dom.*;
import org.xml.sax.SAXException;
import javax.xml.parsers.*;
import javax.xml.xpath.*;
import gov.ornl.mercury3.commands.Anchors;


/**
 * Builds map of valid links for validating forward requests.
 *
 */
public class GetAnchors {
	HashMap achHM = new HashMap();;
	int counter = 0;
	
	ApplicationContext xpathBean = new ClassPathXmlApplicationContext(
			"gov/ornl/mercury3/services/instanceConfig.xml");
	HashMap<String,Object> hmProps = new HashMap<String,Object>();
	String metadata_path="";
	
		
	public HashMap getAnchors(String fileURL) throws Exception {
		
		/*
		 * String fullAnchor = "(<a([^>]*)>(.*?)(</a>))"; Pattern
		 * fullAncPattern = Pattern.compile(fullAnchor,
		 * Pattern.CASE_INSENSITIVE); Matcher fullAncMatcher =
		 * fullAncPattern.matcher(htmlText); String matched, a1matched = "";
		 * String a1 = "(<a([^>]*)href[\\s]*=[\\s]*(\"?|\'?)[\\s]*)((\\S*)(\"|\'|>|\\s|/))";
		 * Pattern a1Pattern = Pattern.compile(a1, Pattern.CASE_INSENSITIVE); //
		 * Matcher a1Matcher= a1Pattern.matcher(fileAfterReplace);
		 * 
		 * String Hrefurl; if (fullAncMatcher.find()) { while
		 * (fullAncMatcher.find()) { matched = (String) fullAncMatcher.group();
		 * Matcher a1Matcher = a1Pattern.matcher(matched); if (a1Matcher.find()) {
		 * a1matched = (String) fullAncMatcher.group(); Hrefurl =
		 * a1matched.substring(a1matched.indexOf("="),
		 * a1matched.indexOf(">")).replaceAll("\"", ""); achHM.put(counter,
		 * Hrefurl); counter++; }
		 *  } }
		 */
		
		
		ApplicationContext Appfactory = new ClassPathXmlApplicationContext("Mercury3Properties.xml");//

		Configuration cv = (Configuration)Appfactory.getBean("propertiesBean");
		
		hmProps =cv.getProperties();
		metadata_path = (String)hmProps.get("metadata_path");
		
		Anchors anch = (Anchors) xpathBean.getBean("Xpath");
		
		
		List XpathParameters = (ArrayList) (anch.getXpathparameters());
		DocumentBuilderFactory domFactory = DocumentBuilderFactory
				.newInstance();
		domFactory.setNamespaceAware(true); // never forget this!
		DocumentBuilder builder = domFactory.newDocumentBuilder();
		if (fileURL != null) {
			File xmlFileName = new File(metadata_path+fileURL);
			System.out.println("xmlFileName"+xmlFileName);
			Document doc = builder.parse(xmlFileName);
			XPathFactory factory = XPathFactory.newInstance();
			XPath xpath = factory.newXPath();

			if (!(null == XpathParameters)) {
				Iterator itr = XpathParameters.iterator();
				while (itr.hasNext()) {
					String anchorName = (String) itr.next();
					System.out.println("XpathName= " + anchorName);

					XPathExpression xpathLink = xpath.compile(anchorName);
					Object xpathresult = xpathLink.evaluate(doc,
							XPathConstants.NODESET);
					NodeList xpathLinknodes = (NodeList) xpathresult;
					
					for (int i = 0; i < xpathLinknodes.getLength(); i++) {
						
						achHM.put(counter, xpathLinknodes.item(i)
								.getNodeValue());
						System.out.println("Anchor= "+xpathLinknodes.item(i));
						counter++;
					}

				}
			}
		}

		
		return achHM;

	}

}
