/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

public class CamelSplitter {


	public String splitCamelCase(String camel) {
		String[] parts = camel.split("(?<!^)(?=[A-Z])");
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < parts.length; i++) {
			sb.append(parts[i].toLowerCase()
					+ (i < (parts.length - 1) ? " " : ""));
		}
		return sb.toString();
	}
	
	public static void main(String[] args){
		CamelSplitter cs = new CamelSplitter();
		String test ="Soil";
		System.out.println(cs.splitCamelCase(test));
		String test2 ="SoilCarbon";
		System.out.println(cs.splitCamelCase(test2));
		String test3 ="soilCarbonDioxide";
		System.out.println(cs.splitCamelCase(test3));
	}
}
