/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import java.util.Date;

/**
 * AbstractTerm entity provides the base persistence definition of the Term
 * entity.
 * 
 * @author MyEclipse Persistence Tools
 */

public abstract class AbstractTerm implements java.io.Serializable {

	// Fields

	private TermId id;
	private String term;
	private String useAttribute;
	private String relationAttribute;
	private String operator;
	private Date queryDate;

	// Constructors

	/** default constructor */
	public AbstractTerm() {
	}

	/** minimal constructor */
	public AbstractTerm(TermId id) {
		this.id = id;
	}

	/** full constructor */
	public AbstractTerm(TermId id, String term, String useAttribute,
			String relationAttribute, String operator, Date queryDate) {
		this.id = id;
		this.term = term;
		this.useAttribute = useAttribute;
		this.relationAttribute = relationAttribute;
		this.operator = operator;
		this.queryDate = queryDate;
	}

	// Property accessors

	public TermId getId() {
		return this.id;
	}

	public void setId(TermId id) {
		this.id = id;
	}

	public String getTerm() {
		return this.term;
	}

	public void setTerm(String term) {
		this.term = term;
	}

	public String getUseAttribute() {
		return this.useAttribute;
	}

	public void setUseAttribute(String useAttribute) {
		this.useAttribute = useAttribute;
	}

	public String getRelationAttribute() {
		return this.relationAttribute;
	}

	public void setRelationAttribute(String relationAttribute) {
		this.relationAttribute = relationAttribute;
	}

	public String getOperator() {
		return this.operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public Date getQueryDate() {
		return this.queryDate;
	}

	public void setQueryDate(Date queryDate) {
		this.queryDate = queryDate;
	}

}
