/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import java.util.Date;

/**
 * AbstractSession entity provides the base persistence definition of the
 * Session entity.
 * 
 * @author MyEclipse Persistence Tools
 */

public abstract class AbstractSession implements java.io.Serializable {

	// Fields

	private SessionId id;
	private String ipNumber;
	private String ipName;
	private String browserInfo;
	private Short localUserFlag;
	private Date sessionDate;

	// Constructors

	/** default constructor */
	public AbstractSession() {
	}

	/** minimal constructor */
	public AbstractSession(SessionId id, String ipNumber) {
		this.id = id;
		this.ipNumber = ipNumber;
	}

	/** full constructor */
	public AbstractSession(SessionId id, String ipNumber, String ipName,
			String browserInfo, Short localUserFlag, Date sessionDate) {
		this.id = id;
		this.ipNumber = ipNumber;
		this.ipName = ipName;
		this.browserInfo = browserInfo;
		this.localUserFlag = localUserFlag;
		this.sessionDate = sessionDate;
	}

	// Property accessors

	public SessionId getId() {
		return this.id;
	}

	public void setId(SessionId id) {
		this.id = id;
	}

	public String getIpNumber() {
		return this.ipNumber;
	}

	public void setIpNumber(String ipNumber) {
		this.ipNumber = ipNumber;
	}

	public String getIpName() {
		return this.ipName;
	}

	public void setIpName(String ipName) {
		this.ipName = ipName;
	}

	public String getBrowserInfo() {
		return this.browserInfo;
	}

	public void setBrowserInfo(String browserInfo) {
		this.browserInfo = browserInfo;
	}

	public Short getLocalUserFlag() {
		return this.localUserFlag;
	}

	public void setLocalUserFlag(Short localUserFlag) {
		this.localUserFlag = localUserFlag;
	}

	public Date getSessionDate() {
		return this.sessionDate;
	}

	public void setSessionDate(Date sessionDate) {
		this.sessionDate = sessionDate;
	}

}
