/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

/**
 * AbstractRetrieval entity provides the base persistence definition of the
 * Retrieval entity.
 * 
 * @author MyEclipse Persistence Tools
 */

public abstract class AbstractRetrieval implements java.io.Serializable {

	// Fields

	private RetrievalId id;
	private Long startRecordNo;
	private Integer recordsOnPage;
	private String fileId;
	private String source;

	// Constructors

	/** default constructor */
	public AbstractRetrieval() {
	}

	/** minimal constructor */
	public AbstractRetrieval(RetrievalId id) {
		this.id = id;
	}

	/** full constructor */
	public AbstractRetrieval(RetrievalId id, Long startRecordNo,
			Integer recordsOnPage, String fileId, String source) {
		this.id = id;
		this.startRecordNo = startRecordNo;
		this.recordsOnPage = recordsOnPage;
		this.fileId = fileId;
		this.source = source;
	}

	// Property accessors

	public RetrievalId getId() {
		return this.id;
	}

	public void setId(RetrievalId id) {
		this.id = id;
	}

	public Long getStartRecordNo() {
		return this.startRecordNo;
	}

	public void setStartRecordNo(Long startRecordNo) {
		this.startRecordNo = startRecordNo;
	}

	public Integer getRecordsOnPage() {
		return this.recordsOnPage;
	}

	public void setRecordsOnPage(Integer recordsOnPage) {
		this.recordsOnPage = recordsOnPage;
	}

	public String getFileId() {
		return this.fileId;
	}

	public void setFileId(String fileId) {
		this.fileId = fileId;
	}

	public String getSource() {
		return this.source;
	}

	public void setSource(String source) {
		this.source = source;
	}

}
