/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import java.util.Date;

/**
 * AbstractResultSet entity provides the base persistence definition of the
 * ResultSet entity.
 * 
 * @author MyEclipse Persistence Tools
 */

public abstract class AbstractResultSet implements java.io.Serializable {

	// Fields

	private ResultSetId id;
	private Long recordCount;
	private String searchStatus;
	private Date rsDatetime;
	private String source;

	// Constructors

	/** default constructor */
	public AbstractResultSet() {
	}

	/** minimal constructor */
	public AbstractResultSet(ResultSetId id) {
		this.id = id;
	}

	/** full constructor */
	public AbstractResultSet(ResultSetId id, Long recordCount,
			String searchStatus, Date rsDatetime, String source) {
		this.id = id;
		this.recordCount = recordCount;
		this.searchStatus = searchStatus;
		this.rsDatetime = rsDatetime;
		this.source = source;
	}

	// Property accessors

	public ResultSetId getId() {
		return this.id;
	}

	public void setId(ResultSetId id) {
		this.id = id;
	}

	public Long getRecordCount() {
		return this.recordCount;
	}

	public void setRecordCount(Long recordCount) {
		this.recordCount = recordCount;
	}

	public String getSearchStatus() {
		return this.searchStatus;
	}

	public void setSearchStatus(String searchStatus) {
		this.searchStatus = searchStatus;
	}

	public Date getRsDatetime() {
		return this.rsDatetime;
	}

	public void setRsDatetime(Date rsDatetime) {
		this.rsDatetime = rsDatetime;
	}

	public String getSource() {
		return this.source;
	}

	public void setSource(String source) {
		this.source = source;
	}

}
