/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import java.util.Date;

/**
 * AbstractReferralId entity provides the base persistence definition of the
 * ReferralId entity.
 * 
 * @author MyEclipse Persistence Tools
 */

public abstract class AbstractReferralId implements java.io.Serializable {

	// Fields

	private String sessionId;
	private String instance;
	private Integer transactionId;
	private String indexName;
	private String fileId;
	private Date dateTime;

	// Constructors

	/** default constructor */
	public AbstractReferralId() {
	}

	/** full constructor */
	public AbstractReferralId(String sessionId, String instance,
			Integer transactionId, String indexName, String fileId,
			Date dateTime) {
		this.sessionId = sessionId;
		this.instance = instance;
		this.transactionId = transactionId;
		this.indexName = indexName;
		this.fileId = fileId;
		this.dateTime = dateTime;
	}

	// Property accessors

	public String getSessionId() {
		return this.sessionId;
	}

	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	public String getInstance() {
		return this.instance;
	}

	public void setInstance(String instance) {
		this.instance = instance;
	}

	public Integer getTransactionId() {
		return this.transactionId;
	}

	public void setTransactionId(Integer transactionId) {
		this.transactionId = transactionId;
	}

	public String getIndexName() {
		return this.indexName;
	}

	public void setIndexName(String indexName) {
		this.indexName = indexName;
	}

	public String getFileId() {
		return this.fileId;
	}

	public void setFileId(String fileId) {
		this.fileId = fileId;
	}

	public Date getDateTime() {
		return this.dateTime;
	}

	public void setDateTime(Date dateTime) {
		this.dateTime = dateTime;
	}

	public boolean equals(Object other) {
		if ((this == other))
			return true;
		if ((other == null))
			return false;
		if (!(other instanceof AbstractReferralId))
			return false;
		AbstractReferralId castOther = (AbstractReferralId) other;

		return ((this.getSessionId() == castOther.getSessionId()) || (this
				.getSessionId() != null
				&& castOther.getSessionId() != null && this.getSessionId()
				.equals(castOther.getSessionId())))
				&& ((this.getInstance() == castOther.getInstance()) || (this
						.getInstance() != null
						&& castOther.getInstance() != null && this
						.getInstance().equals(castOther.getInstance())))
				&& ((this.getTransactionId() == castOther.getTransactionId()) || (this
						.getTransactionId() != null
						&& castOther.getTransactionId() != null && this
						.getTransactionId()
						.equals(castOther.getTransactionId())))
				&& ((this.getIndexName() == castOther.getIndexName()) || (this
						.getIndexName() != null
						&& castOther.getIndexName() != null && this
						.getIndexName().equals(castOther.getIndexName())))
				&& ((this.getFileId() == castOther.getFileId()) || (this
						.getFileId() != null
						&& castOther.getFileId() != null && this.getFileId()
						.equals(castOther.getFileId())))
				&& ((this.getDateTime() == castOther.getDateTime()) || (this
						.getDateTime() != null
						&& castOther.getDateTime() != null && this
						.getDateTime().equals(castOther.getDateTime())));
	}

	public int hashCode() {
		int result = 17;

		result = 37 * result
				+ (getSessionId() == null ? 0 : this.getSessionId().hashCode());
		result = 37 * result
				+ (getInstance() == null ? 0 : this.getInstance().hashCode());
		result = 37
				* result
				+ (getTransactionId() == null ? 0 : this.getTransactionId()
						.hashCode());
		result = 37 * result
				+ (getIndexName() == null ? 0 : this.getIndexName().hashCode());
		result = 37 * result
				+ (getFileId() == null ? 0 : this.getFileId().hashCode());
		result = 37 * result
				+ (getDateTime() == null ? 0 : this.getDateTime().hashCode());
		return result;
	}

}
