/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

/**
 * AbstractReferral entity provides the base persistence definition of the
 * Referral entity.
 * 
 * @author MyEclipse Persistence Tools
 */

public abstract class AbstractReferral implements java.io.Serializable {

	// Fields

	private ReferralId id;
	private String type;
	private String subtype;
	private String url;
	private String title;
	private String source;

	// Constructors

	/** default constructor */
	public AbstractReferral() {
	}

	/** minimal constructor */
	public AbstractReferral(ReferralId id) {
		this.id = id;
	}

	/** full constructor */
	public AbstractReferral(ReferralId id, String type, String subtype,
			String url, String title, String source) {
		this.id = id;
		this.type = type;
		this.subtype = subtype;
		this.url = url;
		this.title = title;
		this.source = source;
	}

	// Property accessors

	public ReferralId getId() {
		return this.id;
	}

	public void setId(ReferralId id) {
		this.id = id;
	}

	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getSubtype() {
		return this.subtype;
	}

	public void setSubtype(String subtype) {
		this.subtype = subtype;
	}

	public String getUrl() {
		return this.url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getTitle() {
		return this.title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getSource() {
		return this.source;
	}

	public void setSource(String source) {
		this.source = source;
	}

}
