/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

/**
 * AbstractQueryId entity provides the base persistence definition of the
 * QueryId entity.
 * 
 * @author MyEclipse Persistence Tools
 */

public abstract class AbstractQueryId implements java.io.Serializable {

	// Fields

	private String sessionId;
	private String instance;
	private Integer transactionId;

	// Constructors

	/** default constructor */
	public AbstractQueryId() {
	}

	/** full constructor */
	public AbstractQueryId(String sessionId, String instance,
			Integer transactionId) {
		this.sessionId = sessionId;
		this.instance = instance;
		this.transactionId = transactionId;
	}

	// Property accessors

	public String getSessionId() {
		return this.sessionId;
	}

	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	public String getInstance() {
		return this.instance;
	}

	public void setInstance(String instance) {
		this.instance = instance;
	}

	public Integer getTransactionId() {
		return this.transactionId;
	}

	public void setTransactionId(Integer transactionId) {
		this.transactionId = transactionId;
	}

	public boolean equals(Object other) {
		if ((this == other))
			return true;
		if ((other == null))
			return false;
		if (!(other instanceof AbstractQueryId))
			return false;
		AbstractQueryId castOther = (AbstractQueryId) other;

		return ((this.getSessionId() == castOther.getSessionId()) || (this
				.getSessionId() != null
				&& castOther.getSessionId() != null && this.getSessionId()
				.equals(castOther.getSessionId())))
				&& ((this.getInstance() == castOther.getInstance()) || (this
						.getInstance() != null
						&& castOther.getInstance() != null && this
						.getInstance().equals(castOther.getInstance())))
				&& ((this.getTransactionId() == castOther.getTransactionId()) || (this
						.getTransactionId() != null
						&& castOther.getTransactionId() != null && this
						.getTransactionId()
						.equals(castOther.getTransactionId())));
	}

	public int hashCode() {
		int result = 17;

		result = 37 * result
				+ (getSessionId() == null ? 0 : this.getSessionId().hashCode());
		result = 37 * result
				+ (getInstance() == null ? 0 : this.getInstance().hashCode());
		result = 37
				* result
				+ (getTransactionId() == null ? 0 : this.getTransactionId()
						.hashCode());
		return result;
	}

}
