/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import java.util.Date;

/**
 * AbstractQuery entity provides the base persistence definition of the Query
 * entity.
 * 
 * @author MyEclipse Persistence Tools
 */

public abstract class AbstractQuery implements java.io.Serializable {

	// Fields

	private QueryId id;
	private Date queryDatetime;
	private String searchType;
	private Short spatialSearch;
	private Short freeTextSearch;
	private Short temporalSearch;
	private Short fieldedSearch;
	private String queryString;

	// Constructors

	/** default constructor */
	public AbstractQuery() {
	}

	/** minimal constructor */
	public AbstractQuery(QueryId id, Date queryDatetime, String searchType) {
		this.id = id;
		this.queryDatetime = queryDatetime;
		this.searchType = searchType;
	}

	/** full constructor */
	public AbstractQuery(QueryId id, Date queryDatetime, String searchType,
			Short spatialSearch, Short freeTextSearch, Short temporalSearch,
			Short fieldedSearch, String queryString) {
		this.id = id;
		this.queryDatetime = queryDatetime;
		this.searchType = searchType;
		this.spatialSearch = spatialSearch;
		this.freeTextSearch = freeTextSearch;
		this.temporalSearch = temporalSearch;
		this.fieldedSearch = fieldedSearch;
		this.queryString = queryString;
	}

	// Property accessors

	public QueryId getId() {
		return this.id;
	}

	public void setId(QueryId id) {
		this.id = id;
	}

	public Date getQueryDatetime() {
		return this.queryDatetime;
	}

	public void setQueryDatetime(Date queryDatetime) {
		this.queryDatetime = queryDatetime;
	}

	public String getSearchType() {
		return this.searchType;
	}

	public void setSearchType(String searchType) {
		this.searchType = searchType;
	}

	public Short getSpatialSearch() {
		return this.spatialSearch;
	}

	public void setSpatialSearch(Short spatialSearch) {
		this.spatialSearch = spatialSearch;
	}

	public Short getFreeTextSearch() {
		return this.freeTextSearch;
	}

	public void setFreeTextSearch(Short freeTextSearch) {
		this.freeTextSearch = freeTextSearch;
	}

	public Short getTemporalSearch() {
		return this.temporalSearch;
	}

	public void setTemporalSearch(Short temporalSearch) {
		this.temporalSearch = temporalSearch;
	}

	public Short getFieldedSearch() {
		return this.fieldedSearch;
	}

	public void setFieldedSearch(Short fieldedSearch) {
		this.fieldedSearch = fieldedSearch;
	}

	public String getQueryString() {
		return this.queryString;
	}

	public void setQueryString(String queryString) {
		this.queryString = queryString;
	}

}
