/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;
// default package

import java.util.Date;

/**
 * AbstractMercuryRateusId entity provides the base persistence definition of
 * the MercuryRateusId entity.
 * 
 * @author MyEclipse Persistence Tools
 */

public abstract class AbstractMercuryRateusId implements java.io.Serializable {

	// Fields

	private String name;
	private Date rateDate;
	private String instance;
	private String link;
	private String remote;
	private String browser;
	private String affiliation;
	private String country;
	private String email;
	private String responseOne;
	private String commentOne;
	private String responseTwo;
	private String commentTwo;
	private String commentThree;
	private String responseText;

	// Constructors

	/** default constructor */
	public AbstractMercuryRateusId() {
	}

	/** minimal constructor */
	public AbstractMercuryRateusId(Date rateDate, String instance) {
		this.rateDate = rateDate;
		this.instance = instance;
	}

	/** full constructor */
	public AbstractMercuryRateusId(String name, Date rateDate, String instance,
			String link, String remote, String browser, String affiliation,
			String country, String email, String responseOne,
			String commentOne, String responseTwo, String commentTwo,
			String commentThree, String responseText) {
		this.name = name;
		this.rateDate = rateDate;
		this.instance = instance;
		this.link = link;
		this.remote = remote;
		this.browser = browser;
		this.affiliation = affiliation;
		this.country = country;
		this.email = email;
		this.responseOne = responseOne;
		this.commentOne = commentOne;
		this.responseTwo = responseTwo;
		this.commentTwo = commentTwo;
		this.commentThree = commentThree;
		this.responseText = responseText;
	}

	// Property accessors

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Date getRateDate() {
		return this.rateDate;
	}

	public void setRateDate(Date rateDate) {
		this.rateDate = rateDate;
	}

	public String getInstance() {
		return this.instance;
	}

	public void setInstance(String instance) {
		this.instance = instance;
	}

	public String getLink() {
		return this.link;
	}

	public void setLink(String link) {
		this.link = link;
	}

	public String getRemote() {
		return this.remote;
	}

	public void setRemote(String remote) {
		this.remote = remote;
	}

	public String getBrowser() {
		return this.browser;
	}

	public void setBrowser(String browser) {
		this.browser = browser;
	}

	public String getAffiliation() {
		return this.affiliation;
	}

	public void setAffiliation(String affiliation) {
		this.affiliation = affiliation;
	}

	public String getCountry() {
		return this.country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getEmail() {
		return this.email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getResponseOne() {
		return this.responseOne;
	}

	public void setResponseOne(String responseOne) {
		this.responseOne = responseOne;
	}

	public String getCommentOne() {
		return this.commentOne;
	}

	public void setCommentOne(String commentOne) {
		this.commentOne = commentOne;
	}

	public String getResponseTwo() {
		return this.responseTwo;
	}

	public void setResponseTwo(String responseTwo) {
		this.responseTwo = responseTwo;
	}

	public String getCommentTwo() {
		return this.commentTwo;
	}

	public void setCommentTwo(String commentTwo) {
		this.commentTwo = commentTwo;
	}

	public String getCommentThree() {
		return this.commentThree;
	}

	public void setCommentThree(String commentThree) {
		this.commentThree = commentThree;
	}

	public String getResponseText() {
		return this.responseText;
	}

	public void setResponseText(String responseText) {
		this.responseText = responseText;
	}

	public boolean equals(Object other) {
		if ((this == other))
			return true;
		if ((other == null))
			return false;
		if (!(other instanceof AbstractMercuryRateusId))
			return false;
		AbstractMercuryRateusId castOther = (AbstractMercuryRateusId) other;

		return ((this.getName() == castOther.getName()) || (this.getName() != null
				&& castOther.getName() != null && this.getName().equals(
				castOther.getName())))
				&& ((this.getRateDate() == castOther.getRateDate()) || (this
						.getRateDate() != null
						&& castOther.getRateDate() != null && this
						.getRateDate().equals(castOther.getRateDate())))
				&& ((this.getInstance() == castOther.getInstance()) || (this
						.getInstance() != null
						&& castOther.getInstance() != null && this
						.getInstance().equals(castOther.getInstance())))
				&& ((this.getLink() == castOther.getLink()) || (this.getLink() != null
						&& castOther.getLink() != null && this.getLink()
						.equals(castOther.getLink())))
				&& ((this.getRemote() == castOther.getRemote()) || (this
						.getRemote() != null
						&& castOther.getRemote() != null && this.getRemote()
						.equals(castOther.getRemote())))
				&& ((this.getBrowser() == castOther.getBrowser()) || (this
						.getBrowser() != null
						&& castOther.getBrowser() != null && this.getBrowser()
						.equals(castOther.getBrowser())))
				&& ((this.getAffiliation() == castOther.getAffiliation()) || (this
						.getAffiliation() != null
						&& castOther.getAffiliation() != null && this
						.getAffiliation().equals(castOther.getAffiliation())))
				&& ((this.getCountry() == castOther.getCountry()) || (this
						.getCountry() != null
						&& castOther.getCountry() != null && this.getCountry()
						.equals(castOther.getCountry())))
				&& ((this.getEmail() == castOther.getEmail()) || (this
						.getEmail() != null
						&& castOther.getEmail() != null && this.getEmail()
						.equals(castOther.getEmail())))
				&& ((this.getResponseOne() == castOther.getResponseOne()) || (this
						.getResponseOne() != null
						&& castOther.getResponseOne() != null && this
						.getResponseOne().equals(castOther.getResponseOne())))
				&& ((this.getCommentOne() == castOther.getCommentOne()) || (this
						.getCommentOne() != null
						&& castOther.getCommentOne() != null && this
						.getCommentOne().equals(castOther.getCommentOne())))
				&& ((this.getResponseTwo() == castOther.getResponseTwo()) || (this
						.getResponseTwo() != null
						&& castOther.getResponseTwo() != null && this
						.getResponseTwo().equals(castOther.getResponseTwo())))
				&& ((this.getCommentTwo() == castOther.getCommentTwo()) || (this
						.getCommentTwo() != null
						&& castOther.getCommentTwo() != null && this
						.getCommentTwo().equals(castOther.getCommentTwo())))
				&& ((this.getCommentThree() == castOther.getCommentThree()) || (this
						.getCommentThree() != null
						&& castOther.getCommentThree() != null && this
						.getCommentThree().equals(castOther.getCommentThree())))
				&& ((this.getResponseText() == castOther.getResponseText()) || (this
						.getResponseText() != null
						&& castOther.getResponseText() != null && this
						.getResponseText().equals(castOther.getResponseText())));
	}

	public int hashCode() {
		int result = 17;

		result = 37 * result
				+ (getName() == null ? 0 : this.getName().hashCode());
		result = 37 * result
				+ (getRateDate() == null ? 0 : this.getRateDate().hashCode());
		result = 37 * result
				+ (getInstance() == null ? 0 : this.getInstance().hashCode());
		result = 37 * result
				+ (getLink() == null ? 0 : this.getLink().hashCode());
		result = 37 * result
				+ (getRemote() == null ? 0 : this.getRemote().hashCode());
		result = 37 * result
				+ (getBrowser() == null ? 0 : this.getBrowser().hashCode());
		result = 37
				* result
				+ (getAffiliation() == null ? 0 : this.getAffiliation()
						.hashCode());
		result = 37 * result
				+ (getCountry() == null ? 0 : this.getCountry().hashCode());
		result = 37 * result
				+ (getEmail() == null ? 0 : this.getEmail().hashCode());
		result = 37
				* result
				+ (getResponseOne() == null ? 0 : this.getResponseOne()
						.hashCode());
		result = 37
				* result
				+ (getCommentOne() == null ? 0 : this.getCommentOne()
						.hashCode());
		result = 37
				* result
				+ (getResponseTwo() == null ? 0 : this.getResponseTwo()
						.hashCode());
		result = 37
				* result
				+ (getCommentTwo() == null ? 0 : this.getCommentTwo()
						.hashCode());
		result = 37
				* result
				+ (getCommentThree() == null ? 0 : this.getCommentThree()
						.hashCode());
		result = 37
				* result
				+ (getResponseText() == null ? 0 : this.getResponseText()
						.hashCode());
		return result;
	}

}
