/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.email_utils;

import org.hibernate.SessionFactory;
import org.hibernate.Session;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import gov.ornl.mercury3.email_utils.EmailGenerator;
import java.util.*;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Properties;

import gov.ornl.mercury3.email_utils.EmailGenerator;
import gov.ornl.mercury3.services.Mercury_db_ServiceImpl;

import java.io.*;

import javax.mail.MessagingException;
import gov.ornl.mercury3.services.*;

/**
 * Controller for the post session rating servlet ??.
 *
 */
public class RateUsHandler {
	private Session session;
	private List siteList;
	private static String[] emailTo;
	private static String emailFrom;
	private static String title;
	private static Properties properties;
	// private static String propertyFile;
	// private static String DB_PROPERTY_FILE = "nbii_support_email.properties";

	ApplicationContext ctx = null;
	
	Mercury_db_ServiceImpl psi = new Mercury_db_ServiceImpl();
	//HashMap<String, Object> hmProps = new HashMap<String, Object>();
	public RateUsHandler() {
		try {

			ctx = new ClassPathXmlApplicationContext("applicationContext.xml");
			psi = (Mercury_db_ServiceImpl) ctx.getBean("mercury_db_Service");
			
			

			//debug = Boolean.parseBoolean((String) (hmProps.get("debug")));
		} catch (HibernateException e) {
			e.printStackTrace();
		}
	}

	static {
		 ApplicationContext factory2 = null;
		 factory2 = new ClassPathXmlApplicationContext(
			"gov/ornl/mercury3/services/applicationContext.xml");
			 
			 properties = (Properties) factory2.getBean("emailUtil");
		
		try {			
			emailTo = ((String) properties.getProperty("email")).split(",");
			emailFrom = (String) properties.getProperty("emailFrom");
			title = (String) properties.getProperty("title");
			//System.out.println("emailTo"+ emailTo[1]);
			
		} catch (Exception fe) {
			System.err.println(fe.getMessage());
		} 
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		RateUsHandler instance = new RateUsHandler();

		try {

			/*
			 * List events = instance.getListOfRateUs(); for (int i = 0; i<events.size();
			 * i++) { NbiiMercuryRateus theEvent = (NbiiMercuryRateus)
			 * events.get(i); System.out.println("********* email: " +
			 * theEvent.getEmail()); }
			 */
			// for independent testing
			// instance.setRateUs("NBII(NEW)","testlink","testIP","testbrowser","testResponse1","testcomm1","testRes2","testCom2","testCom3");
			// System.exit(0);
		} catch (Exception e) {
			System.out.println("ERROR=" + e.getMessage());
		}

	}

	public List getListOfRateUs() throws Exception {

		Transaction tx = null;
		List result = null;
		try {
			tx = session.beginTransaction();

			Query query = session.createQuery("from gov.ornl.mercury3.email");
			result = query.list();
			tx.commit();
			// System.out.println("result="+result.size());
			return result;
		} catch (Exception ex) {
			System.out.println("ex==" + ex);
			if (tx != null) {
				try {
					tx.rollback();
				} catch (Exception rbe) {
					System.out.println("ERROR:==" + rbe.getMessage());
					// log.warn(rbe.getMessage(), rbe);
					throw ex; // original exception
				}
			}
		} finally {
			// System.out.println("ARMSiteHandler >> closing the connection");
			// HibernateSessionFactory.closeSession();
			// System.out.println("ARMSiteHandler >> closed the connection");
		}
		return result;
	}

	public String getTest() {
		return "true";
	}

	public String setRateUs(String instance, String link, String rIPAndHost,
			String rBrowser, String response1, String comment1,
			String response2, String comment2, String comment3, String email)
			throws Exception {
		String saved = "TRUE";
		Transaction tx = null;
		List result = null;
		try {
			//System.out.println("Inside setRateUs()" + email);

			MercuryRateus rateUs = new MercuryRateus();
			rateUs.setId(new MercuryRateusId("", new java.util.Date(),
					instance, link, rIPAndHost, rBrowser, "", "", "",
					response1, comment1, response2, comment2, comment3, ""));
			// session.save(rateUs);
			// tx.commit();
			//System.out.println("before  psi.saveRateUs(rateUs);");
			psi.saveRateUs(rateUs);
			// send mail notification
			System.out.println("before sending the email");
			sendNotificationMail(new java.util.Date() + "\n" + "Instance:"
					+ instance + "\n" + "\nIP Address:" + rIPAndHost + "\n"
					+ "\nClicked:" + link + "\n" + "\nSearch satisfaction:"
					+ response1 + " " + comment1 + "\n"
					+ "\nResults satisfaction:" + response2 + "\n"
					+ "\nSuggested Datasets:" + comment3 + "\n" + "\nEmail:"
					+ email);
		} catch (Exception ex) {
			saved = "FALSE";
			System.out.println("ex==" + ex);
			ex.printStackTrace();
			if (tx != null) {
				try {
					tx.rollback();
				} catch (Exception rbe) {
					System.out.println("ERROR:==" + rbe.getMessage());
					// log.warn(rbe.getMessage(), rbe);
					throw ex; // original exception
				}
			}
		} finally {
			// System.out.println("ARMSiteHandler >> closing the connection");
			// HibernateSessionFactory.closeSession();
			// System.out.println("ARMSiteHandler >> closed the connection");
		}
		return saved;
	}

	public String SendEmailOnly(String instance, String link, String rIPAndHost,
			String rBrowser, String response1, String comment1,
			String response2, String comment2, String comment3, String email, String name, String country, String inst, String respond)
			throws Exception {
			String saved = "TRUE";
			//System.out.println("inside Sendemail for instance:" +instance);			
			if(respond.trim().equalsIgnoreCase("TRUE")){
				respond = "Participant has requested a response to comments.";
			}
			else{
				respond = "No response required";
			}
			sendNotificationMail(new java.util.Date() + "\n" + "Instance:"
					+ instance + "\n" + "\nIP Address:" + rIPAndHost + "\n"
					+"\nBrowser:" + rBrowser + "\nClicked:" + link + "\n" 
					+ "\nSearch satisfaction:" + response1 + " " + comment1 + "\n"
					+ "\nResults satisfaction:" + response2 + "\n"
					+ "\nSuggested Datasets:" + comment3 + "\n" + "\nRespondent:"
					+ name+"\n"+inst+"\n"+country+"\n"+email+"\n\n"+"*"+respond);
	
			return saved;
	}

	private void sendNotificationMail(String message) {
		try {

			// System.out.println("inside send notification");
			for (int i = 0; i < emailTo.length; i++) {
				 System.out.println("message"+message);
				 System.out.println("Sending email to: "+emailTo[i]);
				EmailGenerator.sendHTMLMail(emailTo[i], title, message,
						emailFrom);

			}
		} catch (MessagingException me) {
			System.out
					.println("Problems in sending messages" + me.getMessage());
		} catch (Exception e) {
			System.out.println("ERROR:" + e.getMessage());
			e.printStackTrace();
		}
	}
}
