/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.email_utils;

/** 
 * uility class for the EmailGenerator
 * Copyright:    ORNL 2003
 * @Modified by $Author: cxl $
 * @author : Giri Palanisamy
 * @version $Id: ByteArrayDataSource.java,v 1.3 2005/05/03 19:46:05 cxl Exp $ 
 */

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

import javax.activation.DataSource;

/** 
 * Used to create a DataSource for the mail message.
 * @see MailHelper
 */

class ByteArrayDataSource implements DataSource {
    private byte[] data; // data for mail message 
    private String type; // content type/mime type

    /** 
     * Create a DataSource from a String 
     * @param data is the contents of the mail message 
     * @param type is the mime-type such as text/html
     */
    ByteArrayDataSource(String data, String type) {
        try {
            // Assumption that the string contains only ascii 
            // characters ! Else just pass in a charset into this 
            // constructor and use it in getBytes() 
            this.data = data.getBytes("UTF-8");
        } catch (UnsupportedEncodingException uex) {
        }
        this.type = type;
    }

    //DataSource interface methods
    public InputStream getInputStream() throws IOException {
        if (data == null)
            throw new IOException("no data");
        return new ByteArrayInputStream(data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("cannot do this");
    }

    public String getContentType() {
        return type;
    }

    public String getName() {
        return "dummy";
    }

}
