/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.dwr_utils.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Collections;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import gov.ornl.mercury3.commands.Configuration;

/**
 * Keywords lookup and auto complete  utility.
 *
 */
public class RemoteAutoCompleteImpl{

	private ArrayList addressCode = new ArrayList();
	public Properties properties = null;
	ApplicationContext factory = new ClassPathXmlApplicationContext(
			"gov/ornl/mercury3/services/applicationContext.xml");
	ApplicationContext factory2 = new ClassPathXmlApplicationContext("Mercury3Properties.xml");//

	private String delimiter = ",";
	
	/**
	 * Method to be called to set the words
	 */
	public List getMatchedWord(String paramname,final String partSpecies) {		
		properties = (Properties) factory.getBean("NameUtil");
	
		Configuration cv = (Configuration)factory2.getBean("propertiesBean");	
		 HashMap hmProps =cv.getProperties();				 
		 String delimiter2 = (String)hmProps.get("delimiter");
		 
		 if(null != delimiter2){
			delimiter = delimiter2; 
		 }

	
		String[] sl = properties.getProperty(paramname).split(delimiter);
		
		if(sl != null){
		addressCode = new ArrayList(Arrays.asList(sl));		
		
		List retKeys = new ArrayList();
		for (Iterator iter = addressCode.iterator(); iter.hasNext();) {
			String key = (String) iter.next();
			retKeys.add(key);
			
		}
		Collections.sort(retKeys, String.CASE_INSENSITIVE_ORDER);
		
		return retKeys;		
		}
		else {
		return null;	
		}
	}
}
