/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.dwr_utils;

import gov.ornl.mercury3.commands.Configuration;

import java.util.Properties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import java.util.HashMap;


/**
 * Custom parser for properties file of named delimited keywords.
 */
public class daacList {

	private Properties properties = null;
	private String delimiter = ",";

	/**
	 * Methods for parsing a properties file of named delimited keywords.
	 */
	public daacList() {
		try {
			ApplicationContext factory = new ClassPathXmlApplicationContext(
					"gov/ornl/mercury3/services/applicationContext.xml");
			
			ApplicationContext factory2 = new ClassPathXmlApplicationContext("Mercury3Properties.xml");//

			Configuration cv = (Configuration)factory2.getBean("propertiesBean");
		
			 HashMap hmProps =cv.getProperties();
					 
			 //delimiter = (String)hmProps.get("delimiter");
			  String delimiter2 = (String)hmProps.get("delimiter");
			 
			 if(null != delimiter2){
				delimiter = delimiter2; 
			 }

			
			properties = (Properties) factory.getBean("propKeywords");
			
		} catch (Exception ex1) {
			ex1.printStackTrace();
		}
	}

	/**
	 * Constructs  a String[] by parsing a named delimited String from a properties file.
	 * 
	 * @param keyword1 the keyword1
	 * 
	 * @return the data
	 */
	public String[] getData(String keyword1) {
		String dataList = properties.getProperty(keyword1);
		String[] dataArray = dataList.split(delimiter);
		
		return dataArray;
	}
}
