/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.dwr_utils;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.text.SimpleDateFormat;

/**
* Error Utility Class logs al the errors and debugs in log files
* Modified by $Author: cxl $
* author : Giri Palanisamy
* @version $Id: ErrorLogUtil.java,v 1.6 2004/01/12 19:55:08 cxl Exp $
*/

public class ErrorLogUtil {
  public static final String ERROR_PROPERTY_FILE ="ErrorLogUtil.properties";
  public static final String LOG_ROOT="LogRoot";
  public static final String IS_DEBUG="DEBUG";
   
  static SimpleDateFormat formatterDate = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a");

  private static ErrorLogUtil instance; // The single instance
  private static Properties properties = null;
  private static FileWriter fw = null;
  private static PrintWriter pw = null;
  DateUtil dateUtil = DateUtil.getInstance();

  /*
   * Returns the single instance, creating one if it's the
   * first time this method is called.
   */
  static synchronized public ErrorLogUtil getInstance() 
  {
    if (instance == null) {
      instance = new ErrorLogUtil();
    }
    return instance;
  }

  /**
   * A private constructor since this is a Singleton
   */
  private ErrorLogUtil() 
  {
    super();
  }

  /**
   *  Loads properties and initializes the instance with its values.
   *  from 'ERROR_PROPERTY_FILE'
   */
  static 
  {
    String propertyFile = getInstance().getClass().getResource(ERROR_PROPERTY_FILE).getFile();
    properties = new Properties();
    FileInputStream is = null;
    try
    {
      is = new FileInputStream(propertyFile);
      properties.load(is);
    }
    catch(FileNotFoundException fe)
    {
      System.err.println(fe.getMessage());
    }
    catch(IOException ioe)
    {
      System.err.println(ioe.getMessage());
    }
    finally 
    {
      try 
      {
        is.close();
      }
      catch (Exception e)
      {
        e.printStackTrace();
      }
    }
  }

  /** for turning off/on the debug mode
   * @return boolean for debug mode
   */
  public boolean isDebug()
  {
    if (properties.getProperty(IS_DEBUG).equals("TRUE"))
      return true;
    else
      return false;
  }

  /** Gets the logRoot path set in the property file.
   * @return String log root 
   */
  private String getLogRoot()
  {
    return properties.getProperty(LOG_ROOT);
  }

  
  /** Generates the LogFile name.
   * @return Returns the path to the newly created logFile.
   */
  private String getLogFile(int projectID)
  {
    String logRoot = getLogRoot();
    String logFile = properties.getProperty(""+projectID);
    //System.out.println(logRoot+logFile);        
    return (logRoot+ logFile);
  }

  /** this method gets calld by other classes to log messages, errors and debugs
   * @param message a string message
   * @param objectRef the class object. use 'this' to see the name of the class in
   * log file
   * @param projectID
   */
  public void writeToLog(String message, Object objectRef, int projectID) 
  {       
    try 
    {
      fw = new FileWriter(getLogFile(projectID)+dateUtil.dateToString(new Date(),".yyyy-MM-dd")+".txt", true);
    }
    catch(IOException ioe) 
    {
    }
    pw = new PrintWriter(fw);
    //pw.println(SEPSRSTOR);
    pw.println(formatterDate.format(new java.util.Date())+":"+objectRef.getClass().getName()+" Message:"+message);        
    pw.flush();
  }

  /** An over loaded method gets calld by other classes to log messages, errors and debugs
   * @param message a String message
   * @param classRef a String. for passing the class name in static method
   * @param projectID
   */
  public void writeToLog(String message, String classRef, int projectID) 
  {       
    try 
    {
      fw = new FileWriter(getLogFile(projectID)+dateUtil.dateToString(new Date(),".yyyy-MM-dd")+".txt", true);
    }
    catch(IOException ioe) 
    {
    }
    pw = new PrintWriter(fw);
    pw.println(formatterDate.format( new Date() )+":"+classRef+" Message:"+message);   
    pw.flush();
  }
    
  /** this method gets calld by other classes to log messages, errors and debugs
   * @param message a string message
   * @param objectRef the class object. use 'this' to see the name of the class in
   * log file
   * @param projectID
   */
  public void writeToLog(String message, Object objectRef, String projectID) 
  {       
    try 
    {
      fw = new FileWriter(getLogRoot()+projectID+".log"+dateUtil.dateToString(new Date(),".yyyy-MM-dd")+".txt", true);
    }
    catch(IOException ioe) 
    {
    }
    pw = new PrintWriter(fw);
    //pw.println(SEPSRSTOR);
    pw.println(formatterDate.format(new java.util.Date())+":"+objectRef.getClass().getName()+" Message:"+message);        
    pw.flush();
  }

  /** An over loaded method gets calld by other classes to log messages, errors and debugs
   * @param message a String message
   * @param classRef a String. for passing the class name in static method
   * @param projectID
   */
  public void writeToLog(String message, String classRef, String projectID) 
  {       
    try 
    {
      fw = new FileWriter(getLogRoot()+projectID+".log"+dateUtil.dateToString(new Date(),".yyyy-MM-dd")+".txt", true);
    }
    catch(IOException ioe) 
    {
    }
    pw = new PrintWriter(fw);
    pw.println(formatterDate.format( new Date() )+":"+classRef+" Message:"+message);   
    pw.flush();
  }

}
