/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.dwr_utils; 

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

/**
 * ornldaac3
 * @Created 2007 Aug 16, 2007 12:48:11 PM
 * @author zzr  @Modified by: Ranjeet Devarakonda
 */
public class DateUtil
{
  private static DateUtil instance; // The single instance
  static SimpleDateFormat formatterDate = new SimpleDateFormat("dd-MMM-yy");
  static final long ONE_HOUR = 60 * 60 * 1000L;


  /**
   * Returns the single instance, creating one if it's when the
   * first time this method is called.
   * @return DateUtil The single instance.
   */
  static synchronized public DateUtil getInstance()
  {
    if (instance == null)
    {
      instance = new DateUtil();
    }
    return instance;
  }

  /**
   * A private constructor since this is a Singleton
   */
  private DateUtil()
  {
    super();
  }

  
  /**
   * this returns date or month or year based on the input parameter
   * @param Date as String dd-mm-yyyy format
   * @param value String this must be a month or Date or Year
   * @return int value of the date or month or year
   */  
  public int getDate(String calDate, String value)
  {   
    int date = 0;
    int month = 00;
    int year = 9999;
    int returnValue = 0000;
    
    StringTokenizer st = new StringTokenizer (calDate,"-");
    while (st.hasMoreTokens()){
      month = Integer.parseInt(st.nextToken());
      date = Integer.parseInt(st.nextToken());
      year = Integer.parseInt(st.nextToken());
    }
    if(value.equals("GETDATE"))
    {
      returnValue = date;
    }
    else if (value.equals("GETMONTH"))
    {
      returnValue = month;
    }
    else if (value.equals("GETYEAR"))
    {
      returnValue = year;
    }
    return returnValue;
  }


  /**
   * Change string to java.util.Date -depricated
   * @param String date
   * @return java.util.Date date
   */
  public java.util.Date toDate (String dateString)
  {   
    return toDate(dateString,"MM-dd-yyyy");    
  }

  /**
   * Change java.util.Date to String
   * @param String date
   * @param Sring format
   * @return java.util.date
   */
  public java.util.Date toDate (String dateString,String format)
  {
    java.util.Date aDate = null;
    SimpleDateFormat tdateForm = new SimpleDateFormat (format);
    try
    {
      return tdateForm.parse(dateString);
    }
    catch (Exception e)
    { 
      try
      {
        aDate = tdateForm.parse("01/01/22");
      }
      catch (Exception notlikely){}
    }
    return aDate;
  }

  /**
   * This returns number of days between the two dates.
   * @param Date date1
   * @param Date date2
   * @return long number of days
   */
  public long daysBetween(Date d1, Date d2)
  {
    return ( (d2.getTime() - d1.getTime() + ONE_HOUR) / 
                  (ONE_HOUR * 24));
  }   

  /**
   * Change java.util.Date to java.util.Calendar
   * @param java.util.Date date
   * @return java.util.Calendar
   */
  public Calendar dateToCalendar (Date date)
  {
    //System.out.println("inside dateToCalendar date="+date);
    Calendar calendarDate = Calendar.getInstance();
    calendarDate.setTime(date);
    return calendarDate;
  }
  
  /**
   * Change String date to java.util.Calendar
   * @param String date
   * @return java.util.Calendar
   */
  public Calendar stringToCalendar (String strDate)
  {
    Calendar calendarDate = Calendar.getInstance();
    try
    {
      SimpleDateFormat ksdf = new SimpleDateFormat( "yyyy-MM-dd" ) ;       
      calendarDate.setTime( ksdf.parse( strDate ) ) ; 
    }
    catch (Exception notlikely)
    {     
    }     
    return calendarDate;
  } 
  
  /**
   * Change String date to java.util.Calendar
   * @param String date
   * @return java.util.Calendar
   */
  public Calendar stringToCalendar (String strDate, String strFormat)
  {
    Calendar calendarDate = Calendar.getInstance() ;
    try
    {
      SimpleDateFormat ksdf = new SimpleDateFormat( strFormat ) ;       
      calendarDate.setTime( ksdf.parse( strDate ) ) ; 
    }
    catch (Exception notlikely)
    {     
    }     
    //System.out.println("---->String Date = "+strDate+" and calendar date="+calendarDate.getTime());
    return calendarDate;
  }

  /**
   * Change java.util.Date to String
   * @param Date
   * @return String
   */
  public String dateToString (java.util.Date aDate)
  {    
    return dateToString(aDate,"MM/dd/yyyy");
  }

  /**
   * Change java.util.Date to String with the specific format
   * @param Date
   * @return String
   */
  public String dateToString (java.util.Date aDate, String format)
  {
    SimpleDateFormat dateForm = new SimpleDateFormat (format);
    return dateForm.format(aDate);
  }
  
  /**
   * Change java.util.Calendar to String
   * @param java.util.Calendar 
   * @return String date
   */
  public String dateToString( Calendar calendarDate )
  {
    return dateToString(calendarDate,"yyyy-MM-dd");
  }

  /**
   * Change java.util.Calendar to String
   * @param java.util.Calendar 
   * @return String date
   */
  public String dateToString(Calendar calendarDate, String outPutFormat )
  {
    Date             l_date;
    SimpleDateFormat l_formatter;
    String           l_output;

    if ( calendarDate != null )
    {
      l_date  = calendarDate.getTime();
      l_formatter = new SimpleDateFormat(outPutFormat);
      l_output = l_formatter.format(l_date);
    }
    else
      l_output = "Date unknown";
    return l_output;
  }


  /**
   *  to get the month name
   * @param int month number
   * @return String month name
   */
  public String getMonthString(int month)
  {   
    switch (month)
    {
      case 1:
        return "January";       
      case 2:
        return "February";        
      case 3:
        return "March";       
      case 4:
        return "April";       
      case 5:
        return "May";       
      case 6:
        return "June";        
      case 7:
        return "July";        
      case 8:
        return "August";        
      case 9:
        return "September";       
      case 10:
        return "October";       
      case 11:
        return "November";        
      case 12:
        return "December";        
      default:
        return "January";
    }  
  }

}
