/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.commands;

import gov.ornl.mercury3.web.util.D1DocTransferObject;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * The model class passed to all View objects (JSPs).
 * 
 */
public class SolrTransactionDetail {

    public String suggestion;

    public Object[][] getOntologyList() {
        return ontologyList;
    }

    public void setOntologyList(Object[][] ontologyList) {
        this.ontologyList = ontologyList;
    }

    public Object[][] ontologyList = null;

    private ArrayList<HashMap<String, String>> mlt_list = new ArrayList<HashMap<String, String>>();

    public String errorMsg = "";

    public HashMap cart_urls;

    public String fromBrief = "";

    public String browseStatus = "false";

    public String datasourcemap = "";

    private boolean geoError = false;

    public String datasource = "";

    public String datasourceCode = "";

    public String fileId = "";

    private String contents = "";

    private String xsltFileName = "";

    private String fileName = "";

    private InputStream is;

    private String searchmode;

    public String mercury3_query_string = "";

    private String gui_queryString = "";

    private String sortattribute = "";

    public HashMap solr_facets_map = null;

    public Float maxScore;

    public String facet_str = " ";

    public String facet_str2 = " ";

    public int found;

    public int start;

    private int pageSize;

    private String searchStatus;

    public String queryString = " ";

    public String full_queryString = " ";

    public String plainqueryString = "";

    private List accountsList;

    private ArrayList j_Docs;

    private int current_page;

    private int num_pages;

    public int page_max_count;

    public String nb;

    private Response res;

    private ArrayList briefResList;

    private boolean showFacets;

    private Map<FilterCatField, List> facets = null;

    private ArrayList j_facets = null;

    private List<Map<String, Field>> documents = null;

    private String hideDS = "";

    private String fileurl = "";

    private String pid = "";

    private Set<String> resourceMaps = new HashSet<String>();

    private int d1DataDocCount = 0;

    private List<D1DocTransferObject> d1Docs = null;

    private CoinsBean coins = new CoinsBean();

    private boolean filterForData = true;

    public boolean getFilterForData() {
        return filterForData;
    }

    public void setFilterForData(boolean filterForData) {
        this.filterForData = filterForData;
    }

    public String getPid() {
        return pid;
    }

    public void setPid(String _pid) {
        this.pid = _pid;
    }

    public Set<String> getResourceMaps() {
        return resourceMaps;
    }

    public void setResourceMaps(Set<String> resourceMaps) {
        this.resourceMaps = resourceMaps;
    }

    public String getHideDS() {
        return hideDS;
    }

    public void setHideDS(String hideDS) {
        this.hideDS = hideDS;
    }

    public List<Map<String, Field>> getDocuments() {
        return documents;
    }

    public void setDocuments(List<Map<String, Field>> documents) {
        this.documents = documents;
    }

    public Map<FilterCatField, List> getFacets() {
        return facets;
    }

    public void setFacets(Map<FilterCatField, List> facets) {
        this.facets = facets;
    }

    public Response getRes() {
        return res;
    }

    public void setRes(Response res) {
        this.res = res;
    }

    /**
     * @return Returns the accountsList.
     */
    public List getAccountsList() {
        return accountsList;
    }

    /**
     * @param accountsList
     *            The accountsList to set.
     */
    public void setAccountsList(List accountsList) {
        this.accountsList = accountsList;
    }

    public ArrayList getJ_facets() {
        return j_facets;
    }

    public void setJ_facets(ArrayList j_facets) {
        this.j_facets = j_facets;
    }

    public ArrayList getJ_Docs() {
        return j_Docs;
    }

    public void setJ_Docs(ArrayList docs) {
        j_Docs = docs;
    }

    public String getQueryString() {
        return queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public int getFound() {
        return found;
    }

    public void setFound(int found) {
        this.found = found;
    }

    public String getSearchStatus() {
        return searchStatus;
    }

    public void setSearchStatus(String searchStatus) {
        this.searchStatus = searchStatus;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getStart() {
        return start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getCurrent_page() {
        return current_page;
    }

    public void setCurrent_page(int current_page) {
        this.current_page = current_page;
    }

    public int getNum_pages() {
        return num_pages;
    }

    public void setNum_pages(int num_pages) {
        this.num_pages = num_pages;
    }

    public int getPage_max_count() {
        return page_max_count;
    }

    public void setPage_max_count(int page_max_count) {
        this.page_max_count = page_max_count;
    }

    public String getNb() {
        return nb;
    }

    public void setNb(String nb) {
        this.nb = nb;
    }

    public String getFacet_str() {
        return facet_str;
    }

    public void setFacet_str(String facet_str) {
        this.facet_str = facet_str;
    }

    public HashMap getSolr_facets_map() {
        return solr_facets_map;
    }

    public void setSolr_facets_map(HashMap solr_facets_map) {
        this.solr_facets_map = solr_facets_map;
    }

    public String getSortattribute() {
        return sortattribute;
    }

    public void setSortattribute(String sortattribute) {
        this.sortattribute = sortattribute;
    }

    public String getGui_queryString() {
        return gui_queryString;
    }

    public void setGui_queryString(String gui_queryString) {
        this.gui_queryString = gui_queryString;
    }

    public String getMercury3_query_string() {
        return mercury3_query_string;
    }

    public void setMercury3_query_string(String mercury3_query_string) {
        this.mercury3_query_string = mercury3_query_string;
    }

    public String getFacet_str2() {
        return facet_str2;
    }

    public void setFacet_str2(String facet_str2) {
        this.facet_str2 = facet_str2;
    }

    public Float getMaxScore() {
        return maxScore;
    }

    public void setMaxScore(Float maxScore) {
        this.maxScore = maxScore;
    }

    public ArrayList getBriefResList() {
        return briefResList;
    }

    public void setBriefResList(ArrayList briefResList) {
        this.briefResList = briefResList;
    }

    public String getContents() {
        return contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public InputStream getIs() {
        return is;
    }

    public void setIs(InputStream is) {
        this.is = is;
    }

    public String getFull_queryString() {
        return full_queryString;
    }

    public void setFull_queryString(String full_queryString) {
        this.full_queryString = full_queryString;
    }

    public String getDatasource() {
        return datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public boolean isShowFacets() {
        return showFacets;
    }

    public void setShowFacets(boolean showFacets) {
        this.showFacets = showFacets;
    }

    public boolean isGeoError() {
        return geoError;
    }

    public void setGeoError(boolean geoError) {
        this.geoError = geoError;
    }

    public String getBrowseStatus() {
        return browseStatus;
    }

    public void setBrowseStatus(String browseStatus) {
        this.browseStatus = browseStatus;
    }

    public String getPlainqueryString() {
        return plainqueryString;
    }

    public void setPlainqueryString(String plainqueryString) {
        this.plainqueryString = plainqueryString;
    }

    public String getDatasourcemap() {
        return datasourcemap;
    }

    public void setDatasourcemap(String datasourcemap) {
        this.datasourcemap = datasourcemap;
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFromBrief() {
        return fromBrief;
    }

    public void setFromBrief(String fromBrief) {
        this.fromBrief = fromBrief;
    }

    public HashMap getCart_urls() {
        return cart_urls;
    }

    public void setCart_urls(HashMap cart_urls) {
        this.cart_urls = cart_urls;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getSearchmode() {
        return searchmode;
    }

    public void setSearchmode(String searchmode) {
        this.searchmode = searchmode;
    }

    public ArrayList<HashMap<String, String>> getMlt_list() {
        return mlt_list;
    }

    public void setMlt_list(ArrayList<HashMap<String, String>> mlt_list) {
        this.mlt_list = mlt_list;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDatasourceCode() {
        return datasourceCode;
    }

    public void setDatasourceCode(String datasourceCode) {
        this.datasourceCode = datasourceCode;
    }

    public String getFileurl() {
        return fileurl;
    }

    public void setFileurl(String fileurl) {
        this.fileurl = fileurl;
    }

    public String getSuggestion() {
        return suggestion;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    private String isoContents = "";

    public String getIsoContents() {
        return isoContents;
    }

    public void setIsoContents(String isoContents) {
        this.isoContents = isoContents;
    }

    public List<D1DocTransferObject> getD1Docs() {
        if (d1Docs == null) {
            d1Docs = new ArrayList<D1DocTransferObject>();
        }
        return d1Docs;
    }

    public void setD1Docs(List<D1DocTransferObject> d1Docs) {
        this.d1Docs = d1Docs;
    }

    public int getD1DataDocCount() {
        return d1DataDocCount;
    }

    public void setD1DataDocCount(int count) {
        this.d1DataDocCount = count;
    }

    public CoinsBean getCoins() {
        return coins;
    }

    public void setCoins(CoinsBean coinsBean) {
        this.coins = coinsBean;
    }

    public String getXsltFileName() {
        return xsltFileName;
    }

    public void setXsltFileName(String xsltFileName) {
        this.xsltFileName = xsltFileName;
    }

}
