/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.commands;

public class SolrFields {

  // field list from the solr schema.xml file 2/21/07
  /*
   * 
   * <field name="id" type="string" indexed="true" stored="true"/> <field
   * name="source" type="string" indexed="true" stored="true"/> <field
   * name="sku" type="textTight" indexed="true" stored="true"/> <field
   * name="name" type="text" indexed="true" stored="true"/> <field name="manu"
   * type="text" indexed="true" stored="true"/> <field name="cat" type="text_ws"
   * indexed="true" stored="true" multiValued="true"/> <field name="features"
   * type="text" indexed="true" stored="true" multiValued="true"/> <field
   * name="includes" type="text" indexed="true" stored="true"/>
   * 
   * 
   * <field name="origin" type="text" indexed="true" stored="true"/> <field
   * name="title" type="text" indexed="true" stored="true"/> <field
   * name="geoform" type="text" indexed="true" stored="true"/> <field
   * name="abstract" type="text" indexed="true" stored="true"/> <field
   * name="purpose" type="text" indexed="true" stored="true"/> <field
   * name="beginDate" type="date" indexed="true" stored="true"/> <field
   * name="endDate" type="date" indexed="true" stored="true"/> <field
   * name="fullText" type="text" indexed="true" stored="true"/>
   * 
   * <field name="edition" type="text" indexed="true" stored="true"/> <field
   * name="originator" type="text" indexed="true" stored="true"/> <field
   * name="contactOrganization" type="text" indexed="true" stored="true"/>
   * <field name="keyword" type="text" indexed="true" stored="true"/>
   * 
   * <field name="westBoundCoord" type="float" class="solr.FloatField"
   * indexed="true" stored="true"/> <field name="eastBoundCoord" type="float"
   * class="solr.FloatField" indexed="true" stored="true"/> <field
   * name="southBoundCoord" type="float" class="solr.FloatField" indexed="true"
   * stored="true"/> <field name="northBoundCoord" type="float"
   * class="solr.FloatField" indexed="true" stored="true"/>
   */

  String id;

  String source;

  String sku;

  String name;

  String manu;

  String cat;

  String features;

  String includes;

  String origin;

  String title;

  String geoform;

  String solr_abstract; // abstract is a key word. cannot be used as a variable
                        // assignment

  String purpose;

  String beginDate;

  String endDate;

  String fullText;

  String edition;

  String originator;

  String contactOrganization;

  // keyword is really a space delimited list of keywords
  String keyword;

  // CoOrdinates must be separated out from a string passed in
  String westBoundCoord;

  String eastBoundCoord;

  String southBoundCoord;

  String northBoundCoord;

  public static void main(String[] arg) {

  }

}
