/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.commands;

import java.util.regex.Pattern;

/**
 * Reformats date strings for display.
 *
 */
public class SolrDate {

  private String month;

  private String year;

  private String day;

  public String getMonth() {
    return month;
  }

  public String getYear() {
    return year;
  }

  public boolean setDate(String date) {

    String[] dateArray;
    Pattern p = Pattern.compile("/");
    dateArray = p.split(date);

    if (!(dateArray.length == 3)) {
      return false;
    }

    month = dateArray[0];

    day = dateArray[1];

    year = dateArray[2];

    return true;

  }

  public String getDay() {
    return day;
  }

}
