/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.commands;

import java.io.Serializable;

/**
 * ornldaac3
 * @Created 2007 Aug 16, 2007 12:46:15 PM
 * @author zzr  @Modified by: Ranjeet Devarakonda
 */
public class SessionBean implements Serializable {
	private String sessionId = "";

	private String instanceName = "";

	private String remoteIP = "";

	private String ipName = "";

	private String browserInfo = "";

	private String sessionDate = "";

	private String localuserflag;

	/**
	 * @return int user localuserflag
	 */
	public String getlocaluserflag() {
		return localuserflag;
	}

	public void setlocaluserflag(String i) {
		this.localuserflag = i;
	}

	/**
	 * @return String user sessionID
	 */
	public String getSessionId() {
		return sessionId;
	}

	/**
	 * @param String
	 *            sessionID
	 * 
	 */
	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	/**
	 * @return String user sessionID
	 */
	public String getSessionDate() {
		return sessionDate.toString();
	}

	/**
	 * @param String
	 *            sessionID
	 * 
	 */
	public void setSessionDate(String sessionDate) {
		this.sessionDate = sessionDate;
	}

	/**
	 * @return String instanceName.
	 */
	public String getInstanceName() {
		return instanceName;
	}

	/**
	 * @param String
	 *            instanceName
	 * 
	 */
	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}

	/**
	 * @return String referral remoteIP
	 */
	public String getRemoteIP() {
		return remoteIP;
	}

	/**
	 * @param String
	 *            referral remoteIP
	 * 
	 */
	public void setRemoteIP(String remoteIP) {
		this.remoteIP = remoteIP;
	}

	/**
	 * @return String remote ipName
	 */
	public String getipName() {
		return ipName;
	}

	/**
	 * @param String
	 *            remote ipName
	 * 
	 */
	public void setipName(String ipName) {
		this.ipName = ipName;
	}

	/**
	 * browser information (netscape, IE etc..)
	 * 
	 * @return String browserInfo
	 */
	public String getBrowserInfo() {
		return browserInfo;
	}

	/**
	 * @param String
	 *            browserInfo
	 * 
	 */
	public void setBrowserInfo(String browserInfo) {
		this.browserInfo = browserInfo;
	}

	/**
	 * localUserFlag for eliminating test users
	 * 
	 * @return String localUserFlag
	 */

	/**
	 * @param String
	 *            referral mercuryInstance
	 * 
	 */
}
