/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.commands;

import gov.ornl.mercury3.services.SourceObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

// TODO: Auto-generated Javadoc
/**
 * Holder for search and setup parameters throughout the app.
 */
public class Search_Terms {

    private String rawTerm1 = "";

    private SourceObject so;

    private String includeGlobal = "false";

    private ArrayList term2_list = new ArrayList();

    private String WebAppRoot;

    private String datasource;

    private String complete_shoppingcart_url;

    private Terms Searchmode;

    private HashMap dataValue;

    private HashMap parsed_request_terms;

    private HashMap newparsed_request_terms;

    private HashMap nsidc_queryParms;

    private HashMap daac_request_terms;

    private HashMap<String, String[]> mlt_request_terms;

    private HashMap ciesin_request_terms;

    private HashMap gcmd_request_terms;

    private HashMap ccin_request_terms;

    private HashMap anyones_queryParms;

    private String additional_datasource;
    private String browseStatus;
    private int page = 1;

    private String browse_field;
    private String browse_path;
    private String browse_source;
    private Terms browse;

    private String mercury3_query_string;

    private String[] del_facet_array;

    private String full_queryString;

    private Terms term1;

    private Terms term2;

    private Terms term3;

    private Terms term4;

    private Terms term5;

    private Terms term6;

    private Terms term7;

    private Terms term8;

    private Terms term9;

    private Terms term12;

    private Terms facet;

    private String queryString = "";

    private int pageSize;

    private int start = 0;

    private HashMap solr_facets_map;

    private int current_page = 1;

    private int responses = 0;

    private int num_pages = 1;

    private int page_max_count;

    private String source;

    private String solrdb;

    private List facetsList = new ArrayList();

    private String sortattribute = "default";

    private String facet_init;

    private String gui_queryString;

    private String[] datasourcearray;

    private ArrayList datasources;

    private ArrayList lterSites;

    private String hideDS;

    private boolean isRSS = false;
    private boolean isMLT = false;
    private String feedValue = "";

    private boolean filterForData = false;

    public boolean getFilterForData() {
        return filterForData;
    }

    public boolean isFilterForData() {
        return filterForData;
    }

    public void setFilterForData(boolean filterForDataValue) {
        this.filterForData = filterForDataValue;
    }

    /**
     * Controls whether a faceted datasource list is displayed.
     * 
     * @return the hide ds flag
     */
    public String getHideDS() {
        return hideDS;
    }

    /**
     * Controls whether a faceted datasource list is displayed.
     * 
     * @param hideDS
     *            the new hide ds flag
     */
    public void setHideDS(String hideDS) {
        this.hideDS = hideDS;
    }

    /**
     * The number of items to display in a brief JSP response.
     * 
     * @return the num_pages
     */
    public int getNum_pages() {
        return num_pages;
    }

    /**
     * Sets The number of items to display in a brief JSP response.
     * 
     * @param num_pages
     *            the new num_pages
     */
    public void setNum_pages(int num_pages) {
        this.num_pages = num_pages;
    }

    /**
     * List of fields selected from the solr schema for faceting. Initialized by
     * injection.
     * 
     * @return the solr_facets_map
     */
    public HashMap getSolr_facets_map() {
        return solr_facets_map;
    }

    /**
     * List of fields selected from the solr schema for faceting. Initialized by
     * injection.
     * 
     * @param solr_facets_map
     *            the new solr_facets_map
     */
    public void setSolr_facets_map(HashMap solr_facets_map) {
        this.solr_facets_map = solr_facets_map;
    }

    /**
     * Adds the solr facets.
     * 
     * @param key
     *            the key
     * @param Value
     *            the value
     * 
     * @return true, if successful
     */
    public boolean addSolrFacets(String key, String Value) {

        this.solr_facets_map.put(key, Value);
        return true;
    }

    /**
     * Removes the solr facets.
     * 
     * @param key
     *            the key
     * @param Value
     *            the value
     * 
     * @return true, if successful
     */
    public boolean removeSolrFacets(String key, String Value) {

        this.solr_facets_map.remove(key);
        return true;
    }

    /**
     * Gets the term7.
     * 
     * @return the term7
     */
    public Terms getTerm7() {
        return term7;
    }

    /**
     * Sets the term7.
     * 
     * @param term7
     *            the new term7
     */
    public void setTerm7(Terms term7) {
        this.term7 = term7;
    }

    /**
     * Gets the term1.
     * 
     * @return the term1
     */
    public Terms getTerm1() {
        return term1;
    }

    /**
     * Sets the term1.
     * 
     * @param term1
     *            the new term1
     */
    public void setTerm1(Terms term1) {
        this.term1 = term1;
    }

    /**
     * Gets the term2.
     * 
     * @return the term2
     */
    public Terms getTerm2() {
        return term2;
    }

    /**
     * Sets the term2.
     * 
     * @param term2
     *            the new term2
     */
    public void setTerm2(Terms term2) {
        this.term2 = term2;
    }

    /**
     * Gets the term3.
     * 
     * @return the term3
     */
    public Terms getTerm3() {
        return term3;
    }

    /**
     * Sets the term3.
     * 
     * @param term3
     *            the new term3
     */
    public void setTerm3(Terms term3) {
        this.term3 = term3;
    }

    /**
     * Gets the term4.
     * 
     * @return the term4
     */
    public Terms getTerm4() {
        return term4;
    }

    /**
     * Sets the term4.
     * 
     * @param term4
     *            the new term4
     */
    public void setTerm4(Terms term4) {
        this.term4 = term4;
    }

    /**
     * Gets the term5.
     * 
     * @return the term5
     */
    public Terms getTerm5() {
        return term5;
    }

    /**
     * Sets the term5.
     * 
     * @param term5
     *            the new term5
     */
    public void setTerm5(Terms term5) {
        this.term5 = term5;
    }

    /**
     * Gets the term6.
     * 
     * @return the term6
     */
    public Terms getTerm6() {
        return term6;
    }

    /**
     * Sets the term6.
     * 
     * @param term6
     *            the new term6
     */
    public void setTerm6(Terms term6) {
        this.term6 = term6;
    }

    /**
     * Gets the page size.
     * 
     * @return the page size
     */
    public int getPageSize() {
        return pageSize;
    }

    /**
     * Sets the page size.
     * 
     * @param pageSize
     *            the new page size
     */
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * Gets the query string.
     * 
     * @return the query string
     */
    public String getQueryString() {
        return queryString;
    }

    /**
     * Sets the query string.
     * 
     * @param queryString
     *            the new query string
     */
    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    /**
     * Record start number for the current Query.
     * 
     * @return the start
     */
    public int getStart() {
        return start;
    }

    /**
     * Record start number for the current Query.
     * 
     * @param start
     *            the new start
     */
    public void setStart(int start) {
        this.start = start;
    }

    /**
     * Gets the facet.
     * 
     * @return the facet
     */
    public Terms getFacet() {
        return facet;
    }

    /**
     * Sets the facet.
     * 
     * @param facet
     *            the new facet
     */
    public void setFacet(Terms facet) {
        this.facet = facet;
    }

    /**
     * Gets the current_page.
     * 
     * @return the current_page
     */
    public int getCurrent_page() {
        return current_page;
    }

    /**
     * Sets the current_page.
     * 
     * @param current_page
     *            the new current_page
     */
    public void setCurrent_page(int current_page) {
        this.current_page = current_page;
    }

    /**
     * Gets the responses.
     * 
     * @return the responses
     */
    public int getResponses() {
        return responses;
    }

    /**
     * Sets the responses.
     * 
     * @param responses
     *            the new responses
     */
    public void setResponses(int responses) {
        this.responses = responses;
    }

    /**
     * Gets the page_max_count.
     * 
     * @return the page_max_count
     */
    public int getPage_max_count() {
        return page_max_count;
    }

    /**
     * Sets the page_max_count.
     * 
     * @param page_max_count
     *            the new page_max_count
     */
    public void setPage_max_count(int page_max_count) {
        this.page_max_count = page_max_count;
    }

    /**
     * Gets the SOLR database name.
     * 
     * @return the solrdb
     */
    public String getSolrdb() {
        return solrdb;
    }

    /**
     * Sets the SOLR database name.
     * 
     * @param solrdb
     *            the new solrdb
     */
    public void setSolrdb(String solrdb) {
        this.solrdb = solrdb;
    }

    /**
     * Gets the data source.
     * 
     * @return the source
     */
    public String getSource() {
        return source;
    }

    /**
     * Sets the data source.
     * 
     * @param source
     *            the new source
     */
    public void setSource(String source) {
        this.source = source;
    }

    /**
     * Gets the facets list.
     * 
     * @return the facets list
     */
    public List getFacetsList() {
        return facetsList;
    }

    /**
     * Sets the facets list.
     * 
     * @param facetsList
     *            the new facets list
     */
    public void setFacetsList(List facetsList) {
        this.facetsList = facetsList;
    }

    /**
     * Gets the datasourcearray.
     * 
     * @return the datasourcearray
     */
    public String[] getDatasourcearray() {
        return datasourcearray;
    }

    /**
     * Sets the datasourcearray.
     * 
     * @param datasourcearray
     *            the new datasourcearray
     */
    public void setDatasourcearray(String[] datasourcearray) {
        this.datasourcearray = datasourcearray;
    }

    /**
     * Gets the facet_init.
     * 
     * @return the facet_init
     */
    public String getFacet_init() {
        return facet_init;
    }

    /**
     * Sets the facet_init.
     * 
     * @param facet_init
     *            the new facet_init
     */
    public void setFacet_init(String facet_init) {
        this.facet_init = facet_init;
    }

    /**
     * Gets the datasources.
     * 
     * @return the datasources
     */
    public ArrayList getDatasources() {
        return datasources;
    }

    /**
     * Sets the datasources.
     * 
     * @param datasources
     *            the new datasources
     */
    public void setDatasources(ArrayList datasources) {
        this.datasources = datasources;
    }

    /**
     * Gets the sortattribute.
     * 
     * @return the sortattribute
     */
    public String getSortattribute() {
        return sortattribute;
    }

    /**
     * Sets the sortattribute.
     * 
     * @param sortattribute
     *            the new sortattribute
     */
    public void setSortattribute(String sortattribute) {
        this.sortattribute = sortattribute;
    }

    /**
     * Gets the Prettified string for displaying in the GUI...
     * 
     * @return the gui_query string
     */
    public String getGui_queryString() {
        return gui_queryString;
    }

    /**
     * Prettified string for displaying in the GUI..
     * 
     * @param gui_queryString
     *            the new gui_query string
     */
    public void setGui_queryString(String gui_queryString) {
        this.gui_queryString = gui_queryString;
    }

    /**
     * Gets the mercury3_query_string.
     * 
     * @return the mercury3_query_string
     */
    public String getMercury3_query_string() {
        return mercury3_query_string;
    }

    /**
     * Sets the mercury3_query_string.
     * 
     * @param mercury3_query_string
     *            the new mercury3_query_string
     */
    public void setMercury3_query_string(String mercury3_query_string) {
        this.mercury3_query_string = mercury3_query_string;
    }

    /**
     * Gets the del_facet_array.
     * 
     * @return the del_facet_array
     */
    public String[] getDel_facet_array() {
        return del_facet_array;
    }

    /**
     * Sets the del_facet_array.
     * 
     * @param del_facet_array
     *            the new del_facet_array
     */
    public void setDel_facet_array(String[] del_facet_array) {
        this.del_facet_array = del_facet_array;
    }

    /**
     * Gets the full_query string.
     * 
     * @return the full_query string
     */
    public String getFull_queryString() {
        return full_queryString;
    }

    /**
     * Sets the full_query string.
     * 
     * @param full_queryString
     *            the new full_query string
     */
    public void setFull_queryString(String full_queryString) {
        this.full_queryString = full_queryString;
    }

    /**
     * Gets the browse.
     * 
     * @return the browse
     */
    public Terms getBrowse() {
        return browse;
    }

    /**
     * Sets the browse.
     * 
     * @param browse
     *            the new browse
     */
    public void setBrowse(Terms browse) {
        this.browse = browse;
    }

    /**
     * Gets the browse_field.
     * 
     * @return the browse_field
     */
    public String getBrowse_field() {
        return browse_field;
    }

    /**
     * Sets the browse_field.
     * 
     * @param browse_field
     *            the new browse_field
     */
    public void setBrowse_field(String browse_field) {
        this.browse_field = browse_field;
    }

    /**
     * Gets the browse_path.
     * 
     * @return the browse_path
     */
    public String getBrowse_path() {
        return browse_path;
    }

    /**
     * Sets the browse_path.
     * 
     * @param browse_path
     *            the new browse_path
     */
    public void setBrowse_path(String browse_path) {
        this.browse_path = browse_path;
    }

    /**
     * Gets the browse_source.
     * 
     * @return the browse_source
     */
    public String getBrowse_source() {
        return browse_source;
    }

    /**
     * Sets the browse_source.
     * 
     * @param browse_source
     *            the new browse_source
     */
    public void setBrowse_source(String browse_source) {
        this.browse_source = browse_source;
    }

    /**
     * Gets the page.
     * 
     * @return the page
     */
    public int getPage() {
        return page;
    }

    /**
     * Sets the page.
     * 
     * @param page
     *            the new page
     */
    public void setPage(int page) {
        this.page = page;
    }

    /**
     * Gets the browse status.
     * 
     * @return the browse status
     */
    public String getBrowseStatus() {
        return browseStatus;
    }

    /**
     * Sets the browse status.
     * 
     * @param browseStatus
     *            the new browse status
     */
    public void setBrowseStatus(String browseStatus) {
        this.browseStatus = browseStatus;
    }

    /**
     * Gets the term8.
     * 
     * @return the term8
     */
    public Terms getTerm8() {
        return term8;
    }

    /**
     * Sets the term8.
     * 
     * @param term8
     *            the new term8
     */
    public void setTerm8(Terms term8) {
        this.term8 = term8;
    }

    /**
     * Gets the term9.
     * 
     * @return the term9
     */
    public Terms getTerm9() {
        return term9;
    }

    /**
     * Sets the term9.
     * 
     * @param term9
     *            the new term9
     */
    public void setTerm9(Terms term9) {
        this.term9 = term9;
    }

    /**
     * Gets the checks if is rss.
     * 
     * @return the checks if is rss
     */
    public boolean getIsRSS() {
        return isRSS;
    }

    /**
     * Sets the rSS.
     * 
     * @param isRSS
     *            the new rSS
     */
    public void setRSS(boolean isRSS) {
        this.isRSS = isRSS;
    }

    /**
     * Gets the term12.
     * 
     * @return the term12
     */
    public Terms getTerm12() {
        return term12;
    }

    /**
     * Sets the term12.
     * 
     * @param term12
     *            the new term12
     */
    public void setTerm12(Terms term12) {
        this.term12 = term12;
    }

    /**
     * Gets the additional_datasource.
     * 
     * @return the additional_datasource
     */
    public String getAdditional_datasource() {
        return additional_datasource;
    }

    /**
     * Sets the additional_datasource.
     * 
     * @param additional_datasource
     *            the new additional_datasource
     */
    public void setAdditional_datasource(String additional_datasource) {
        this.additional_datasource = additional_datasource;
    }

    /**
     * Gets the lter sites.
     * 
     * @return the lter sites
     */
    public ArrayList getLterSites() {
        return lterSites;
    }

    /**
     * Sets the lter sites.
     * 
     * @param lterSites
     *            the new lter sites
     */
    public void setLterSites(ArrayList lterSites) {
        this.lterSites = lterSites;
    }

    /**
     * Gets the feed value.
     * 
     * @return the feed value
     */
    public String getFeedValue() {
        return feedValue;
    }

    /**
     * Sets the feed value.
     * 
     * @param feedValue
     *            the new feed value
     */
    public void setFeedValue(String feedValue) {
        this.feedValue = feedValue;
    }

    /**
     * Gets the parsed_request_terms.
     * 
     * @return the parsed_request_terms
     */
    public HashMap getParsed_request_terms() {
        return parsed_request_terms;
    }

    /**
     * Sets the parsed_request_terms.
     * 
     * @param parsed_request_terms
     *            the new parsed_request_terms
     */
    public void setParsed_request_terms(HashMap parsed_request_terms) {
        this.parsed_request_terms = parsed_request_terms;
    }

    /**
     * Gets the newparsed_request_terms.
     * 
     * @return the newparsed_request_terms
     */
    public HashMap getNewparsed_request_terms() {
        return newparsed_request_terms;
    }

    /**
     * Sets the newparsed_request_terms.
     * 
     * @param newparsed_request_terms
     *            the new newparsed_request_terms
     */
    public void setNewparsed_request_terms(HashMap newparsed_request_terms) {
        this.newparsed_request_terms = newparsed_request_terms;
    }

    /**
     * Gets the nsidc_query parms.
     * 
     * @return the nsidc_query parms
     */
    public HashMap getNsidc_queryParms() {
        return nsidc_queryParms;
    }

    /**
     * Sets the nsidc_query parms.
     * 
     * @param nsidc_queryParms
     *            the new nsidc_query parms
     */
    public void setNsidc_queryParms(HashMap nsidc_queryParms) {
        this.nsidc_queryParms = nsidc_queryParms;
    }

    /**
     * Gets the daac_request_terms.
     * 
     * @return the daac_request_terms
     */
    public HashMap getDaac_request_terms() {
        return daac_request_terms;
    }

    /**
     * Sets the daac_request_terms.
     * 
     * @param daac_request_terms
     *            the new daac_request_terms
     */
    public void setDaac_request_terms(HashMap daac_request_terms) {
        this.daac_request_terms = daac_request_terms;
    }

    /**
     * Gets the ciesin_request_terms.
     * 
     * @return the ciesin_request_terms
     */
    public HashMap getCiesin_request_terms() {
        return ciesin_request_terms;
    }

    /**
     * Sets the ciesin_request_terms.
     * 
     * @param ciesin_request_terms
     *            the new ciesin_request_terms
     */
    public void setCiesin_request_terms(HashMap ciesin_request_terms) {
        this.ciesin_request_terms = ciesin_request_terms;
    }

    /**
     * Gets the gcmd_request_terms.
     * 
     * @return the gcmd_request_terms
     */
    public HashMap getGcmd_request_terms() {
        return gcmd_request_terms;
    }

    /**
     * Sets the gcmd_request_terms.
     * 
     * @param gcmd_request_terms
     *            the new gcmd_request_terms
     */
    public void setGcmd_request_terms(HashMap gcmd_request_terms) {
        this.gcmd_request_terms = gcmd_request_terms;
    }

    /**
     * Gets the ccin_request_terms.
     * 
     * @return the ccin_request_terms
     */
    public HashMap getCcin_request_terms() {
        return ccin_request_terms;
    }

    /**
     * Sets the ccin_request_terms.
     * 
     * @param ccin_request_terms
     *            the new ccin_request_terms
     */
    public void setCcin_request_terms(HashMap ccin_request_terms) {
        this.ccin_request_terms = ccin_request_terms;
    }

    /**
     * Gets the anyones_query parms.
     * 
     * @return the anyones_query parms
     */
    public HashMap getAnyones_queryParms() {
        return anyones_queryParms;
    }

    /**
     * Sets the anyones_query parms.
     * 
     * @param anyones_queryParms
     *            the new anyones_query parms
     */
    public void setAnyones_queryParms(HashMap anyones_queryParms) {
        this.anyones_queryParms = anyones_queryParms;
    }

    /**
     * Gets the complete_shoppingcart_url.
     * 
     * @return the complete_shoppingcart_url
     */
    public String getComplete_shoppingcart_url() {
        return complete_shoppingcart_url;
    }

    /**
     * Sets the complete_shoppingcart_url.
     * 
     * @param complete_shoppingcart_url
     *            the new complete_shoppingcart_url
     */
    public void setComplete_shoppingcart_url(String complete_shoppingcart_url) {
        this.complete_shoppingcart_url = complete_shoppingcart_url;
    }

    /**
     * Gets the data value.
     * 
     * @return the data value
     */
    public HashMap getDataValue() {
        return dataValue;
    }

    /**
     * Sets the data value.
     * 
     * @param dataValue
     *            the new data value
     */
    public void setDataValue(HashMap dataValue) {
        this.dataValue = dataValue;
    }

    /**
     * Gets the web app root.
     * 
     * @return the web app root
     */
    public String getWebAppRoot() {
        return WebAppRoot;
    }

    /**
     * Sets the web app root.
     * 
     * @param webAppRoot
     *            the new web app root
     */
    public void setWebAppRoot(String webAppRoot) {
        WebAppRoot = webAppRoot;
    }

    /**
     * Gets the datasource.
     * 
     * @return the datasource
     */
    public String getDatasource() {
        return datasource;
    }

    /**
     * Sets the datasource.
     * 
     * @param datasource
     *            the new datasource
     */
    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    /**
     * Gets the term2_list.
     * 
     * @return the term2_list
     */
    public ArrayList getTerm2_list() {
        return term2_list;
    }

    /**
     * Sets the term2_list.
     * 
     * @param term2_list
     *            the new term2_list
     */
    public void setTerm2_list(ArrayList term2_list) {
        this.term2_list = term2_list;
    }

    /**
     * Gets the searchmode.
     * 
     * @return the searchmode
     */
    public Terms getSearchmode() {
        return Searchmode;
    }

    /**
     * Sets the searchmode.
     * 
     * @param searchmode
     *            the new searchmode
     */
    public void setSearchmode(Terms searchmode) {
        Searchmode = searchmode;
    }

    /**
     * Gets the include global.
     * 
     * @return the include global
     */
    public String getIncludeGlobal() {
        return includeGlobal;
    }

    /**
     * Sets the include global.
     * 
     * @param includeGlobal
     *            the new include global
     */
    public void setIncludeGlobal(String includeGlobal) {
        this.includeGlobal = includeGlobal;
    }

    /**
     * Gets the so.
     * 
     * @return the so
     */
    public SourceObject getSo() {
        return so;
    }

    /**
     * Sets the so.
     * 
     * @param so
     *            the new so
     */
    public void setSo(SourceObject so) {
        this.so = so;
    }

    /**
     * Checks if is the mLT flag which indicates that this type of solr request
     * is being constructed.
     * 
     * @return true, if is mLT
     */
    public boolean isMLT() {
        return isMLT;
    }

    /**
     * Sets the mLT flag which indicates that this type of solr request is being
     * constructed.
     * 
     * @param isMLT
     *            the new mLT
     */
    public void setMLT(boolean isMLT) {
        this.isMLT = isMLT;
    }

    /**
     * Gets the SOLR More Like This request terms.
     * 
     * @return the mlt_request_terms
     */
    public HashMap<String, String[]> getMlt_request_terms() {
        return mlt_request_terms;
    }

    /**
     * Sets the SOLR More Like This request terms.
     * 
     * @param mlt_request_terms
     *            the mlt_request_terms
     */
    public void setMlt_request_terms(HashMap<String, String[]> mlt_request_terms) {
        this.mlt_request_terms = mlt_request_terms;
    }

    public String getRawTerm1() {
        return rawTerm1;
    }

    public void setRawTerm1(String rawTerm1) {
        this.rawTerm1 = rawTerm1;
    }

}
