/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.commands;

import java.io.Serializable;

/**
 * ornldaac3
 * @Created 2007 Aug 16, 2007 12:46:01 PM
 * @author zzr  @Modified by: Ranjeet Devarakonda
 */

public class Retrieval implements Serializable {
	private String sessionId = "";

	private int transactionID = 0;

	private String instanceName = "";

	private String indexName = ""; // data base index name

	private String elementSet = "";

	private String retDateTime = "";

	private int startRecordNum = 0;

	private int recordsOnPage = 0;

	private String fileID = "";

	private ResultsetBean resultsetbean;

	private String dateTime = "";
	private String source = "";

	/**
	 * @return String user sessionID
	 */
	public Retrieval() {
	}

	public Retrieval(String sid) {
		this.sessionId = sid;
	}

	/**
	 * @param String
	 *            dateTime
	 * 
	 */
	public String getdateTime() {
		return dateTime;
	}

	public void setdateTime(String dateTime) {
		this.dateTime = dateTime;
	}
	/**
	 * @return
	 */
	public String getsource() {
		return source;
	}

	public void setsource(String source) {
		this.source = source;
	}

	/**
	 * @param String
	 *            sessionID
	 * 
	 */
	public String getsessionId() {
		return sessionId;
	}

	public void setsessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	/**
	 * @return int user transactionID
	 */
	public int getTransID() {
		return transactionID;
	}

	/**
	 * @param int
	 *            transactionID
	 * 
	 */
	public void setTransID(int transactionID) {
		this.transactionID = transactionID;
	}

	/**
	 * @return String instanceName.
	 */
	public String getInstanceName() {
		return instanceName;
	}

	/**
	 * @param String
	 *            instanceName
	 * 
	 */
	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}

	/**
	 * @return String indexName.
	 */
	public String getIndexName() {
		return indexName;
	}

	/**
	 * @param String
	 *            indexName
	 * 
	 */
	public void setIndexName(String indexName) {
		this.indexName = indexName;
	}

	/**
	 * @return String elementSet.
	 */
	public String getElementSet() {
		return elementSet;
	}

	/**
	 * @param String
	 *            indexName
	 * 
	 */
	public void setElementSet(String elementSet) {
		this.elementSet = elementSet;
	}

	/**
	 * @return int startRecordNum
	 */
	public int getStartRecNum() {
		return startRecordNum;
	}

	/**
	 * @param int
	 *            startRecordNum
	 * 
	 */
	public void setStartRecNum(int startRecordNum) {
		this.startRecordNum = startRecordNum;
	}

	/**
	 * @return int recordsOnPage
	 */
	public int getRecsOnPage() {
		return recordsOnPage;
	}

	/**
	 * @param int
	 *            recordsOnPage
	 * 
	 */
	public void setRecsOnPage(int recordsOnPage) {
		this.recordsOnPage = recordsOnPage;
	}

	/**
	 * @return String fileID
	 */
	public String getFileID() {
		return fileID;
	}

	/**
	 * @param String
	 *            fileID
	 * 
	 */
	public void setFileID(String fileID) {
		this.fileID = fileID;
	}

	public ResultsetBean getResultsetBean() {
		return resultsetbean;
	}

	public void setsessionId(ResultsetBean resultsetbean) {
		this.resultsetbean = resultsetbean;
	}

}
