/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.commands;

import java.io.Serializable;

/**
 * ornldaac3
 * @Created 2007 Aug 16, 2007 12:45:47 PM
 * @author zzr  @Modified by: Ranjeet Devarakonda
 */
public class ResultsetBean implements Serializable {
	private String sessionId = "";

	private int transactionID = 0;

	private String instanceName = "";

	private String indexName = ""; // data base index name

	private int recordCount;

	private String searchStatus = "";

	private String query = "";

	private String datetime = "";

	private String source;
	/**
	 * @return String user sessionID
	 */

	public ResultsetBean() {
	}

	public ResultsetBean(String sessionId) {
		this.sessionId = sessionId;
	}

	/**
	 * @param String
	 *            datetime
	 * 
	 */
	public String getdatetime() {
		return datetime;
	}

	public void setdatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getsessionId() {
		return sessionId;
	}

	/**
	 * @param String
	 *            sessionID
	 * 
	 */

	public void setsessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	/**
	 * @return int user transactionID
	 */
	public int getTransID() {
		return transactionID;
	}

	/**
	 * @param int
	 *            transactionID
	 * 
	 */
	public void setTransID(int transactionID) {
		this.transactionID = transactionID;
	}

	/**
	 * @return String instanceName.
	 */
	public String getInstanceName() {
		return instanceName;
	}

	/**
	 * @param String
	 *            instanceName
	 * 
	 */
	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}

	/**
	 * @return String indexName.
	 */
	public String getIndexName() {
		return indexName;
	}

	/**
	 * @param String
	 *            indexName
	 * 
	 */
	public void setIndexName(String indexName) {
		this.indexName = indexName;
	}

	/**
	 * @return String recordCount
	 */
	public int getRecordCount() {
		return recordCount;
	}

	/**
	 * @param String
	 *            recordCount
	 * 
	 */
	public void setRecordCount(int recordCount) {
		this.recordCount = recordCount;
	}

	/**
	 * @return String searchStatus
	 */
	public String getSearchStatus() {
		return searchStatus;
	}

	/**
	 * @param String
	 *            searchStatus
	 * 
	 */
	public void setSearchStatus(String searchStatus) {
		this.searchStatus = searchStatus;
	}

	public void String(QueryBean queryBean) {
		queryBean.setsessionId(sessionId);

	}
	
	public String getsource() {
		return source;
	}

	public void setsource(String source) {
		this.source = source;
	}

}
