/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.commands;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a single response to a query. A few standard fields are available
 * such as query time, status, number of documents found and start.
 * 
 * However, most of the interesting data will be in the <code>documents</code>
 * field. This field contains List of <code>Map<String, Field></code>
 * objects.
 * 
 * @author phil
 * 
 */
public class Response implements Serializable {

	/**
	 * 
	 */

	private String suggestion;
	
	private Float maxScore;

	private int pageSize = 0;

	private String QueryString;

	private static final long serialVersionUID = -500123054534726429L;

	private Integer status;

	private Integer qtime;

	private Integer found = 0;

	private Integer start;

	private List<Map<String, Field>> documents = new ArrayList<Map<String, Field>>();

  private LinkedHashMap<FilterCatField, List> facetsList = new LinkedHashMap<FilterCatField, List>();
  
  private ArrayList<HashMap<String,String>> mlt_list = new ArrayList<HashMap<String,String>>();

	private ArrayList<List> j_facets = new ArrayList<List>();

	private ArrayList<String> j_Docs = new ArrayList<String>();

	private List<Map<String, Map<String, List>>> facetsLists = new ArrayList<Map<String, Map<String, List>>>();

  private String rss1;
  
	public String getRss1() {
    return rss1;
  }

  public void setRss1(String rss1) {
    this.rss1 = rss1;
  }

  public LinkedHashMap<FilterCatField, List> getFacets() {
    return facetsList;
  }

  public void setFacets(LinkedHashMap<FilterCatField, List> facetsList) {
    this.facetsList = facetsList;

    // this.facetsLists.add(s1,facetsList);
  }

	public List<Map<String, Field>> getDocuments() {
		return documents;
	}

	public List<Map<String, Map<String, List>>> getFacetsLists() {
		return facetsLists;
	}

	public Integer getFound() {
		return found;
	}

	public Integer getQtime() {
		return qtime;
	}

	public Integer getStart() {
		return start;
	}

	public Integer getStatus() {
		return status;
	}

	public void setFound(Integer found) {
		this.found = found;
	}

	public void setQtime(Integer qtime) {
		this.qtime = qtime;
	}

	public void setStart(Integer start) {
		this.start = start;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public ArrayList<List> getJ_facets() {
		return j_facets;
	}

	public void setJ_facets(ArrayList<List> j_facets) {
		this.j_facets = j_facets;
	}

	public ArrayList<String> getJ_Docs() {
		return j_Docs;
	}

	public void setJ_Docs(ArrayList<String> docs) {
		j_Docs = docs;
	}

	public String getQueryString() {
		return QueryString;
	}

	public void setQueryString(String queryString) {
		QueryString = queryString;
	}

	public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public Float getMaxScore() {
		return maxScore;
	}

	public void setMaxScore(Float maxScore) {
		this.maxScore = maxScore;
	}

	public ArrayList<HashMap<String, String>> getMlt_list() {
		return mlt_list;
	}

	public void setMlt_list(ArrayList<HashMap<String, String>> mlt_list) {
		this.mlt_list = mlt_list;
	}

	public void setSuggestion(String suggestion) {
		this.suggestion = suggestion;
	}

	public String getSuggestion() {
		return suggestion;
	}

}
