/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.commands;

import java.util.HashMap;

/**
 * @Created 2007 Dec 06, 2007 02:30:20 PM
 * @author zzr
 * @Modified by: Ranjeet Devarakonda
 */

public class QueryMap {

	public HashMap<String, String> queryString = new HashMap();
	

	public QueryMap() {
		queries();

	}
	
	public void queries() {

		queryString.put("query=titles",
				"term12attribute=title&term6=all&term6attribute=datasource");
		
		queryString.put("query=file_id",
				"term12attribute=fileID&term6=all&term6attribute=datasource");
		queryString
				.put("query=daac",
						"term12attribute=keyword&term6=&term6=rgd&term6attribute=datasource");
		queryString
				.put("query=rgdkw",
						"term12attribute=keyword&term6=&term6=rgd&term6attribute=datasource");
		queryString
				.put("query=daaclandval",
						"term12attribute=fullText&term6=&term6=landval&term6attribute=datasource");
		queryString
				.put("query=lvkw",
						"term12attribute=keyword&term6=&term6=landval&term6attribute=datasource");
		queryString
				.put(
						"query=eos_berms",
						"term1=\"southern study area \" OR \" boreas ssa\"  OR berms AND ground-based&term1attribute=fullText&term6=daac&term6=landval&term6attribute=datasource");
		queryString
				.put(
						"query=eos_cascades",
						"term2=bigfoot&term2attribute=project&term12=cascades&term2attribute=site&op2=or&term6=daac&term6=landval&term6attribute=datasource");
		queryString
				.put(
						"query=eos_core_sites",
						"term2=ground-based&term2attribute=keyword&term12attribute=site&term6=&term6=landval&term6attribute=datasource");
		queryString
				.put(
						"query=eos_skukuza",
						"term1=skukuza&term1attribute=fullText&op2=and&term2=ground-based&term2attribute=keyword&op2=or&term12=safari 2000&term12attribute=keyword&term6=daac&term6=landval&term6attribute=datasource");

	}

	public String transformQS(String qs, String bt1) {
		if (queryString.containsKey(qs) && bt1 !="") {			
			return queryString.get(qs).concat("&term12=" + bt1.toLowerCase()+"*");
		} 		
		else {
			return queryString.get(qs);
		}

	}
}
