/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.commands;




import javax.validation.constraints.*;

import com.agimatec.validation.constraints.*;


import javax.validation.*;


public class OpenSearchBean {
	

	ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
	Validator validator = factory.getValidator();
	
	@NotEmpty( message="query must contain some text")
	private String query;
	@NotEmpty
	@NotNull(message="start may not be null and must be between 0-9")
	@Pattern(regexp= "[0-9]*", message="start must be between 0-9")
	private String start;
	@NotEmpty 
	@NotNull(message="pagesize may not be null and must be between 10-99")
	@Pattern(regexp="[1-9][0-9]*", message="pagesize must be between 10-99")
	private String pageSize;
	//@NotEmpty( message="osLocation must contain a csv coordinate list ")
	private String osLocation;
	//@NotEmpty( message="startTime must contain an ISO formatted date time")
	private String startTime;
	//@NotEmpty( message="endTime must contain an ISO formatted date time")
	private String endTime;
	//	@NotEmpty( message="format must be atom")
	private String format;
	//	@NotEmpty( message="sortattribute must be a valid index element")
	private String sortattribute;
	//	@NotEmpty( message="stylesheet must be one of: example, example_atom")
	private String stylesheet;
	
	private String datasource;
	
	
	
	public String getQuery() {
		return query;
	}
	public void setQuery(String query) {
		this.query = query;
	}
	public String getStart() {
		return start;
	}
	public void setStart(String start) {
		this.start = start;
	}
	public String getPageSize() {
		return pageSize;
	}
	public void setPageSize(String pageSize) {
		this.pageSize = pageSize;
	}
	public String getOsLocation() {
		return osLocation;
	}
	public void setOsLocation(String osLocation) {
		this.osLocation = osLocation;
	}
	public String getStartTime() {
		return startTime;
	}
	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}
	public String getEndTime() {
		return endTime;
	}
	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}
	public String getFormat() {
		return format;
	}
	public void setFormat(String format) {
		this.format = format;
	}
	public String getSortattribute() {
		return sortattribute;
	}
	public void setSortattribute(String sortattribute) {
		this.sortattribute = sortattribute;
	}
	public String getStylesheet() {
		return stylesheet;
	}
	public void setStylesheet(String stylesheet) {
		this.stylesheet = stylesheet;
	}
	public String getDatasource() {
		return datasource;
	}
	public void setDatasource(String datasource) {
		this.datasource = datasource;
	}
	
	


}
