/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.commands;

import java.util.regex.Pattern;
import static java.lang.Math.max;
import static java.lang.Math.min;

/**
 * Methods for parsing geographic coordinates from a csv list.
 *
 */
public class Geo {
  private float northBoundCoord; // lat_max

  private float southBoundCoord;// lat_min

  private float eastBoundCoord;// lon_min

  private float westBoundCoord;// lon_max

  public boolean setbounds(String bounds) {
    String[] boundsArray;
    Pattern p = Pattern.compile(",");
    boundsArray = p.split(bounds);

    if (!(boundsArray.length == 4)) {
      return false;
    }

    try {
    /*	
      northBoundCoord = max(new Float(boundsArray[0]).floatValue(), new Float(
          boundsArray[2]).floatValue());
      westBoundCoord = max(new Float(boundsArray[1]).floatValue(), new Float(
          boundsArray[3]).floatValue());
      southBoundCoord = min(new Float(boundsArray[0]).floatValue(), new Float(
          boundsArray[2]).floatValue());
      eastBoundCoord = min(new Float(boundsArray[1]).floatValue(), new Float(
          boundsArray[3]).floatValue());
      */
    	
        northBoundCoord = new Float(boundsArray[0]).floatValue();
        westBoundCoord = new Float(boundsArray[1]).floatValue();
        southBoundCoord = new Float(boundsArray[2]).floatValue();
        eastBoundCoord = new Float(boundsArray[3]).floatValue();
        
    } catch (Exception e) {
      e.printStackTrace();
      return false;
    }

    return true;
  }

  public float getEastBoundCoord() {
    return eastBoundCoord;
  }

  public float getNorthBoundCoord() {
    return northBoundCoord;
  }

  public float getSouthBoundCoord() {
    return southBoundCoord;
  }

  public float getWestBoundCoord() {
    return westBoundCoord;
  }
}
