/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.commands;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONException;

/**
 * Data Transfer Object that represents the data needed to construct a coins
 * span tag.
 * 
 * @author sroseboo
 * 
 */
public class CoinsBean {

    private String pid = "";
    private String dataUrl = "";
    private String title = "";
    private String citationDate = "";
    private String author = "";
    private String abstractText = "";
    private String datasource = "";
    private ArrayList<String> keywords = new ArrayList<String>();
    private ArrayList<String> additionalInvestigators = new ArrayList<String>();

    public CoinsBean() {
    }

    public CoinsBean(String pid, String dataUrl, String title, String citationDate, String author,
            String abstractText, String datasource, ArrayList<String> keywords) {
        this.pid = pid;
        this.dataUrl = dataUrl;
        this.title = title;
        this.citationDate = citationDate;
        this.author = author;
        this.abstractText = abstractText;
        this.datasource = datasource;
        this.keywords = keywords;
    }

    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getDataUrl() {
        return dataUrl;
    }

    public void setDataUrl(String dataUrl) {
        this.dataUrl = dataUrl;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCitationDate() {
        return citationDate;
    }

    public void setCitationDate(String citationDate) {
        this.citationDate = citationDate;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAbstractText() {
        return abstractText;
    }

    public void setAbstractText(String abstractText) {
        if (abstractText != null && abstractText.length() > 600) {
            this.abstractText = abstractText.substring(0, 600);
        }
        this.abstractText = abstractText;
    }

    public String getDatasource() {
        return datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public ArrayList<String> getKeywords() {
        return keywords;
    }

    public void setKeywords(ArrayList<String> keywords) {
        this.keywords = keywords;
    }

    public void setKeywordsFromJsonArray(JSONArray keywordsArray) {
        for (int i = 0; i < keywordsArray.length(); i++) {
            try {
                this.keywords.add(keywordsArray.getString(i));
            } catch (JSONException jse) {
                System.out.println("ERROR: could not get keyword from array");
            }
        }
    }

    public ArrayList<String> getAdditionalInvestigators() {
        return additionalInvestigators;
    }

    public void setAdditionalInvestigators(ArrayList<String> additionalInvestigators) {
        String author = getAuthor();
        for (String investigator : additionalInvestigators) {
            if (author != null && investigator != null && author.contains(investigator) == false) {
                this.additionalInvestigators.add(investigator);
            }
        }
        this.additionalInvestigators = additionalInvestigators;
    }

    public void setAdditionalInvestigatorsFromJsonArray(JSONArray investigatorsArray) {
        String author = getAuthor();
        for (int i = 0; i < investigatorsArray.length(); i++) {
            try {
                String investigator = investigatorsArray.getString(i);
                if (author != null && investigator != null
                        && author.contains(investigator) == false) {
                    this.additionalInvestigators.add(investigator);
                }
            } catch (JSONException jse) {
                System.out.println("ERROR: could not get investigator from array");
            }
        }
    }
}
