/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.beans;

import gov.ornl.mercury3.commands.Field;
import gov.ornl.mercury3.commands.FilterCatField;
import gov.ornl.mercury3.commands.Response;
import java.net.URLEncoder;
import java.util.*;

import org.json.JSONObject;
import org.json.JSONArray;

// TODO: Auto-generated Javadoc
/**
 * Contains the methods used to construct the solr queries for the Web Browse Tree.
 *
 */
public class stringBean {

	/**
	 * TEST: method for returning static JSONArray.
	 * 
	 * @return the JSONArray
	 */
	public JSONArray build_jsonarray() {

		JSONArray arr = new JSONArray();

		try {

			JSONObject jsonObj1 = new JSONObject();
			jsonObj1.put("title", "Its just not as right as it could be!!");
			jsonObj1.put("isFolder", "true");
			jsonObj1.put("objectId", "path:dataset&datasource:daac");
			arr.put(jsonObj1);

			JSONObject jsonObj2 = new JSONObject();
			jsonObj2.put("title", "Site->Sensor->Parameter");
			jsonObj2.put("isFolder", "true");
			jsonObj2.put("objectId",
					"path:SiteSensorParameter&field:site&datasource:daac");
			arr.put(jsonObj2);

			JSONObject jsonObj3 = new JSONObject();
			jsonObj3.put("title", "Parameter->Source->Sensor");
			jsonObj3.put("isFolder", "true");
			jsonObj3
					.put("objectId",
							"path:ParameterSourceSensor&field:parameter&datasource:daac");
			arr.put(jsonObj3);

			JSONObject jsonObj4 = new JSONObject();
			jsonObj4.put("title", "Topic->Term->Parameter");
			jsonObj4.put("isFolder", "true");
			jsonObj4.put("objectId",
					"path:TopicTermParameter&field:site&datasource:daac");
			arr.put(jsonObj4);

			JSONObject jsonObj5 = new JSONObject();
			jsonObj5.put("title", "Parameter->Source->Site");
			jsonObj5.put("isFolder", "true");
			jsonObj5.put("objectId",
					"path:ParameterSourceSite&field:parameter&datasource:daac");
			arr.put(jsonObj5);

		} catch (Exception e) {
			e.printStackTrace();
		}

		return arr;
	}

	/**
	 * TEST: Builds and returns a JSONArray based on a BrowseBean object.
	 * 
	 * @param bb the BrowseBean object.
	 * 
	 * @return the jSON array
	 */
	public JSONArray build_jsonarray(browseBean bb) {

		JSONArray arr = new JSONArray();

		if (bb.getobjectId().contains("root")) {

			try {

				JSONObject jsonObj1 = new JSONObject();
				jsonObj1.put("title", "Data Set Title");
				jsonObj1.put("isFolder", "true");
				jsonObj1.put("objectId", "path:dataset&datasource:"
						+ bb.getdataSource());
				arr.put(jsonObj1);

				JSONObject jsonObj2 = new JSONObject();
				jsonObj2.put("title", "Site->Sensor->Parameter");
				jsonObj2.put("isFolder", "true");
				jsonObj2.put("objectId",
						"path:SiteSensorParameter&field:site&datasource:"
								+ bb.getdataSource());
				arr.put(jsonObj2);

				JSONObject jsonObj3 = new JSONObject();
				jsonObj3.put("title", "Parameter->Source->Sensor");
				jsonObj3.put("isFolder", "true");
				jsonObj3.put("objectId",
						"path:ParameterSourceSensor&field:parameter&datasource:"
								+ bb.getdataSource());
				arr.put(jsonObj3);

				JSONObject jsonObj4 = new JSONObject();
				jsonObj4.put("title", "Topic->Term->Parameter");
				jsonObj4.put("isFolder", "true");
				jsonObj4.put("objectId",
						"path:TopicTermParameter&field:topic&datasource:"
								+ bb.getdataSource());
				arr.put(jsonObj4);

				JSONObject jsonObj5 = new JSONObject();
				jsonObj5.put("title", "Parameter->Source->Site");
				jsonObj5.put("isFolder", "true");
				jsonObj5.put("objectId",
						"path:ParameterSourceSite&field:parameter&datasource:"
								+ bb.getdataSource());
				arr.put(jsonObj5);

			} catch (Exception e) {
				e.printStackTrace();
			}

		}

		return arr;
	}

	/**
	 * TEST: Builds a JSONArray given an array.
	 * 
	 * @param titles the document titles
	 * 
	 * @return the jSON array
	 */
	public JSONArray build_dynamic_jsonarray(ArrayList titles) {

		JSONArray arr = new JSONArray();

		Iterator it = titles.iterator();
		int counter = 0;

		for (int i = 0; i < 100; i++) {

			try {
				counter++;
				JSONObject jsonObj1 = new JSONObject();
				jsonObj1.put("title", it.next());
				jsonObj1.put("isFolder", "false");
				jsonObj1.put("objectId", "dataset" + counter);
				arr.put(jsonObj1);

			} catch (Exception e) {
				e.printStackTrace();
			}

		}

		return arr;
	}

	JSONArray arr = new JSONArray();

	/**
	 * TEST: Builds JSONArray given a SOLR response object.
	 * 
	 * @param res the res
	 * 
	 * @return the jSON array
	 */
	public JSONArray build_dynamic_jsonarray(Response res) {

		JSONArray arr = new JSONArray();
		int counter = 0;
		List<Map<String, Field>> documents;
		if (!(null == res.getDocuments())) {
			documents = res.getDocuments();

			Iterator it2 = documents.iterator();

			while (it2.hasNext() && counter < 50) {
				Map<String, Field> m2 = (Map) it2.next();

				try {
					counter++;
					JSONObject jsonObj1 = new JSONObject();
					jsonObj1.put("title", m2.get("title").getValue());
					jsonObj1.put("object", "href:" + m2.get("id").getValue());
					jsonObj1.put("isFolder", "false");
					jsonObj1.put("objectId", "dataset" + counter);
					arr.put(jsonObj1);

				} catch (Exception e) {
					e.printStackTrace();
				}

			}

		}

		return arr;
	}

	/**
	 * TEST: Builds a JSONArray given a solr document response object and a datasource name.
	 * 
	 * @param res the res
	 * @param tree_datasource the tree_datasource
	 * 
	 * @return the jSON array
	 */
	public JSONArray build_dynamic_jsonarray(Response res,
			String tree_datasource) {

		JSONArray arr = new JSONArray();
		int counter = 0;
		List<Map<String, Field>> documents;
		if (!(null == res.getDocuments())) {
			documents = res.getDocuments();

			Iterator it2 = documents.iterator();

			while (it2.hasNext() && counter < 50) {
				counter++;
				Map<String, Field> m2 = (Map) it2.next();

				try {
					counter++;
					JSONObject jsonObj1 = new JSONObject();
					jsonObj1.put("title", m2.get("title").getValue());
					jsonObj1.put("object", "href:" + m2.get("id").getValue());
					jsonObj1.put("isFolder", "false");
					jsonObj1.put("objectId", "dataset" + tree_datasource);
					arr.put(jsonObj1);

				} catch (Exception e) {
					e.printStackTrace();
				}

			}

		}

		return arr;
	}

	/**
	 * Build_dynamic_jsonarray.
	 * 
	 * @param res the res
	 * @param bb the bb
	 * 
	 * @return the jSON array
	 */
	public JSONArray build_dynamic_jsonarray(Response res, browseBean bb) {
		String next_node = "";
		JSONArray arr = new JSONArray();
		int counter = 0;
		List<Map<String, Field>> documents;
		LinkedHashMap<FilterCatField, List> facetsList;
		TreeMap tm = new TreeMap();

		if (!(null == res.getDocuments())) {
			documents = res.getDocuments();
			facetsList = res.getFacets();
			Iterator it2 = documents.iterator();

			if (!(null == bb.getfield()) && (bb.getfield().contains("dataset"))) {
				while (it2.hasNext()) {
					Map<String, Field> m2 = (Map) it2.next();
					tm.put(m2.get("title").getValue(), m2.get("id").getValue());

				}

				System.out.println("built the treemap");
				Set set = tm.entrySet();
				Iterator iterator = set.iterator();
				while (iterator.hasNext() && counter < 50) { // limit
																// returned
																// dataset size
																// here
					Map.Entry entry = (Map.Entry) iterator.next();
					try {
						counter++;
						JSONObject jsonObj1 = new JSONObject();
						jsonObj1.put("title", entry.getKey());
						jsonObj1.put("object", "href:" + entry.getValue());

						jsonObj1
								.put("objectId", "dataset" + bb.getdataSource());
						arr.put(jsonObj1);

					} catch (Exception e) {
						e.printStackTrace();
					}
				}

				System.out.println("built the jsonarray");
			} else if (!(null == bb.getfield())) {
				List facet_list;

				ArrayList ar = bb.getBrowse_facets();// new ArrayList(set);

				int loc = ar.indexOf(bb.getfield());
				int next_loc = -1;

				if (!(loc == (ar.size() - 1))) {
					next_loc = loc + 1;
					next_node = (String) ar.get(next_loc);
				}

				System.out.println("bb.getfield()=" + bb.getfield());
				FilterCatField fct = new FilterCatField();
				fct.setFilterCatCode(bb.getfield());
				facet_list = facetsList.get(fct);
				System.out.println("facet_list size=" + facet_list.size());

				if (!(loc > -1)) {
					System.out.println(" Facet data seems to be missing for "
							+ bb.getfield());
				}

				Iterator setit = bb.getBrowse_facets().iterator();// set.iterator();
				if (!(null == facet_list)) { // jmg late
					Iterator fit = facet_list.iterator();
					ArrayList nu_facetz = new ArrayList();
					int facet_limit = 0;
					// //////////////////////
					String test = "";
					while (fit.hasNext()) {
						test = (String) (((Field) fit.next()).getName());
						nu_facetz.add(test);
						Collections.sort(nu_facetz);
					}
					Iterator nfit = nu_facetz.iterator();

					while (nfit.hasNext() && facet_limit < 50) {
						facet_limit++;
						try {
							String temp = (String) nfit.next();
							JSONObject jsonObj1 = new JSONObject();
							jsonObj1.put("title", temp);
							jsonObj1.put("isFolder", "false");
							jsonObj1.put("objectId", "path:" + bb.getpath()
									+ " &facet:" + temp + "&field:"
									+ bb.getNext_node() + "&datasource:"
									+ bb.getdataSource() + "&facet1:"
									+ bb.getFacet1() + "&facet1attribute:"
									+ bb.getFacet1attribute() + "&facet2:"
									+ bb.getFacet2() + "&facet2attribute:"
									+ bb.getFacet2attribute() + "&facet3:"
									+ bb.getFacet3() + "&facet3attribute:"
									+ bb.getFacet3attribute());

							arr.put(jsonObj1);

						} catch (Exception e) {
							e.printStackTrace();
						}
					}
				}
			} else {
				arr = build_jsonarray(bb);
			}
		}

		System.out.println("just a stopping point ");

		return arr;
	}

	/**
	 * Gets the string.
	 * 
	 * @return the string
	 */
	public String getString() {
		JSONArray ja = build_jsonarray();
		String jString = ja.toString();

		return jString;
	}

	/**
	 * Gets the string.
	 * 
	 * @param bb the bb
	 * 
	 * @return the string
	 */
	public String getString(browseBean bb) {
		JSONArray ja = build_jsonarray(bb);
		String jString = ja.toString();

		return jString;
	}

	/**
	 * Gets the string.
	 * 
	 * @param titles the titles
	 * 
	 * @return the string
	 */
	public String getString(ArrayList titles) {
		JSONArray ja = build_dynamic_jsonarray(titles);
		String jString = ja.toString();

		return jString;
	}

	/**
	 * TEST: Gets the string.
	 * 
	 * @param res the res
	 * 
	 * @return the string
	 */
	public String getString(Response res) {
		JSONArray ja = build_dynamic_jsonarray(res);
		String jString = ja.toString();

		return jString;
	}

	/**
	 * TEST: Gets the string.
	 * 
	 * @param res the res
	 * @param tree_datasource the tree_datasource
	 * 
	 * @return the string
	 */
	public String getString(Response res, String tree_datasource) {
		JSONArray ja = build_dynamic_jsonarray(res, tree_datasource);
		String jString = ja.toString();

		return jString;
	}

	/**
	 * Builds the JSONArray as a string.
	 * 
	 * @param res the solr response
	 * @param bb the BrowseBean
	 * 
	 * @return the JSONArray
	 */
	public String getString(Response res, browseBean bb) {
		JSONArray ja = build_dynamic_jsonarray_docs(res, bb);
		String jString = ja.toString();

		return jString;
	}

	/**
	 * Builds a JSONArray given a BrowseBean object and a reference to a solr document object.
	 * 
	 * @param res solr document
	 * @param bb the BrowseBean
	 * 
	 * @return the JSONArray
	 */
	public JSONArray build_dynamic_jsonarray_docs(Response res, browseBean bb) {
		String next_node = "";
		JSONArray arr = new JSONArray();

		int counter = 0;
		List<Map<String, Field>> documents;
		LinkedHashMap<FilterCatField, List> facetsList;
		TreeMap tm = new TreeMap();
		List dl = new ArrayList();
		if (!(null == res.getDocuments())) {

			dl = res.getJ_Docs();
			facetsList = res.getFacets();

			if ((!(null == bb.getfield())) && (dl.size() > 0)) {

				for (int i = 0; i < dl.size(); i++) {

					String datum = "";
					JSONObject jsonObj1 = new JSONObject();
					try {
						counter++;
						datum = (String) dl.get(i);

						switch (bb.getField_ndx()) {

						case 2:
							bb.setFacet3attribute(datum);
							break;
						case 1:
							bb.setFacet2attribute(datum);
							break;
						case 0:

							break;
						}

						jsonObj1.put("title",
								" <img src=images/folder.gif alt=\"#########\"/>"
										+ datum
										+

										"<a href=\"send/query?"
										+ "term2.1="
										+ URLEncoder.encode("\""
												+ bb.getFacet1attribute()
												+ "\"", "UTF-8")
										+ "&term2.1attribute="
										+ bb.getFacet1()
										+ "&op2.1=AND&term2="
										+ URLEncoder.encode("\""
												+ bb.getFacet2attribute()
												+ "\"", "UTF-8")
										+ "&term2attribute=" + bb.getFacet2()
										+ "&op2=AND&term6=" + bb.getdataSource()
										+ "&term6=" + "&term6=" + "&term6="
										+ "&term6="
										+ "&term6attribute=datasource"
										+ "&pageSize=10" + "&browseStatus=false"
										+ "&instance=ornldaac\"> ("
										+ "View All" + ")</a>"

						);

						jsonObj1.put("objectId", "path:" + bb.getpath()
								+ " &facet:" + datum + "&field:"
								+ bb.getNext_node() + "&datasource:"
								+ bb.getdataSource() + "&facet1:"
								+ bb.getFacet1() + "&facet1attribute:"
								+ bb.getFacet1attribute() + "&facet2:"
								+ bb.getFacet2() + "&facet2attribute:"
								+ bb.getFacet2attribute() + "&facet3:"
								+ bb.getFacet3() + "&facet3attribute:"
								+ bb.getFacet3attribute());

						jsonObj1.put("query",
								" <img src=images/folder.gif alt=\"#########\"/>"
										+

										"<a href=\"send/query?"
										+ "term2.1="
										+ URLEncoder.encode("\""
												+ bb.getFacet1attribute()
												+ "\"", "UTF-8")
										+ "&term2.1attribute="
										+ bb.getFacet1()
										+ "&op2.1=AND&term2="
										+ URLEncoder.encode("\""
												+ bb.getFacet2attribute()
												+ "\"", "UTF-8")
										+ "&term2attribute="
										+ bb.getFacet2()
										+ "&op2=AND&browse="
										+ URLEncoder.encode("\""
												+ bb.getFacet3attribute()
												+ "\"", "UTF-8")
										+ "&browseattribute=" + bb.getFacet3()
										+ "&opb=&term6=" + bb.getdataSource()
										+ "&term6attribute=datasource"
										+ "&pageSize=10" + "&browseStatus=false"
										+ "&instance=ornldaac\"> " + datum
										+ "</a>");
						arr.put(jsonObj1);

					} catch (Exception e) {
						e.printStackTrace();
					}
				}

			} else {
				arr = build_jsonarray(bb);
			}
		}

		return arr;
	}

}
