/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.mercury3.memberNode.resource;

import gov.ornl.mercury3.commands.Configuration;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;

import javax.xml.parsers.ParserConfigurationException;

import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SystemMetadata;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.jibx.JibxRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.xml.sax.SAXException;

/*
 * Added enum definition per original dataone types
 * instead of coding a new service for mercury to hit.
 * mapping for this one enum is per 0.5.0 
 * 
 * remainder of changes are for Ver 0.6.4 as of 9/4/11 jmg
 */
public class mercuryMetaResource extends ServerResource {

    private static final Logger LOG = LoggerFactory.getLogger(mercuryMetaResource.class);

    /** document identifier. */
    private String pid;
    private String d1_md;

    private String msolrhome;
    private String mcore;

    public String fsep = File.separator;
    SolrCore core;

    /**
     * Retrieve the document identifier based on the URI path variable "pid"
     * declared in the URI template attached to the application router.
     */
    @Override
    protected void doInit() throws ResourceException {
        this.pid = (String) getRequestAttributes().get("pid");
        ApplicationContext factory = new ClassPathXmlApplicationContext("Mercury3Properties.xml");//
        Configuration cv = (Configuration) factory.getBean("propertiesBean");

        HashMap hmProps = cv.getProperties();

        this.d1_md = (String) hmProps.get("d1_md");

        this.msolrhome = (String) hmProps.get("msolrhome");
        this.mcore = (String) hmProps.get("mcore");

    }

    @Override
    protected Representation get() throws ResourceException {
        Date dt = new Date();
        SolrDocument d1 = new SolrDocument();
        QueryResponse qrs2 = query3("water");
        SolrDocumentList sdl = qrs2.getResults();
        try {
            d1 = sdl.get(0);
        } catch (Exception exc) {
            LOG.error("File '{}' not found.");

            getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return null;
        }

        String fmt = (String) d1.get("objectFormat");
        ObjectFormat objectFormat = ObjectFormat.convert(fmt);

        Checksum checksum = new Checksum();
        checksum = new Checksum();
        String algorithm = (String) d1.get("checksumAlgorithm");
        checksum.setAlgorithm((String) (d1.get("checksumAlgorithm")));

        checksum.setValue((String) d1.get("checksum"));

        Date dateSysMetadataModified = (Date) d1.get("last_modified");

        Date dateUploaded = (Date) d1.get("update_date");

        final SystemMetadata meta = new SystemMetadata();

        Identifier id = new Identifier();
        id.setValue(pid);

        Subject principal = new Subject();
        principal.setValue((String) d1.get("submitter"));

        Subject principal2 = new Subject();

        principal2.setValue((String) d1.get("rightsHolder"));

        NodeReference originMemberNode = new NodeReference();
        originMemberNode.setValue((String) d1.get("originMemberNode"));

        NodeReference authoritativeMemberNode = new NodeReference();
        authoritativeMemberNode.setValue((String) d1.get("authoritativeMemberNode"));

        meta.setIdentifier(id);

        ObjectFormatIdentifier fmtid = new ObjectFormatIdentifier();
        String fmt2 = objectFormat.value;
        fmtid.setValue(fmt2);

        meta.setFormatId(fmtid);

        meta.setSize(BigInteger.valueOf(Long.parseLong((String) (d1.get("size")))));
        meta.setSubmitter(principal);
        meta.setRightsHolder(principal2);
        meta.setChecksum(checksum);
        meta.setDateUploaded(dateUploaded);
        meta.setDateSysMetadataModified(dateSysMetadataModified);
        meta.setOriginMemberNode(originMemberNode);
        meta.setAuthoritativeMemberNode(authoritativeMemberNode);

        JibxRepresentation result2 = new JibxRepresentation<SystemMetadata>(MediaType.TEXT_XML,
                meta);

        return result2;
    }

    public QueryResponse query3(String q) {

        SolrQueryRequest solrQueryRequest;
        SolrQueryResponse solrQueryResponse;
        MediaType mediaType;

        String msolrhome2 = msolrhome.concat(fsep).concat(mcore);
        SolrServer server2 = null;
        CoreContainer container = new CoreContainer();
        SolrQuery query = new SolrQuery();

        server2 = new EmbeddedSolrServer(container, mcore);
        SolrConfig config = null;
        try {
            config = new SolrConfig(msolrhome2, "solrconfig.xml", null);
        } catch (ParserConfigurationException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (SAXException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        CoreDescriptor descriptor = new CoreDescriptor(container, mcore, msolrhome);
        core = new SolrCore(mcore, msolrhome2 + fsep + "data", config, null, descriptor);
        container.register(mcore, core, false);

        QueryResponse qrs2 = null;
        try {
            String query2 = "";
            if (null != pid && pid.length() > 0) {
                query2 = "*:* AND identifier:" + pid;
            } else {
                return qrs2;
            }

            ModifiableSolrParams solrParams = new ModifiableSolrParams();
            solrParams.set("q", query2);

            qrs2 = server2.query(solrParams);

            System.out.println("Query2 Results: " + qrs2);

        } catch (SolrServerException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        container.shutdown();
        return qrs2;
    }

    enum ObjectFormat {
        EML_2_0_0("eml://ecoinformatics.org/eml-2.0.0"), EML_2_0_1(
                "eml://ecoinformatics.org/eml-2.0.1"), EML_2_1_0(
                "eml://ecoinformatics.org/eml-2.1.0"), EML_2_1_1(
                "eml://ecoinformatics.org/eml-2.1.1"), FGDC_STD_001_1_1999("FGDC-STD-001.1-1999"), FGDC_STD_001_1998(
                "FGDC-STD-001-1998"), INCITS_453_2009("INCITS 453-2009"), NCML_2_2(
                "http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2"), CF_1_0("CF-1.0"), CF_1_1(
                "CF-1.1"), CF_1_2("CF-1.2"), CF_1_3("CF-1.3"), CF_1_4("CF-1.4"), WATER_ML_1_0(
                "http://www.cuahsi.org/waterML/1.0/"), WATER_ML_1_1(
                "http://www.cuahsi.org/waterML/1.1/"), DSPACE_METS_SIP_1_0(
                "http://www.loc.gov/METS/"), NET_CDF_3("netCDF-3"), NET_CDF_4("netCDF-4"), TEXT_PLAIN(
                "text/plain"), TEXT_CSV("text/csv"), IMAGE_BMP("image/bmp"), IMAGE_GIF("image/gif"), IMAGE_JP2(
                "image/jp2"), IMAGE_JPEG("image/jpeg"), IMAGE_PNG("image/png"), IMAGE_SVGXML(
                "image/svg+xml"), IMAGE_TIFF("image/tiff"), SIMPLE_DARWIN_CORE(
                "http://rs.tdwg.org/dwc/xsd/simpledarwincore/"), DARWIN_2(
                "http://digir.net/schema/conceptual/darwin/2003/1.0/darwin2.xsd"), OCTET_STREAM(
                "application/octet-stream");
        private final String value;

        private ObjectFormat(String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        public static ObjectFormat convert(String value) {
            for (ObjectFormat inst : values()) {
                if (inst.toString().equals(value)) {
                    return inst;
                }
            }
            return ObjectFormat.OCTET_STREAM;
        }
    }

}
