/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.mercury3.memberNode.resource;

import java.io.IOException;
import java.util.HashMap;

import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import gov.ornl.mercury3.commands.Configuration;

public class PingResource extends ServerResource {
	

	 private String itemName;
	 private String ping_id;
	 
	  
	    @Override
	    protected void doInit() throws ResourceException {
	       	        
/*	        ApplicationContext factory = new ClassPathXmlApplicationContext(
			"gov/mercury3/memberNode/resource/Mercury3Properties.xml");//gov/ornl/mercury3/services/Mercury_term_maps.xml
*/
	    	
			ApplicationContext factory = new ClassPathXmlApplicationContext(
			"Mercury3Properties.xml");//

	    	
	        Configuration cv = (Configuration) factory.getBean("propertiesBean");

	        HashMap hmProps = cv.getProperties();
	        
	        this.ping_id = (String)hmProps.get("ping");
	 
	    }
	 
	  @Override
	  public Representation get() {
		  
		  Representation representation = new FileRepresentation(ping_id , MediaType.TEXT_HTML, 3600);

/*	    if (MediaType.TEXT_HTML.equals(variant.getMediaType())) {
	      return new FileRepresentation(
	        "/assets/html/" + itemName + ".html", 
	        MediaType.TEXT_HTML, 3600);
*/	      
	      return representation;
	    }
	
  
    protected Representation get1() throws ResourceException {
        DomRepresentation result;

        try {
            // Create a new DOM representation
            result = new DomRepresentation();

            // Ensure pretty printing
            result.setIndenting(true);

            // Retrieve the DOM document to populate
            Document doc = result.getDocument();

            // Append the root node
            Node mnElt = doc.createElement("systemMetadata");
            doc.appendChild(mnElt);

            // Append the child nodes and set their text content
            Node idElt = doc.createElement("identifier");
            idElt.setTextContent("Identifier0");
            mnElt.appendChild(idElt);

            Node formatElt = doc.createElement("objectFormat");
            formatElt.setTextContent("eml://ecoinformatics.org/eml-2.0.1");
            mnElt.appendChild(formatElt);

            Node dateUploadedElt = doc.createElement("dateUploaded");
            dateUploadedElt.setTextContent("2006-05-04T18:13:51.0Z");
            mnElt.appendChild(dateUploadedElt);

            Node originElt = doc.createElement("originMemberNode");
            originElt.setTextContent(new Reference(getReference(), "..")
                    .getTargetRef().toString());
            mnElt.appendChild(originElt);
        } catch (IOException e) {
            throw new ResourceException(e);
        }

        return result;
    }

    @Override
    protected Representation put(Representation representation)
            throws ResourceException {
       
        
        // Wraps the XML representation in a DOM representation
        DomRepresentation mnRep = new DomRepresentation(representation);

        // dummy in some reads here for testing
        
        // Retrieve the XML element using XPath expressions
        String doi = mnRep.getText("/systemMetadata/identifier");
      

        // Output the XML element values
        System.out.println("doi: " + doi);
        
        
        return null;
    }
}
