/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.mercury3.memberNode.resource;

/*
 * Added enum definition per original dataone types
 * instead of coding a new service for mercury to hit.
 * mapping for this one enum is per 0.5.0  jmg
 * 
 * remainder of changes are for Ver 0.6.4 as of 9/4/11
 */
import gov.ornl.mercury3.commands.Configuration;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;

import javax.xml.parsers.ParserConfigurationException;

import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectInfo;
import org.dataone.service.types.v1.ObjectList;
import org.restlet.data.MediaType;
import org.restlet.ext.jibx.JibxRepresentation;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.xml.sax.SAXException;

public class ObjectResource extends ServerResource {

    public String fsep = File.separator;
    SolrCore core;

    private String msolrhome;
    private String mcore;

    /** document identifier. */
    private String pid;
    private String d1_md;

    private String requestCount;
    private String requestStart;
    private String requestFormat;
    private String requestStartTime;
    private String requestEndTime;
    private String requestReplicaStatus;

    /**
     * Retrieve the document identifier based on the URI path variable "pid"
     * declared in the URI template attached to the application router.
     */
    @Override
    protected void doInit() throws ResourceException {
        this.pid = (String) getRequestAttributes().get("pid");

        ApplicationContext factory = new ClassPathXmlApplicationContext("Mercury3Properties.xml");//

        Configuration cv = (Configuration) factory.getBean("propertiesBean");

        HashMap hmProps = cv.getProperties();

        this.d1_md = (String) hmProps.get("d1_md");

        this.msolrhome = (String) hmProps.get("msolrhome");
        this.mcore = (String) hmProps.get("mcore");

    }

    @Override
    protected Representation get() throws ResourceException {

        String dateString = "";

        QueryResponse qrs2 = query3("water");
        SolrDocumentList sdl = qrs2.getResults();

        Long numfound = sdl.getNumFound();
        Long start = sdl.getStart();
        Long count = sdl.getNumFound();

        ObjectInfo oi1 = new ObjectInfo();
        ObjectList ol1 = new ObjectList();

        Identifier identifier = new Identifier();

        ol1.setStart(start.intValue());
        ol1.setTotal(numfound.intValue());
        ol1.setCount(sdl.size());

        String fmt = "";
        ObjectFormat objectFormat;// = ObjectFormat.FGDC_STD_001_1_1999;

        Checksum checksum = new Checksum();
        // checksum.setAlgorithm(ChecksumAlgorithm.SHA_1);
        checksum.setAlgorithm("MD5");
        checksum.setValue("bada55");

        Date dateSysMetadataModified = new Date();

        String algorithm = "";
        for (SolrDocument d : sdl) {
            oi1 = new ObjectInfo();
            identifier = new Identifier();
            identifier.setValue((String) d.get("identifier"));

            fmt = (String) d.get("objectFormat");
            objectFormat = ObjectFormat.convert(fmt);
            ObjectFormatIdentifier fmtid = new ObjectFormatIdentifier();
            String fmt2 = objectFormat.value;
            fmtid.setValue(fmt2);
            checksum = new Checksum();
            algorithm = (String) d.get("checksumAlgorithm");

            // checksum.setAlgorithm(ChecksumAlgorithm.convert((String)(d.get("checksumAlgorithm"))));
            checksum.setAlgorithm((String) (d.get("checksumAlgorithm")));
            checksum.setValue((String) d.get("checksum"));

            dateSysMetadataModified = (Date) d.get("last_modified");

            oi1.setIdentifier(identifier);
            // oi1.setSize(Long.parseLong((String)(d.get("size"))));
            oi1.setSize(BigInteger.valueOf(Long.parseLong((String) (d.get("size")))));

            oi1.setChecksum(checksum);
            oi1.setDateSysMetadataModified(dateSysMetadataModified);
            // oi1.setObjectFormat(objectFormat);

            oi1.setFormatId(fmtid);

            ol1.addObjectInfo(oi1);
        }

        JibxRepresentation result2 = new JibxRepresentation<ObjectList>(MediaType.TEXT_XML, ol1);
        return result2;
    }

    @Override
    protected Representation put(Representation representation) throws ResourceException {

        // Wraps the XML representation in a DOM representation
        DomRepresentation mnRep = new DomRepresentation(representation);

        // dummy in some reads here for testing

        // Retrieve the XML element using XPath expressions
        String doi = mnRep.getText("/systemMetadata/identifier");

        // Output the XML element values
        System.out.println("doi: " + doi);

        return null;
    }

    public QueryResponse query3(String q) {

        requestCount = getRequest().getResourceRef().getQueryAsForm().getFirstValue("count");
        requestStart = getRequest().getResourceRef().getQueryAsForm().getFirstValue("start");
        requestFormat = getRequest().getResourceRef().getQueryAsForm()
                .getFirstValue("objectFormat");
        requestStartTime = getRequest().getResourceRef().getQueryAsForm()
                .getFirstValue("startTime");
        requestEndTime = getRequest().getResourceRef().getQueryAsForm().getFirstValue("endTime");
        requestReplicaStatus = getRequest().getResourceRef().getQueryAsForm()
                .getFirstValue("replicaStatus");

        SolrQueryRequest solrQueryRequest;
        SolrQueryResponse solrQueryResponse;
        MediaType mediaType;

        // String msolrhome = "c:\\solrindex\\ornldaac";
        // String mcore = "core0";
        String msolrhome2 = msolrhome.concat(fsep).concat(mcore);
        EmbeddedSolrServer server2 = null;
        CoreContainer container = new CoreContainer();

        server2 = new EmbeddedSolrServer(container, mcore);
        SolrConfig config = null;
        try {
            config = new SolrConfig(msolrhome2, "solrconfig.xml", null);
        } catch (ParserConfigurationException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (SAXException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        CoreDescriptor descriptor = new CoreDescriptor(container, mcore, msolrhome);
        core = new SolrCore(mcore, msolrhome2 + fsep + "data", config, null, descriptor);
        container.register(mcore, core, false);

        QueryResponse qrs2 = null;
        try {
            String query2 = "";
            StringBuilder sb = new StringBuilder();
            sb.append("*:*");
            if (null != requestFormat && requestFormat.length() > 0) {
                sb.append(" AND objectFormat:" + requestFormat);
            }

            /*
             * if((null != requestStartTime &&
             * requestStartTime.length()>0)&&(null != requestEndTime &&
             * requestEndTime.length()>0)){ sb.append(" AND update_date:["
             * +requestStartTime+ " TO "+requestEndTime+ " ]"); }
             */
            query2 = sb.toString();

            // TODO error checking here for properly populated fields
            ModifiableSolrParams solrParams = new ModifiableSolrParams();
            solrParams.set("q", query2);
            if (null != requestStart) {
                solrParams.set("start", Integer.parseInt(requestStart));
            } else {
                solrParams.set("start", 0);
            }
            // solrParams.set("start", Integer.parseInt(requestStart));
            if (null != requestCount) {
                solrParams.set("rows", Integer.parseInt(requestCount));
            } else {
                solrParams.set("rows", 10);
            }

            // solrParams.add("size","identifier","checksumAlgorithm","objectFormat","last_modified","checksum,update_date");
            solrParams.add("size", "identifier", "checksumAlgorithm", "objectFormat", "checksum",
                    "update_date");

            qrs2 = server2.query(solrParams);

            System.out.println("Query2 Results: " + qrs2);

        } catch (SolrServerException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        container.shutdown();
        return qrs2;
    }

    enum ObjectFormat {
        EML_2_0_0("eml://ecoinformatics.org/eml-2.0.0"), EML_2_0_1(
                "eml://ecoinformatics.org/eml-2.0.1"), EML_2_1_0(
                "eml://ecoinformatics.org/eml-2.1.0"), EML_2_1_1(
                "eml://ecoinformatics.org/eml-2.1.1"), FGDC_STD_001_1_1999("FGDC-STD-001.1-1999"), FGDC_STD_001_1998(
                "FGDC-STD-001-1998"), INCITS_453_2009("INCITS 453-2009"), NCML_2_2(
                "http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2"), CF_1_0("CF-1.0"), CF_1_1(
                "CF-1.1"), CF_1_2("CF-1.2"), CF_1_3("CF-1.3"), CF_1_4("CF-1.4"), WATER_ML_1_0(
                "http://www.cuahsi.org/waterML/1.0/"), WATER_ML_1_1(
                "http://www.cuahsi.org/waterML/1.1/"), DSPACE_METS_SIP_1_0(
                "http://www.loc.gov/METS/"), NET_CDF_3("netCDF-3"), NET_CDF_4("netCDF-4"), TEXT_PLAIN(
                "text/plain"), TEXT_CSV("text/csv"), IMAGE_BMP("image/bmp"), IMAGE_GIF("image/gif"), IMAGE_JP2(
                "image/jp2"), IMAGE_JPEG("image/jpeg"), IMAGE_PNG("image/png"), IMAGE_SVGXML(
                "image/svg+xml"), IMAGE_TIFF("image/tiff"), SIMPLE_DARWIN_CORE(
                "http://rs.tdwg.org/dwc/xsd/simpledarwincore/"), DARWIN_2(
                "http://digir.net/schema/conceptual/darwin/2003/1.0/darwin2.xsd"), OCTET_STREAM(
                "application/octet-stream");
        private final String value;

        private ObjectFormat(String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        public static ObjectFormat convert(String value) {
            for (ObjectFormat inst : values()) {
                if (inst.toString().equals(value)) {
                    return inst;
                }
            }
            return ObjectFormat.OCTET_STREAM;
        }
    }

}
