/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.mercury3.memberNode.resource;

/*
 * Modified for class deletions from v5.
 * Added enum definition per original dataone types
 * instead of coding a new service for mercury to hit.
 * mapping for this one enum is per 0.5.0 
 * 
 * remainder of changes are for Ver 0.6.4 as of 9/4/11 jmg
 */

import gov.ornl.mercury3.commands.Configuration;

import java.util.HashMap;
import org.dataone.service.types.v1.NodeList;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeState;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.Services;
import org.restlet.data.MediaType;
import org.restlet.ext.jibx.JibxRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * Resource corresponding to a ping request received 
 * returns the named resource file.
 */
public class MemberNodeServerResource extends ServerResource {

	public String nodeName;
	public String restURL;

   @Override
    protected void doInit() throws ResourceException {
		ApplicationContext factory = new ClassPathXmlApplicationContext(
		"Mercury3Properties.xml");//

        Configuration cv = (Configuration) factory.getBean("propertiesBean");

        HashMap hmProps = cv.getProperties();
        
        this.nodeName = (String)hmProps.get("nodeName");
        
        this.restURL = (String)hmProps.get("restURL");
        
    }
   
    @Override
    protected Representation get() throws ResourceException {
    	
    	
    	NodeList nl1 = new NodeList();
    	
    	
    	org.dataone.service.types.v1.Node item = new org.dataone.service.types.v1.Node();
    	
    	NodeReference identifier = new NodeReference();
    	
   
		item.setType(NodeType.MN);
		
	   	identifier.setValue("Mercury Member Node");
    	String name = nodeName;
    	item.setName(name);
    	String description = nodeName;
		item.setDescription(description );
		item.setIdentifier(identifier);
		
		item.setState(NodeState.UP);
		item.setType(NodeType.MN);
		item.setReplicate(false);
		item.setSynchronize(false);
		
    	String baseURL = restURL;
		item.setBaseURL(baseURL );
    	

		Services services = new Services();
		
		Service s_item = new Service();
		s_item.setVersion("0.2");
		s_item.setAvailable(true);
		s_item.setName("node" );
		
		Service s_item2 = new Service();
		s_item2.setVersion("0.2");
		s_item2.setAvailable(true);
		s_item2.setName("meta/{pid}" );
		
		Service s_item3 = new Service();
		s_item3.setVersion("0.2");
		s_item3.setAvailable(true);
		s_item3.setName("object" );
		
		Service s_item4 = new Service();
		s_item4.setVersion("0.2");
		s_item4.setAvailable(true);
		s_item4.setName("object/{pid}" );
		
		Service s_item5 = new Service();
		s_item5.setVersion("0.2");
		s_item5.setAvailable(true);
		s_item5.setName("monitor/ping" );
		
			

		
		services.addService(s_item );
		services.addService(s_item2 );
		services.addService(s_item3 );
		services.addService(s_item4 );
		services.addService(s_item5 );
	
		
		item.setServices(services );
		
		
		
		nl1.addNode(item);
		

         
    
		 JibxRepresentation result2 = new JibxRepresentation<NodeList>(MediaType.TEXT_XML, nl1);
        return result2;
    }


}
