/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.mercury3.memberNode.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import gov.ornl.mercury3.commands.Configuration;
import org.restlet.data.Disposition;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class HTMLResource extends ServerResource {
	private String itemName;
	 private String d1_md;
	private static final Logger LOG = LoggerFactory.getLogger(
			HTMLResource.class);
	
	@Override
    protected void doInit() throws ResourceException {
        this.itemName = (String) getRequestAttributes().get("itemName");
 			ApplicationContext factory = new ClassPathXmlApplicationContext(
			"Mercury3Properties.xml");//

         
        Configuration cv = (Configuration) factory.getBean("propertiesBean");
        HashMap hmProps = cv.getProperties();
        
        this.d1_md = (String)hmProps.get("d1_md");
 
        
      }

	@Override
	 protected Representation get() throws ResourceException {
		Representation representation =null;
		Disposition attachment = new Disposition(Disposition.TYPE_ATTACHMENT);

		attachment.setFilename(itemName);
		try{
			FileInputStream fis = new FileInputStream(new File(d1_md + itemName ));
			if(itemName.endsWith("xml")){
				representation = new FileRepresentation(d1_md + itemName , MediaType.APPLICATION_ALL_XML, 3600);
					
			}else if(itemName.endsWith("zip")){
				representation = new FileRepresentation(d1_md + itemName , MediaType.APPLICATION_ZIP, 3600);
				
			}else{
				representation = new FileRepresentation(d1_md + itemName , MediaType.TEXT_HTML, 3600);

			}
	
		} catch (FileNotFoundException e) {
			LOG.error("File '{}' not found.");

			getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
			return null;
		}
			
		representation.setDisposition(attachment);
			
		return representation; 
			
	}
}



