/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.mercury3.memberNode;

import gov.mercury3.memberNode.resource.HTMLResource;
import gov.mercury3.memberNode.resource.MemberNodeServerResource;
import gov.mercury3.memberNode.resource.ObjectResource;
import gov.mercury3.memberNode.resource.PingResource;
import gov.mercury3.memberNode.resource.mercuryMetaResource;
//import gov.mercury3.memberNode.resource.jibObjectResource;

import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.routing.Router;

/**
 * Routing to annotated server resources.
 */
public class MercuryMemberNodeApplication extends Application {

 
	   /**
     * Constructor. instead of a main method.
     */
    public MercuryMemberNodeApplication() {
        setName("RESTful Member Node");
        setDescription("Prototype");
        setOwner("Chesapeake Chili Co.");
        setAuthor("The Team");
    }

	
	
    /**
     * Creates a root Router to dispatch call to server resources.
     */
    @Override
    public Restlet createInboundRoot() {
    	
              
       Router router = new Router(getContext());
        
        router.attach( "/monitor/ping",PingResource.class);
        
        router.attach( "/node",MemberNodeServerResource.class);
        
        router.attach( "/object/{itemName}", HTMLResource.class);
        
        router.attach( "/meta/{pid}",mercuryMetaResource.class);
        
        router.attach( "/object",ObjectResource.class); 
             
        
      
        return router;
    }
}
