/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.web.util;

import gov.ornl.mercury3.commands.Configuration;
import gov.ornl.mercury3.services.SolrTransactionService;
import gov.ornl.mercury3.services.SolrTransactionServiceDefault;
import gov.ornl.mercury3.services.SolrTransactionServiceVersion1_1;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SolrTransactionServiceFactory {
    private static SolrTransactionService transactionService = null;
    private static String schemaVersion = "1.1";
    private static long CACHE_EXPIRATION_PERIOD = 900000L;
    private static long serviceCreationTimestamp = 0L;

    private SolrTransactionServiceFactory() {
    }

    public static SolrTransactionService getTransactionService() {
        if (SolrTransactionServiceFactory.timeToConfigure()) {
            SolrTransactionServiceFactory.configure();
        }
        return transactionService;
    }

    private static boolean timeToConfigure() {
        if (serviceCreationTimestamp == 0L || transactionService == null) {
            return true;
        }
        return serviceCreationTimestamp + CACHE_EXPIRATION_PERIOD < System.currentTimeMillis();
    }

    private static void configure() {
        SolrTransactionServiceFactory.setSchemaVersionFromProperties();
        transactionService = "1".equals(schemaVersion) ? new SolrTransactionServiceDefault() : ("1.1".equals(schemaVersion) ? new SolrTransactionServiceVersion1_1() : new SolrTransactionServiceDefault());
        serviceCreationTimestamp = System.currentTimeMillis();
    }

    private static void setSchemaVersionFromProperties() {
        try {
            ClassPathXmlApplicationContext factory = new ClassPathXmlApplicationContext("solrTxServiceFactoryProperties.xml");
            Configuration cv = (Configuration)factory.getBean("propertiesBean");
            String tempSchemaVersion = (String)cv.getProperties().get("solr_schema_version");
            if (StringUtils.isNotEmpty((String)tempSchemaVersion)) {
                schemaVersion = tempSchemaVersion;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

