/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.web.util;

import gov.ornl.mercury3.commands.Configuration;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dataone.client.CNode;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Node;
import org.dataone.service.types.v1.NodeType;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class MemberNodeSourcesMapCache {
    private static final String NODE_LIST_URL_KEY = "node_list_url";
    private static String NODE_LIST_URL = "https://localhost/cn/";
    private static final String CACHE_EXPIRATION_KEY = "cache_expiration_period";
    private static long CACHE_EXPIRATION_PERIOD = 300000L;
    private static final String NODE_STALE_SYNC_DATE_KEY = "node_sync_stale_date";
    private static String STALE_SYNC_DATE_STRING = "2012/07/01";
    private static Date STALE_SYNC_DATE = null;
    private Map<String, String> mnSourceMap = new HashMap<String, String>();
    private long mnSourceCacheTimestamp = 0L;
    public static final MemberNodeSourcesMapCache INSTANCE = new MemberNodeSourcesMapCache();

    private MemberNodeSourcesMapCache() {
        this.configureProperties();
    }

    public Map<String, String> getMNSourceMap() {
        if (this.timeToRefresh()) {
            this.mnSourceMap = this.refreshMNSourceMap();
        }
        return this.mnSourceMap;
    }

    private synchronized Map<String, String> refreshMNSourceMap() {
        HashMap<String, String> freshMap = new HashMap<String, String>();
        try {
            CNode cn = new CNode(NODE_LIST_URL);
            List values = cn.listNodes().getNodeList();
            for (Node node : values) {
                if (!this.isMemberNode(node) || !this.isCurrentSync(node)) continue;
                freshMap.put(node.getIdentifier().getValue(), node.getName());
            }
        }
        catch (ServiceFailure sf) {
            sf.printStackTrace();
        }
        catch (NotImplemented ni) {
            ni.printStackTrace();
        }
        this.mnSourceCacheTimestamp = System.currentTimeMillis();
        return freshMap;
    }

    private boolean timeToRefresh() {
        return this.mnSourceCacheTimestamp + CACHE_EXPIRATION_PERIOD < System.currentTimeMillis();
    }

    private boolean isMemberNode(Node node) {
        return node.getType().compareTo((Enum)NodeType.MN) == 0;
    }

    private boolean isCurrentSync(Node node) {
        if (STALE_SYNC_DATE == null) {
            return true;
        }
        if (node.getSynchronization() == null || node.getSynchronization().getLastHarvested() == null) {
            return false;
        }
        return STALE_SYNC_DATE.before(node.getSynchronization().getLastHarvested());
    }

    private void configureProperties() {
        String syncStaleDate;
        String cacheExpirationString;
        ClassPathXmlApplicationContext factory = new ClassPathXmlApplicationContext("Mercury3Properties.xml");
        Configuration cv = (Configuration)factory.getBean("propertiesBean");
        HashMap<String, Object> hmProps = cv.getProperties();
        String nodeUrlString = (String)hmProps.get(NODE_LIST_URL_KEY);
        if (null != nodeUrlString && !"".equals(nodeUrlString)) {
            NODE_LIST_URL = nodeUrlString.trim();
        }
        if (null != (cacheExpirationString = (String)hmProps.get(CACHE_EXPIRATION_KEY)) && !"".equals(cacheExpirationString)) {
            CACHE_EXPIRATION_PERIOD = Long.valueOf(cacheExpirationString.trim());
        }
        if ((syncStaleDate = (String)hmProps.get(NODE_STALE_SYNC_DATE_KEY)) != null && !"".equals(syncStaleDate)) {
            STALE_SYNC_DATE_STRING = syncStaleDate;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            STALE_SYNC_DATE = dateFormat.parse(STALE_SYNC_DATE_STRING);
        }
        catch (ParseException pe) {
            System.out.println("Failed to parse stale sync date: " + STALE_SYNC_DATE_STRING);
            pe.printStackTrace();
        }
    }
}

