/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.services;

import gov.ornl.mercury3.services.TransformedFiles;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class TransformedFilesDAO
extends HibernateDaoSupport {
    private static final Log log = LogFactory.getLog(TransformedFilesDAO.class);
    public static final String FILE_NAME = "fileName";
    public static final String FILE_CONTENT = "fileContent";
    public static final String FILE_URL = "fileUrl";
    public static final String CKSUM = "cksum";

    protected void initDao() {
    }

    public void save(TransformedFiles transientInstance) {
        log.debug((Object)"saving TransformedFiles instance");
        try {
            this.getHibernateTemplate().save((Object)transientInstance);
            log.debug((Object)"save successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"save failed", (Throwable)re);
            throw re;
        }
    }

    public void delete(TransformedFiles persistentInstance) {
        log.debug((Object)"deleting TransformedFiles instance");
        try {
            this.getHibernateTemplate().delete((Object)persistentInstance);
            log.debug((Object)"delete successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"delete failed", (Throwable)re);
            throw re;
        }
    }

    public TransformedFiles findById(Integer id) {
        log.debug((Object)("getting TransformedFiles instance with id: " + id));
        try {
            TransformedFiles instance = (TransformedFiles)this.getHibernateTemplate().get("gov.ornl.mercury3.services.TransformedFiles", (Serializable)id);
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List findByExample(TransformedFiles instance) {
        log.debug((Object)"finding TransformedFiles instance by example");
        try {
            List results = this.getHibernateTemplate().findByExample((Object)instance);
            log.debug((Object)("find by example successful, result size: " + results.size()));
            return results;
        }
        catch (RuntimeException re) {
            log.error((Object)"find by example failed", (Throwable)re);
            throw re;
        }
    }

    public List findByProperty(String propertyName, Object value) {
        log.debug((Object)("finding TransformedFiles instance with property: " + propertyName + ", value: " + value));
        try {
            String queryString = "from TransformedFiles as model where model." + propertyName + "= ?";
            return this.getHibernateTemplate().find(queryString, value);
        }
        catch (RuntimeException re) {
            log.error((Object)"find by property name failed", (Throwable)re);
            throw re;
        }
    }

    public List findByFileName(Object fileName) {
        return this.findByProperty(FILE_NAME, fileName);
    }

    public List findByFileContent(Object fileContent) {
        return this.findByProperty(FILE_CONTENT, fileContent);
    }

    public List findByFileUrl(Object fileUrl) {
        return this.findByProperty(FILE_URL, fileUrl);
    }

    public List findByCksum(Object cksum) {
        return this.findByProperty(CKSUM, cksum);
    }

    public List findAll() {
        log.debug((Object)"finding all TransformedFiles instances");
        try {
            String queryString = "from TransformedFiles";
            return this.getHibernateTemplate().find(queryString);
        }
        catch (RuntimeException re) {
            log.error((Object)"find all failed", (Throwable)re);
            throw re;
        }
    }

    public TransformedFiles merge(TransformedFiles detachedInstance) {
        log.debug((Object)"merging TransformedFiles instance");
        try {
            TransformedFiles result = (TransformedFiles)this.getHibernateTemplate().merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public void attachDirty(TransformedFiles instance) {
        log.debug((Object)"attaching dirty TransformedFiles instance");
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)instance);
            log.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public void attachClean(TransformedFiles instance) {
        log.debug((Object)"attaching clean TransformedFiles instance");
        try {
            this.getHibernateTemplate().lock((Object)instance, LockMode.NONE);
            log.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public static TransformedFilesDAO getFromApplicationContext(ApplicationContext ctx) {
        return (TransformedFilesDAO)((Object)ctx.getBean("TransformedFilesDAO"));
    }
}

