/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.services;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringUtility {
    private static StringUtility instance;

    public static synchronized StringUtility getInstance() {
        if (instance == null) {
            instance = new StringUtility();
        }
        return instance;
    }

    private StringUtility() {
    }

    public StringBuffer replaceToReferralURLS(StringBuffer OriginalHtmlStr) {
        StringBuffer modifiedHtmlStr = new StringBuffer();
        HashMap<String, String> referalList = new HashMap<String, String>();
        boolean haveBaseURL = false;
        String baseURL = "";
        try {
            Pattern p = Pattern.compile("< *base +href *= *\"(.*?)\" *>", 2);
            Matcher m = p.matcher(OriginalHtmlStr);
            if (m.find()) {
                String baseRef = m.group(1);
                Pattern urlP = Pattern.compile("^ *(.*)/(.*)$");
                Matcher urlM = urlP.matcher(baseRef);
                if (urlM.find()) {
                    baseURL = urlM.group(1) + "/";
                    haveBaseURL = true;
                }
                OriginalHtmlStr = new StringBuffer(m.replaceFirst(""));
            }
        }
        catch (PatternSyntaxException e) {
            System.out.println("Regex syntax error: " + e.getMessage());
        }
        int counter = 0;
        try {
            Pattern p = Pattern.compile("< *a +href *= *\"(.*?)\"", 2);
            Matcher m = p.matcher(OriginalHtmlStr);
            while (m.find()) {
                if (m.group(1).trim().startsWith("#") || m.group(1).trim().toLowerCase().startsWith("mailto")) continue;
                System.out.println("m.group(1)0=" + m.group(1));
                if (!m.group(1).trim().toLowerCase().startsWith("http") && !m.group(1).trim().toLowerCase().startsWith("ftp")) {
                    referalList.put("" + counter, baseURL + m.group(1) + "|" + "General" + "|" + "General");
                }
                m.appendReplacement(modifiedHtmlStr, "<a href=" + m.group(1) + " onClick=\"survey('" + m.group(1) + "')\"");
            }
            m.appendTail(modifiedHtmlStr);
        }
        catch (PatternSyntaxException e) {
            System.out.println("Regex syntax error: " + e.getMessage());
        }
        return modifiedHtmlStr;
    }
}

