/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.services;

import gov.ornl.mercury3.services.SourceObject;
import java.util.ArrayList;

public class SourceQuery {
    private ArrayList<String> t6 = new ArrayList();
    private ArrayList<String> t10 = new ArrayList();
    private ArrayList<String> t11 = new ArrayList();
    private String ds_all = "false";
    private String ds_lter = "false";
    private String ds_ilter = "false";
    private String facet_ds = "";

    public SourceQuery() {
    }

    public SourceQuery(SourceObject so) {
        this.t6 = so.getT6();
        this.t10 = so.getT10();
        this.t11 = so.getT11();
        this.ds_all = so.getDs_all();
        this.ds_lter = so.getDs_lter();
        this.ds_ilter = so.getDs_ilter();
        this.facet_ds = so.getFacet_ds();
    }

    public String buildT6Snippet(ArrayList<String> al) {
        String attribute = "datasource";
        String query = this.buildSnippet(al, attribute);
        return query;
    }

    public String buildT10Snippet(ArrayList<String> al) {
        String attribute = "LTERSite";
        String query = this.buildSnippet(al, attribute);
        return query;
    }

    public String buildT11Snippet(ArrayList<String> al) {
        String attribute = "LTERSite";
        String query = this.buildSnippet(al, attribute);
        return query;
    }

    public String buildSnippet(ArrayList<String> al, String attribute) {
        StringBuffer sb = new StringBuffer();
        int log = 0;
        for (String str : al) {
            if (str.trim().length() <= 0) continue;
            if (log > 0) {
                sb.append(" OR " + attribute + ":" + str + " ");
                continue;
            }
            sb.append(" ( " + attribute + ":" + str + " ");
            log = 1;
        }
        sb.append(" )  ");
        return sb.toString();
    }

    public String build_ds_Snippet(ArrayList<String> al, String attribute) {
        StringBuffer sb = new StringBuffer();
        int log = 0;
        for (String str : al) {
            if (log > 0) {
                sb.append(str + " ");
                continue;
            }
            sb.append(attribute + " :( " + str + " ");
            log = 1;
        }
        sb.append(" )  ");
        return sb.toString();
    }

    public String buildT6_ds_Snippet(ArrayList<String> al) {
        String attribute = "datasource";
        String query = this.build_ds_Snippet(al, attribute);
        return query;
    }

    public String buildT10_ds_Snippet(ArrayList<String> al) {
        String attribute = "LTERSite";
        String query = this.build_ds_Snippet(al, attribute);
        return query;
    }

    public String buildT11_ds_Snippet(ArrayList<String> al) {
        String attribute = "iLTERSite";
        String query = this.build_ds_Snippet(al, attribute);
        return query;
    }

    public String build_display_query() {
        StringBuffer sb = new StringBuffer();
        String query = "";
        String t6Snip = "";
        String t10Snip = "";
        String t11Snip = "";
        if (!Boolean.parseBoolean(this.ds_all)) {
            if (this.t6 != null && this.t6.size() > 0) {
                t6Snip = this.buildT6_ds_Snippet(this.t6);
            }
            if (!Boolean.parseBoolean(this.ds_lter) && this.t10 != null && this.t10.size() > 0) {
                t10Snip = this.buildT10_ds_Snippet(this.t10);
            }
            if (t6Snip.length() > 0 && t10Snip.length() > 0) {
                t10Snip = " OR " + t10Snip;
            }
            if (!Boolean.parseBoolean(this.ds_ilter) && this.t11 != null && this.t11.size() > 0) {
                t11Snip = this.buildT11_ds_Snippet(this.t11);
            }
            if (t11Snip.length() > 0 && (t6Snip.length() > 0 || t10Snip.length() > 0)) {
                t11Snip = " OR " + t11Snip;
            }
            if (this.facet_ds.length() > 0) {
                if (this.facet_ds.equalsIgnoreCase("lter") && this.t10.size() > 0) {
                    sb.append(" AND ( " + this.buildT10_ds_Snippet(this.t10).trim() + " ) ");
                } else if (this.facet_ds.equalsIgnoreCase("ilter") && this.t11.size() > 0) {
                    sb.append(" AND ( " + this.buildT11_ds_Snippet(this.t11).trim() + " ) ");
                } else if (t6Snip.trim().length() > 0) {
                    sb.append(" AND ( " + t6Snip.trim() + " ) ");
                }
            } else if (t6Snip.trim().length() > 0 || t10Snip.trim().length() > 0 || t11Snip.trim().length() > 0) {
                sb.append(" AND ( " + t6Snip.trim() + " ) ");
            }
        }
        return sb.toString();
    }

    public String buildQuery() {
        StringBuffer sb = new StringBuffer();
        String query = "";
        String t6Snip = "";
        String t10Snip = "";
        String t11Snip = "";
        if (!Boolean.parseBoolean(this.ds_all)) {
            if (this.t6 != null && this.t6.size() > 0) {
                t6Snip = this.buildT6Snippet(this.t6);
            }
            if (!Boolean.parseBoolean(this.ds_lter) && this.t10 != null && this.t10.size() > 0) {
                t10Snip = this.buildT10Snippet(this.t10);
            }
            if (t6Snip.trim().length() > 0 && t10Snip.trim().length() > 0) {
                t10Snip = " OR " + t10Snip.trim();
            }
            if (!Boolean.parseBoolean(this.ds_ilter) && this.t11 != null && this.t11.size() > 0) {
                t11Snip = this.buildT11Snippet(this.t11);
            }
            if (t11Snip.length() > 0 && (t6Snip.length() > 0 || t10Snip.length() > 0)) {
                t11Snip = " OR " + t11Snip;
            }
            if (this.facet_ds.length() > 0) {
                if (this.facet_ds.equalsIgnoreCase("lter") && this.t10.size() > 0) {
                    sb.append(" AND ( " + this.buildT10Snippet(this.t10).trim() + " ) ");
                } else if (this.facet_ds.equalsIgnoreCase("ilter") && this.t11.size() > 0) {
                    sb.append(" AND ( " + this.buildT11Snippet(this.t11).trim() + " ) ");
                } else if (t6Snip.trim().length() > 0) {
                    sb.append(" AND ( " + t6Snip.trim() + " ) ");
                }
            } else if (t6Snip.trim().length() > 0 || t10Snip.trim().length() > 0 || t11Snip.trim().length() > 0) {
                sb.append(" AND ( " + t6Snip.trim() + t10Snip.trim() + t11Snip.trim() + " ) ");
            }
        }
        return sb.toString();
    }

    public static void main(String ... args) {
        SourceObject so = new SourceObject();
        ArrayList<String> al_6 = new ArrayList<String>();
        ArrayList<String> al_10 = new ArrayList<String>();
        ArrayList<String> al_11 = new ArrayList<String>();
        al_6.add("nbii");
        al_10.add("andlter");
        al_11.add("saeonilter");
        al_6.add("ornldaac");
        al_10.add("gcelter");
        al_11.add("tilter");
        so.setDs_ilter("false");
        so.setDs_all("false");
        so.setDs_lter("false");
        so.setT6(al_6);
        so.setT10(al_10);
        so.setT11(al_11);
        SourceQuery sq = new SourceQuery(so);
        System.out.println("Test 1: two from each category\n");
        System.out.println(sq.buildQuery() + "\n");
        so.init();
        ArrayList<String> al_6a = new ArrayList<String>();
        ArrayList<String> al_10a = new ArrayList<String>();
        ArrayList<String> al_11a = new ArrayList<String>();
        al_10.add("andlter");
        al_11.add("saeonilter");
        al_10.add("gcelter");
        al_11.add("tilter");
        so.setDs_ilter("false");
        so.setDs_all("false");
        so.setDs_lter("false");
        so.setT6(al_6a);
        so.setT10(al_10a);
        so.setT11(al_11a);
        SourceQuery sq1 = new SourceQuery(so);
        System.out.println("Test 2 No sources selected \n");
        System.out.println(sq1.buildQuery() + "\n");
        so.init();
        al_10a.add("andlter");
        so.setT10(al_10a);
        SourceQuery sq2 = new SourceQuery(so);
        System.out.println("Test 3 one in catehory t10 \n");
        System.out.println(sq1.buildQuery() + "\n");
        so.init();
        al_11a.add("tilter");
        so.setT11(al_11a);
        SourceQuery sq3 = new SourceQuery(so);
        System.out.println("Test 4 one in category t11\n");
        System.out.println(sq3.buildQuery() + "\n");
        so.init();
        al_6a.add("nbii");
        so.setT6(al_6a);
        SourceQuery sq4 = new SourceQuery(so);
        System.out.println("Test 4 one in category t6\n");
        System.out.println(sq4.buildQuery() + "\n");
        so.init();
        al_11a = new ArrayList();
        al_11a.add("tilter");
        al_10a = new ArrayList();
        so.setT11(al_11a);
        al_10a.add("andlter");
        so.setT10(al_10a);
        SourceQuery sq5 = new SourceQuery(so);
        System.out.println("Test 5 one in category t10 & one in t11\n");
        System.out.println(sq5.buildQuery() + "\n");
        so.init();
        al_11a = new ArrayList();
        al_11a.add("tilter");
        al_10a = new ArrayList();
        so.setT11(al_11a);
        al_10a.add("andlter");
        so.setT10(al_10a);
        so.setFacet_ds("somesourcve");
        SourceQuery sq6 = new SourceQuery(so);
        System.out.println("Test 6 one in category t10 & one in t11 and facet datasource\n");
        System.out.println(sq6.buildQuery() + "\n");
        so.init();
        so.setFacet_ds("somesourcve");
        SourceQuery sq7 = new SourceQuery(so);
        System.out.println("Test 7 facet datasource only \n");
        System.out.println(sq7.buildQuery() + "\n");
    }
}

