/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.services;

import gov.ornl.mercury3.commands.CitationDateDisplayUtil;
import gov.ornl.mercury3.commands.Configuration;
import gov.ornl.mercury3.commands.DatasourceBean;
import gov.ornl.mercury3.commands.Field;
import gov.ornl.mercury3.commands.FilterCatField;
import gov.ornl.mercury3.commands.Geo;
import gov.ornl.mercury3.commands.InstanceBean;
import gov.ornl.mercury3.commands.Response;
import gov.ornl.mercury3.commands.Search_Terms;
import gov.ornl.mercury3.commands.SolrDate;
import gov.ornl.mercury3.commands.SolrTransactionDetail;
import gov.ornl.mercury3.commands.Terms;
import gov.ornl.mercury3.services.DataSourceMapNamesBean;
import gov.ornl.mercury3.services.MercuryTermMapBean;
import gov.ornl.mercury3.services.SolrFacets;
import gov.ornl.mercury3.services.SolrFields;
import gov.ornl.mercury3.services.SolrSearcher;
import gov.ornl.mercury3.services.SourceQuery;
import gov.ornl.mercury3.web.util.MemberNodeSourcesMapCache;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.UrlValidator;
import org.dataone.service.types.v1.Session;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SolrTransactionServiceDelegate {
    private static final String dataFilterString = "has direct data";
    private DataSourceMapNamesBean dsmnb = new DataSourceMapNamesBean();
    private MercuryTermMapBean km = new MercuryTermMapBean();
    private boolean buildCartURLs = false;
    private HashMap<String, Object> hmProps = new HashMap();
    private ApplicationContext factory3 = null;
    private boolean globalOverlaps = false;
    private boolean globalEncloses = false;
    private boolean IsfacetDS = false;
    private Map<String, String> datasourceMapNames = new HashMap<String, String>();
    private HashMap<String, String> briefRes2 = new HashMap();
    private String solrSelectURL = "";
    private String source = "";
    private String solrdb = "";
    private HashMap<String, String> keyMap = new HashMap();
    private boolean use_mn_source_cache = false;

    public SolrTransactionServiceDelegate() {
        ClassPathXmlApplicationContext factory = new ClassPathXmlApplicationContext("Mercury3Properties.xml");
        Configuration cv = (Configuration)factory.getBean("propertiesBean");
        this.hmProps = cv.getProperties();
        this.buildCartURLs = Boolean.parseBoolean((String)this.hmProps.get("buildCartURLs"));
        this.solrdb = (String)this.hmProps.get("solrdb");
        this.solrSelectURL = (String)this.hmProps.get("solrSelectURL");
        try {
            this.globalOverlaps = Boolean.parseBoolean((String)this.hmProps.get("globalOverlaps"));
            this.globalEncloses = Boolean.parseBoolean((String)this.hmProps.get("globalEncloses"));
        }
        catch (Exception ex) {
            System.out.println(" globalOverlaps or globalEncloses was not retrieved from Mercury3Properties.xml ");
            ex.printStackTrace();
        }
        this.factory3 = new ClassPathXmlApplicationContext("gov/ornl/mercury3/services/Mercury_term_maps.xml");
        this.dsmnb = (DataSourceMapNamesBean)this.factory3.getBean("datasource_map_names");
        this.km = (MercuryTermMapBean)this.factory3.getBean("query_string_map");
        this.datasourceMapNames = this.dsmnb.getDatasourceMapNames();
        this.use_mn_source_cache = Boolean.parseBoolean((String)this.hmProps.get("use_mn_source_cache"));
        if (this.use_mn_source_cache) {
            this.datasourceMapNames = MemberNodeSourcesMapCache.INSTANCE.getMNSourceMap();
        }
        this.keyMap = this.km.getTermMap();
    }

    private String convertToBrief(String date) {
        SimpleDateFormat Solr_ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat Brief_Format = new SimpleDateFormat("MM/dd/yyyy");
        try {
            Solr_ISO8601FORMAT.parse(date, new ParsePosition(0));
        }
        catch (Exception pex) {
            pex.printStackTrace();
        }
        return Brief_Format.format(Solr_ISO8601FORMAT.getCalendar().getTime());
    }

    private String convertToPRT(String date) {
        SimpleDateFormat PRT_Format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat Brief_Format = new SimpleDateFormat("MM/dd/yyyy");
        try {
            Brief_Format.parse(date, new ParsePosition(0));
        }
        catch (Exception pex) {
            pex.printStackTrace();
        }
        return PRT_Format.format(Brief_Format.getCalendar().getTime());
    }

    private HashMap buildShopnCartURL(Search_Terms st) {
        ClassPathXmlApplicationContext jims_beanfactory = new ClassPathXmlApplicationContext("gov/ornl/mercury3/services/instanceConfig.xml");
        HashMap t_prt = st.getParsed_request_terms();
        InstanceBean instance = (InstanceBean)jims_beanfactory.getBean(st.getWebAppRoot());
        DatasourceBean dsb = instance.getDatasources().get(st.getDatasource());
        if (null != dsb) {
            HashMap<String, String> t_hm = dsb.getDataSourceParameters();
            StringBuilder t_url = new StringBuilder();
            if (null != t_hm.get("url")) {
                t_url.append(t_hm.get("url"));
            } else {
                t_url.append("Look for problem in spring xml file");
            }
            Iterator<String> t_it = t_hm.keySet().iterator();
            int t_item = 0;
            HashMap<String, String> cart_urls2 = new HashMap<String, String>();
            while (t_it.hasNext()) {
                String key = t_it.next();
                if (key.trim().length() <= 0) continue;
                String value2 = t_hm.get(key);
                if (key.equalsIgnoreCase("url")) continue;
                if (null != t_prt.get(key) && ((String)t_prt.get(key)).length() > 0) {
                    if (t_item > 0) {
                        t_url.append("&" + value2 + "=" + (String)t_prt.get(key));
                    } else {
                        t_url.append(value2 + "=" + (String)t_prt.get(key));
                        ++t_item;
                    }
                }
                cart_urls2.put(key, value2);
            }
            t_url.append("&" + t_hm.get("ID") + "=");
            cart_urls2.put(st.getDatasource(), t_url.toString());
            return cart_urls2;
        }
        HashMap cart_urls3 = new HashMap();
        return cart_urls3;
    }

    public SolrTransactionDetail getSolrTransactionDetail(Search_Terms st, Session d1Session, List<String> queryFilters) {
        ArrayList briefList2;
        List<Map<String, Field>> documents;
        LinkedHashMap<FilterCatField, List> facets;
        Response res;
        ArrayList<Map.Entry<FilterCatField, List>> j_facets;
        String query;
        SolrTransactionDetail solrTransactionDetail;
        StringBuffer displaySB;
        ArrayList<Object> j_Docs;
        boolean noQuery;
        block163: {
            String new_term2 = "";
            String _dismaxSort = null;
            String new_term22 = "";
            String fs = "";
            String descr = "";
            Geo geom = new Geo();
            SolrDate sdate = new SolrDate();
            SolrDate sdate2 = new SolrDate();
            HashMap<String, String> prt = new HashMap<String, String>();
            HashMap getDataValue = new HashMap();
            noQuery = false;
            j_Docs = new ArrayList();
            boolean term2 = false;
            boolean term12 = false;
            boolean browse = false;
            boolean solr_facets = false;
            ClassPathXmlApplicationContext xf = new ClassPathXmlApplicationContext("gov/ornl/mercury3/services/facets.xml");
            displaySB = new StringBuffer();
            StringBuffer sb2 = new StringBuffer("");
            boolean DataSourceClauseGenerated = false;
            boolean DataSourceFacetClauseGenerated = false;
            boolean LTERSiteFacetClauseGenerated = false;
            boolean LTERFacet = false;
            boolean DataSourceIsAll = false;
            boolean NoLTERGranules = false;
            if (null != st && null != st.getGui_queryString()) {
                sb2.append(st.getGui_queryString());
            }
            solrTransactionDetail = new SolrTransactionDetail();
            query = "";
            ArrayList arrayList = new ArrayList();
            j_facets = null;
            solrTransactionDetail.setAccountsList(arrayList);
            res = new Response();
            facets = null;
            documents = null;
            briefList2 = new ArrayList();
            SolrFacets sf = (SolrFacets)xf.getBean("facetsBean");
            SolrFields sfld = (SolrFields)xf.getBean("fieldBean");
            ArrayList facetsList = (ArrayList)sf.getFacets();
            ArrayList filedsList = (ArrayList)sfld.getFields();
            try {
                String t9value;
                String sourceData;
                SolrSearcher solrSearcher = new SolrSearcher(this.solrSelectURL);
                StringBuffer sb = new StringBuffer();
                if (null != st.getTerm1() && null != st.getTerm1().getValue() && st.getTerm1().getValue().trim().length() > 0 && null != st.getTerm1().getAttribute() && st.getTerm1().getAttribute().trim().length() > 0) {
                    String t1 = st.getTerm1().getValue().trim();
                    sb.append(" ( " + t1 + " ) ");
                    displaySB.append(" " + t1);
                }
                ArrayList alt2 = st.getTerm2_list();
                boolean hasterm2 = false;
                ArrayList<Terms> filledInTerms = new ArrayList<Terms>();
                for (Terms tl2 : alt2) {
                    if (null == tl2 || null == tl2.getValue() || tl2.getValue().trim().length() <= 0 || null == tl2.getAttribute() || tl2.getAttribute().trim().length() <= 0) continue;
                    hasterm2 = true;
                    filledInTerms.add(tl2);
                }
                if (hasterm2) {
                    if (sb.length() > 0) {
                        sb.append(" AND ( ");
                        displaySB.append(" AND ( ");
                    } else {
                        sb.append(" ( ");
                        displaySB.append(" ( ");
                    }
                }
                Iterator iterator = filledInTerms.iterator();
                while (iterator.hasNext()) {
                    Terms term = (Terms)iterator.next();
                    if (!term.getAttribute().trim().contains("fullText") && term.getAttribute().trim().contains("Text")) {
                        sb.append(" ( " + term.getValue() + " )");
                        displaySB.append(term.getValue().trim());
                        term2 = true;
                    } else {
                        String tmp = term.getValue().trim();
                        String temp = term.getAttribute().trim();
                        String temp1 = tmp.replaceAll("AND", "AND " + temp + ":").replaceAll("OR", "OR " + temp + ":");
                        sb.append(" ( " + tmp + " )");
                        if (displaySB.length() > 0) {
                            displaySB.append(" ( " + tmp + " )");
                        } else {
                            displaySB.append(" ( " + tmp + " )");
                        }
                        term2 = true;
                    }
                    if (null == term.getOperation() || term.getOperation().trim().length() <= 0 || !iterator.hasNext()) continue;
                    sb.append(" " + term.getOperation().trim() + " ");
                    displaySB.append(" " + term.getOperation().trim() + " ");
                }
                if (hasterm2) {
                    sb.append(" )");
                    displaySB.append(")");
                }
                if (null != st.getTerm12() && null != st.getTerm12().getValue() && st.getTerm12().getValue().length() > 0 && null != st.getTerm12().getAttribute() && st.getTerm12().getAttribute().length() > 0) {
                    if (sb.length() > 0 && null != st.getTerm12().getOperation() && st.getTerm12().getOperation().trim().length() > 0) {
                        sb.append(" " + st.getTerm12().getOperation().trim() + " ");
                        displaySB.append(" " + this.getDisplay(st.getTerm12().getOperation().trim()) + " ");
                    }
                    if (!st.getTerm12().getAttribute().trim().contains("fullText") && st.getTerm12().getAttribute().trim().contains("Text")) {
                        sb.append(" ( " + st.getTerm12().getAttribute().trim() + ":" + "\"" + st.getTerm12().getValue().trim().replaceAll("\"", "") + "\"" + " )");
                        displaySB.append(this.getDisplay(st.getTerm12().getAttribute().trim()) + ":" + st.getTerm12().getValue().trim());
                        term12 = true;
                    } else {
                        sb.append(" ( " + st.getTerm12().getAttribute().trim() + ":" + st.getTerm12().getValue().trim() + " )");
                        displaySB.append(st.getTerm12().getAttribute().trim() + ":" + st.getTerm12().getValue().trim());
                        term12 = true;
                    }
                }
                if (st.getFilterForData()) {
                    if (sb.length() > 0) {
                        sb.append(" AND ");
                        displaySB.append(" AND ");
                    }
                    sb.append("resourceMap:*");
                    displaySB.append(dataFilterString);
                }
                if (null != st.getBrowse() && null != st.getBrowse().getValue() && st.getBrowse().getValue().trim().length() > 0 && null != st.getBrowse().getAttribute() && st.getBrowse().getAttribute().trim().length() > 0) {
                    if (sb.length() > 0) {
                        sb.append(" AND ");
                        displaySB.append(" AND ");
                    }
                    sb.append(st.getBrowse().getAttribute().trim() + ":" + st.getBrowse().getValue().trim());
                    displaySB.append(this.getDisplay(st.getBrowse().getAttribute().trim()) + ":" + st.getBrowse().getValue().trim());
                    browse = true;
                }
                if (null != st.getTerm3() && st.getTerm3().getAttribute().length() > 0 && st.getTerm3().getValue().length() > 0) {
                    if (geom.setbounds(st.getTerm3().getValue())) {
                        prt.put("SouthBoundCoord", Float.toString(geom.getSouthBoundCoord()));
                        prt.put("EastBoundCoord", Float.toString(geom.getEastBoundCoord()));
                        prt.put("NorthBoundCoord", Float.toString(geom.getNorthBoundCoord()));
                        prt.put("WestBoundCoord", Float.toString(geom.getWestBoundCoord()));
                        String geoFragment = "";
                        String ew_in_range_test = "";
                        String corner_test = "";
                        String east_in_range = "";
                        String west_in_range = "";
                        String ew_out_of__range_test = "";
                        if (geom.getWestBoundCoord() >= 0.0f && geom.getEastBoundCoord() < 0.0f) {
                            corner_test = "";
                            geoFragment = "(( eastBoundCoord:[" + geom.getEastBoundCoord() + " TO 0.0] " + " ) " + "AND (westBoundCoord:[0.0 TO " + geom.getWestBoundCoord() + " ]" + " ))";
                            ew_in_range_test = "((eastBoundCoord:[-180.0 TO " + geom.getEastBoundCoord() + "] OR " + "(eastBoundCoord:[" + geom.getWestBoundCoord() + " TO 180.0]) OR " + "(westBoundCoord:[-180 TO " + geom.getEastBoundCoord() + "]) OR " + "(westBoundCoord:[" + geom.getWestBoundCoord() + " TO 180])))";
                            east_in_range = "((eastBoundCoord:[-180.0 TO " + geom.getEastBoundCoord() + "] OR " + "(eastBoundCoord:[" + geom.getWestBoundCoord() + " TO 180.0]))) ";
                            west_in_range = "((westBoundCoord:[-180 TO " + geom.getEastBoundCoord() + "]) OR " + "(westBoundCoord:[" + geom.getWestBoundCoord() + " TO 180]))";
                            corner_test = ew_in_range_test;
                            ew_out_of__range_test = geoFragment;
                        } else if (geom.getWestBoundCoord() >= 0.0f && geom.getEastBoundCoord() >= 0.0f) {
                            corner_test = " (( westBoundCoord:[" + geom.getEastBoundCoord() + " TO " + geom.getWestBoundCoord() + "]) OR " + "eastBoundCoord:[" + geom.getEastBoundCoord() + " TO " + geom.getWestBoundCoord() + "]) )";
                            geoFragment = "(( eastBoundCoord:[" + geom.getEastBoundCoord() + " TO 180.0] " + " ) " + "AND (westBoundCoord:[0.0 TO " + geom.getWestBoundCoord() + " ]" + " OR westBoundCoord:[ -180.0  TO 0.0]))";
                            if (geom.getEastBoundCoord() > geom.getWestBoundCoord()) {
                                ew_in_range_test = "((eastBoundCoord:[" + geom.getWestBoundCoord() + " TO " + geom.getEastBoundCoord() + "]) OR " + "(westBoundCoord:[" + geom.getWestBoundCoord() + " TO " + geom.getEastBoundCoord() + "]))";
                                east_in_range = "(eastBoundCoord:[" + geom.getWestBoundCoord() + " TO " + geom.getEastBoundCoord() + "])";
                                west_in_range = "(westBoundCoord:[" + geom.getWestBoundCoord() + " TO " + geom.getEastBoundCoord() + "])";
                            } else {
                                ew_in_range_test = " (( westBoundCoord:[" + geom.getEastBoundCoord() + " TO " + geom.getWestBoundCoord() + "]) OR " + "eastBoundCoord:[" + geom.getEastBoundCoord() + " TO " + geom.getWestBoundCoord() + "]) )";
                                east_in_range = "(eastBoundCoord:[" + geom.getEastBoundCoord() + " TO " + geom.getWestBoundCoord() + "])";
                                west_in_range = "( westBoundCoord:[" + geom.getEastBoundCoord() + " TO " + geom.getWestBoundCoord() + "]) ";
                            }
                            corner_test = " ( " + east_in_range + " OR " + west_in_range + " ) ";
                        } else if (geom.getWestBoundCoord() < 0.0f && geom.getEastBoundCoord() < 0.0f) {
                            corner_test = "";
                            geoFragment = "((  eastBoundCoord:[" + geom.getEastBoundCoord() + " TO 0.0] " + " OR eastBoundCoord:[0.0  TO 180.0]) " + "AND (westBoundCoord:[-180.0 TO " + geom.getWestBoundCoord() + " ]" + "  " + " ))";
                            if (geom.getEastBoundCoord() > geom.getWestBoundCoord()) {
                                ew_in_range_test = "((eastBoundCoord:[" + geom.getWestBoundCoord() + " TO " + geom.getEastBoundCoord() + "]) OR " + "(westBoundCoord:[" + geom.getWestBoundCoord() + " TO " + geom.getEastBoundCoord() + "]))";
                                east_in_range = "((eastBoundCoord:[" + geom.getWestBoundCoord() + " TO " + geom.getEastBoundCoord() + "]))";
                                west_in_range = "((westBoundCoord:[" + geom.getWestBoundCoord() + " TO " + geom.getEastBoundCoord() + "]))";
                            } else if (geom.getEastBoundCoord() < geom.getWestBoundCoord()) {
                                ew_in_range_test = "((eastBoundCoord:[0.0 TO " + geom.getWestBoundCoord() + " ]) OR " + "(eastBoundCoord:[0.0 TO 180.0 ]) OR " + "(eastBoundCoord:[-180 TO " + geom.getEastBoundCoord() + " ]) OR " + "(westBoundCoord:[0.0 TO " + geom.getWestBoundCoord() + " ]) OR " + "(westBoundCoord:[0.0 TO 180.0 ]) OR " + "(westBoundCoord:[-180 TO " + geom.getEastBoundCoord() + " ]) ) ";
                                east_in_range = "((eastBoundCoord:[0.0 TO " + geom.getWestBoundCoord() + " ]) OR " + "(eastBoundCoord:[0.0 TO 180.0 ]) OR " + "(eastBoundCoord:[-180 TO " + geom.getEastBoundCoord() + " ]))  ";
                                west_in_range = "((westBoundCoord:[0.0 TO " + geom.getWestBoundCoord() + " ]) OR " + "(westBoundCoord:[0.0 TO 180.0 ]) OR " + "(westBoundCoord:[-180 TO " + geom.getEastBoundCoord() + " ]) ) ";
                            }
                            corner_test = ew_in_range_test;
                        } else if (geom.getWestBoundCoord() < 0.0f && geom.getEastBoundCoord() > 0.0f) {
                            corner_test = "";
                            geoFragment = "(( eastBoundCoord:[" + geom.getEastBoundCoord() + " TO 180.0] " + " ) " + "AND (westBoundCoord:[-180.0 TO " + geom.getWestBoundCoord() + " ]" + "  " + " ))";
                            corner_test = ew_in_range_test = "((eastBoundCoord:[0.0 TO " + geom.getEastBoundCoord() + "]) OR " + "(eastBoundCoord:[" + geom.getWestBoundCoord() + " TO 0.0]) OR " + "(westBoundCoord:[0 TO " + geom.getEastBoundCoord() + "]) OR " + "(westBoundCoord:[" + geom.getWestBoundCoord() + " TO 0.0]))";
                            east_in_range = "((eastBoundCoord:[0.0 TO " + geom.getEastBoundCoord() + "]) OR " + "(eastBoundCoord:[" + geom.getWestBoundCoord() + " TO 0.0]))  ";
                            west_in_range = "((westBoundCoord:[0 TO " + geom.getEastBoundCoord() + "]) OR " + "(westBoundCoord:[" + geom.getWestBoundCoord() + " TO 0.0]))";
                        }
                        if (st.getTerm3().getAttribute().trim().equalsIgnoreCase("ENCLOSES")) {
                            if (sb.length() > 0) {
                                sb.append(" AND  ");
                                displaySB.append(" AND ");
                            }
                            sb.append("((((northBoundCoord:[" + geom.getSouthBoundCoord() + " TO " + geom.getNorthBoundCoord() + "]" + " AND " + "southBoundCoord:[" + geom.getSouthBoundCoord() + " TO " + geom.getNorthBoundCoord() + "]" + " AND " + east_in_range + " AND " + west_in_range + " )) ");
                            if (this.globalEncloses) {
                                sb.append(" ) OR  isSpatial:true )");
                            } else {
                                sb.append(" ) NOT  isSpatial:true )");
                            }
                            displaySB.append(" encloses coordinates (N,W,S,E)= (" + geom.getNorthBoundCoord() + "," + geom.getWestBoundCoord() + "," + geom.getSouthBoundCoord() + "," + geom.getEastBoundCoord() + ") ");
                        }
                        if (st.getTerm3().getAttribute().trim().equalsIgnoreCase("OVERLAPS")) {
                            if (sb.length() > 0) {
                                sb.append(" AND ( ");
                            } else {
                                sb.append("  ( ");
                            }
                            sb.append("( (northBoundCoord:[" + geom.getSouthBoundCoord() + " TO " + geom.getNorthBoundCoord() + "]" + " AND " + corner_test + ")" + " OR (" + "southBoundCoord:[" + geom.getSouthBoundCoord() + " TO " + geom.getNorthBoundCoord() + "] " + " AND " + corner_test + ")" + " OR (" + "northBoundCoord:[" + geom.getNorthBoundCoord() + " TO 90.0" + " ]" + " AND " + "southBoundCoord:[ -90.0 " + " TO " + geom.getSouthBoundCoord() + "] " + " AND " + ew_in_range_test + ")" + " OR (( northBoundCoord:[" + geom.getSouthBoundCoord() + " TO " + geom.getNorthBoundCoord() + "] OR " + "southBoundCoord:[" + geom.getSouthBoundCoord() + " TO " + geom.getNorthBoundCoord() + "] )" + " AND " + geoFragment + " )" + " OR (" + "northBoundCoord:[" + geom.getNorthBoundCoord() + " TO 90.0" + " ]" + " AND " + "southBoundCoord:[ -90.0 " + " TO " + geom.getSouthBoundCoord() + "] " + " AND " + geoFragment + " )");
                            displaySB.append(" overlaps coordinates (N,W,S,E)= (" + geom.getNorthBoundCoord() + "," + geom.getWestBoundCoord() + "," + geom.getSouthBoundCoord() + "," + geom.getEastBoundCoord() + ") ");
                            if (this.globalOverlaps) {
                                sb.append(" ) OR  isSpatial:true )");
                            } else {
                                sb.append(" ) NOT  isSpatial:true )");
                            }
                        }
                    } else {
                        solrTransactionDetail.setGeoError(true);
                    }
                }
                String prt_BeginDate = "";
                try {
                    prt_BeginDate = this.convertToPRT(st.getTerm4().getValue().trim());
                }
                catch (Exception ew_in_range_test) {
                    // empty catch block
                }
                prt.put("BeginDate", prt_BeginDate);
                String prt_EndDate = "";
                try {
                    prt_EndDate = this.convertToPRT(st.getTerm5().getValue().trim());
                }
                catch (Exception corner_test) {
                    // empty catch block
                }
                prt.put("EndDate", prt_EndDate);
                if (null != st.getSearchmode() && null != st.getSearchmode().getValue() && "" != st.getSearchmode().getValue() && !(sourceData = st.getSearchmode().getValue().trim()).equalsIgnoreCase("webdb")) {
                    sb.append(" ( " + st.getSearchmode().getAttribute().trim() + ":" + sourceData + " ) ");
                }
                st.setParsed_request_terms(prt);
                st.setDataValue(getDataValue);
                if (null != st.getTerm4()) {
                    if (st.getTerm4().getOperation().trim().equalsIgnoreCase("after") && null != st.getTerm4().getAttribute() && st.getTerm4().getAttribute().length() > 0 && sdate.setDate(st.getTerm4().getValue().trim())) {
                        if (sb.length() > 0) {
                            sb.append(" AND ");
                        }
                        sb.append(st.getTerm4().getAttribute().trim() + ":[");
                        sb.append(sdate.getYear().trim() + "-" + sdate.getMonth().trim() + "-" + sdate.getDay().trim() + "T23:59:59Z");
                        sb.append(" TO *]");
                        displaySB.append(" AND " + st.getTerm4().getOperation().trim() + " " + sdate.getMonth().trim() + "/" + sdate.getDay().trim() + "/" + sdate.getYear().trim());
                    }
                    if (st.getTerm4().getOperation().trim().equalsIgnoreCase("before") && null != st.getTerm4().getAttribute() && st.getTerm4().getAttribute().length() > 0 && sdate.setDate(st.getTerm4().getValue().trim())) {
                        if (sb.length() > 0) {
                            sb.append(" AND ");
                        }
                        sb.append(st.getTerm4().getAttribute().trim() + ":[* TO ");
                        sb.append(sdate.getYear() + "-" + sdate.getMonth() + "-" + sdate.getDay().trim() + "T23:59:59Z]");
                        displaySB.append(" AND " + st.getTerm4().getOperation().trim() + " " + sdate.getMonth().trim() + "/" + sdate.getDay().trim() + "/" + sdate.getYear().trim());
                    }
                    if (st.getTerm4().getOperation().trim().equalsIgnoreCase("during") && null != st.getTerm5() && null != st.getTerm4().getAttribute() && st.getTerm4().getAttribute().length() > 0 && null != st.getTerm5().getAttribute() && st.getTerm5().getAttribute().length() > 0 && sdate.setDate(st.getTerm4().getValue().trim()) && sdate2.setDate(st.getTerm5().getValue().trim())) {
                        if (sb.length() > 0) {
                            sb.append(" AND  ( ");
                        } else {
                            sb.append("  ( ");
                        }
                        sb.append(st.getTerm4().getAttribute().trim() + ":[");
                        sb.append(sdate.getYear().trim() + "-" + sdate.getMonth().trim() + "-" + sdate.getDay().trim() + "T23:59:59Z");
                        sb.append(" TO ");
                        sb.append(sdate2.getYear() + "-" + sdate2.getMonth() + "-" + sdate2.getDay().trim() + "T23:59:59Z]");
                        displaySB.append(" " + st.getTerm4().getOperation().trim() + " " + sdate.getMonth().trim() + "/" + sdate.getDay().trim() + "/" + sdate.getYear().trim());
                        displaySB.append(" to " + sdate2.getMonth().trim() + "/" + sdate2.getDay().trim() + "/" + sdate2.getYear().trim());
                        sb.append(" OR ");
                        sb.append(st.getTerm5().getAttribute().trim() + ":[");
                        sb.append(sdate.getYear().trim() + "-" + sdate.getMonth().trim() + "-" + sdate.getDay().trim() + "T23:59:59Z");
                        sb.append(" TO ");
                        sb.append(sdate2.getYear() + "-" + sdate2.getMonth() + "-" + sdate2.getDay().trim() + "T23:59:59Z]");
                        sb.append(" OR ( ( ");
                        if (null != st.getTerm4().getAttribute() && st.getTerm4().getAttribute().length() > 0 && sdate.setDate(st.getTerm4().getValue().trim())) {
                            sb.append(st.getTerm4().getAttribute().trim() + ":[* TO ");
                            sb.append(sdate.getYear() + "-" + sdate.getMonth() + "-" + sdate.getDay().trim() + "T23:59:59Z]");
                        }
                        sb.append(" ) AND ( ");
                        if (null != st.getTerm5().getAttribute() && st.getTerm5().getAttribute().length() > 0 && sdate.setDate(st.getTerm5().getValue().trim())) {
                            sb.append(st.getTerm5().getAttribute().trim() + ":[");
                            sb.append(sdate.getYear().trim() + "-" + sdate.getMonth().trim() + "-" + sdate.getDay().trim() + "T23:59:59Z");
                            sb.append(" TO *]");
                        }
                        sb.append(" ) ) ) ");
                    }
                }
                if (sb.toString().trim().length() > 0) {
                    SourceQuery sq = new SourceQuery(st.getSo());
                    sb.append(sq.buildQuery());
                    displaySB.append(sq.build_display_query());
                }
                if (null != st.getSolr_facets_map() && st.getSolr_facets_map().size() > 0) {
                    for (String facetkey : st.getSolr_facets_map().keySet()) {
                        if (null == facetkey || facetkey.trim().length() <= 0) continue;
                        String value2 = (String)st.getSolr_facets_map().get(facetkey);
                        if (!facetkey.contains("datasource")) {
                            sb.append(" AND  ");
                            sb.append(facetkey + ":" + "\"" + value2 + "\"");
                            displaySB.append(" AND " + this.getDisplay(facetkey) + ":" + value2);
                        }
                        solr_facets = true;
                    }
                }
                boolean hideDataSource = false;
                if (null != st.getDatasources() && st.getDatasources().size() > 0) {
                    ArrayList temp_src = st.getDatasources();
                    if (solr_facets) {
                        if (null != st.getFacet() && !st.getFacet().getAttribute().equalsIgnoreCase("datasource")) {
                            if (temp_src.contains(st.getFacet().getValue())) {
                                temp_src.remove(st.getFacet().getValue());
                            }
                        } else if (null != st.getFacet() && st.getFacet().getAttribute().equalsIgnoreCase("datasource")) {
                            hideDataSource = true;
                            st.setHideDS("true");
                            solrTransactionDetail.setHideDS("true");
                        }
                    }
                    String datasourcesString = "";
                    if (!(LTERSiteFacetClauseGenerated || Boolean.getBoolean(st.getHideDS()) && hideDataSource || this.IsfacetDS || temp_src.size() <= 0)) {
                        if (temp_src.size() <= 0 || hideDataSource || !this.IsfacetDS) {
                            // empty if block
                        }
                        for (int i = 0; i < temp_src.size(); ++i) {
                            if (!((String)temp_src.get(i)).trim().equalsIgnoreCase("all") && !DataSourceIsAll) {
                                if (sb.length() > 0 && i == 0) {
                                    DataSourceClauseGenerated = true;
                                }
                                if (sb.length() <= 0 || i > 0) {
                                    // empty if block
                                }
                                if (hideDataSource || this.IsfacetDS) continue;
                                datasourcesString = datasourcesString.concat((String)temp_src.get(i) + " ");
                                if (!((String)temp_src.get(i)).equalsIgnoreCase("lter")) continue;
                                NoLTERGranules = true;
                                continue;
                            }
                            DataSourceIsAll = true;
                        }
                        if (temp_src.size() <= 0 || hideDataSource || this.IsfacetDS || !DataSourceIsAll) {
                            // empty if block
                        }
                    }
                }
                if (term2 && facetsList.size() > 0) {
                    ArrayList alt22 = st.getTerm2_list();
                    for (Terms tl2 : alt22) {
                        if (!facetsList.contains(tl2.getAttribute().replaceAll("Text", ""))) continue;
                        facetsList.remove(facetsList.indexOf(tl2.getAttribute().replaceAll("Text", "")));
                    }
                }
                if (facetsList.size() > 0) {
                    if (null != st.getSolr_facets_map() && st.getSolr_facets_map().size() > 0) {
                        for (String facetkey : st.getSolr_facets_map().keySet()) {
                            if (facetkey.trim().length() <= 0 || !facetsList.contains(facetkey.replaceAll("Text", ""))) continue;
                            facetsList.remove(facetkey.replaceAll("Text", ""));
                        }
                    }
                    if (null != st.getDatasources() && st.getDatasources().size() == 1) {
                        ArrayList local_list = st.getDatasources();
                        if (facetsList.contains("datasource") && !((String)local_list.get(0)).trim().equalsIgnoreCase("all")) {
                            facetsList.remove("datasource");
                        }
                    }
                }
                if (null != st.getTerm7() && null != st.getTerm7().getValue() && st.getTerm7().getValue().length() > 0 && null != st.getTerm7().getAttribute() && st.getTerm7().getAttribute().length() > 0) {
                    if (sb.length() > 0) {
                        sb.append(" AND ");
                        displaySB.append(" AND ");
                    }
                    sb.append(st.getTerm7().getAttribute().trim() + ":" + st.getTerm7().getValue().trim());
                    displaySB.append(st.getTerm7().getAttribute().trim() + ":" + st.getTerm7().getValue().trim());
                }
                if (null != st.getTerm9() && null != st.getTerm9().getValue() && st.getTerm9().getValue().length() > 0 && null != st.getTerm9().getAttribute() && st.getTerm9().getAttribute().length() > 0 && !(t9value = st.getTerm9().getValue().toLowerCase()).contains("all")) {
                    if (sb.length() > 0) {
                        sb.append(" AND ");
                        displaySB.append(" AND ");
                    }
                    sb.append(st.getTerm9().getAttribute().trim() + ":" + "\"" + st.getTerm9().getValue().trim() + "\"");
                    displaySB.append(st.getTerm9().getAttribute().trim() + ":" + st.getTerm9().getValue().trim());
                }
                if (sb.toString().trim().length() > 0) {
                    query = " ( " + sb.toString() + " ) ";
                    if (null != st.getAdditional_datasource() && st.getAdditional_datasource().trim().length() > 0) {
                        query = "( (" + sb.toString() + ") OR datasource:" + st.getAdditional_datasource().trim() + " )";
                    }
                    if (null != st.getSortattribute()) {
                        String sorttest = st.getSortattribute().trim();
                        solrTransactionDetail.setSortattribute(sorttest);
                        if (!sorttest.equalsIgnoreCase("default")) {
                            _dismaxSort = sorttest.contains("Date") || sorttest.contains("date") || sorttest.contains("metrd") ? sorttest + " desc" : sorttest + " asc";
                        }
                    }
                }
                if (st.isMLT()) {
                    query = st.getMlt_request_terms().size() > 0 && null != st.getMlt_request_terms().get("q")[0] ? st.getMlt_request_terms().get("q")[0] : "";
                }
                String term1Value = "";
                term1Value = st.getRawTerm1().trim();
                if (query.trim().length() > 0) {
                    res = solrSearcher.search(query, st.getStart(), st.getPageSize(), filedsList, "", null, _dismaxSort, "true", "100", facetsList, "datasource", "100", st.getIsRSS(), st.getFeedValue(), st.isMLT(), term1Value, queryFilters, d1Session);
                } else {
                    noQuery = true;
                }
                if (noQuery) break block163;
                ArrayList gkw = new ArrayList();
                documents = res.getDocuments();
                for (int i = 0; i < documents.size(); ++i) {
                    HashMap aField = (HashMap)documents.get(i);
                    HashMap<String, Object> aBriefRes2 = new HashMap<String, Object>();
                    HashMap<String, String> art = new HashMap<String, String>();
                    HashMap getdataValue = new HashMap();
                    String thisType = "";
                    String thisName = "";
                    String thisValue = "";
                    ArrayList tl = new ArrayList();
                    for (String fieldNameStr : aField.keySet()) {
                        Field fieldStr = (Field)aField.get(fieldNameStr);
                        thisType = fieldStr.getType();
                        thisName = fieldStr.getName();
                        thisValue = fieldStr.getValue();
                        tl = fieldStr.getValueList();
                        if (thisType.contains("arr") && thisName.length() > 0 && tl.size() > 0) {
                            if (thisName.equals("origin")) {
                                String investigatorString = "";
                                int count = 0;
                                for (Object obj : tl) {
                                    String investigatorValue = (String)obj;
                                    investigatorString = investigatorString + investigatorValue + "; ";
                                    if (++count <= 9) continue;
                                    investigatorString = investigatorString + "et al.";
                                    break;
                                }
                                aBriefRes2.put("investigators", StringUtils.removeEnd((String)investigatorString, (String)"; "));
                                continue;
                            }
                            aBriefRes2.put(thisName, tl);
                            if (fieldStr.getName().equalsIgnoreCase("gcmdKeyword")) {
                                gkw = fieldStr.getValueList();
                                aBriefRes2.put("gcmdList", gkw);
                            } else if (fieldStr.getName().equalsIgnoreCase("data_url") && null != fieldStr.getValue()) {
                                if (fieldStr.getValue().contains("WMS")) {
                                    ArrayList viewdataurl = fieldStr.getValueList();
                                    for (int url = 0; url < viewdataurl.size(); ++url) {
                                        String parseURL = viewdataurl.get(url).toString();
                                        if (!parseURL.contains("WMS")) continue;
                                        art.put("NsidcData_url", parseURL);
                                    }
                                } else {
                                    ArrayList data_url_Value = fieldStr.getValueList();
                                    getdataValue.put("data_url", data_url_Value.get(0));
                                    st.setDataValue(getdataValue);
                                    art.put("Data_url", fieldStr.getValue());
                                }
                            }
                        } else if (thisType.contains("str") && thisName.length() > 0 && thisValue.length() > 0) {
                            aBriefRes2.put(thisName, thisValue);
                            if (thisName.equals("id")) {
                                String mlt_id = thisValue;
                                String mlt_id2 = "";
                                if (mlt_id != null && mlt_id.length() > 0) {
                                    mlt_id2 = mlt_id.replaceAll("\\\\", "\\\\\\\\");
                                    aBriefRes2.put("mlt_id", mlt_id2);
                                }
                            }
                            if (thisName.equals("author")) {
                                aBriefRes2.put("author", thisValue);
                                continue;
                            }
                            if (thisName.equals("dataUrl")) {
                                aBriefRes2.put("dataUrl", thisValue);
                                continue;
                            }
                            if (thisName.contains("abstract")) {
                                if (thisValue.length() > 600) {
                                    aBriefRes2.put("subabstractStr", thisValue.substring(0, 600));
                                    aBriefRes2.put("abstractStr", thisValue.substring(0, 600));
                                } else {
                                    aBriefRes2.put("subabstractStr", thisValue);
                                    aBriefRes2.put("abstractStr", thisValue);
                                }
                            }
                            if (thisName.contains("data_url")) {
                                String[] schemes = new String[]{"http", "https", "ftp"};
                                UrlValidator urlValidator = new UrlValidator(schemes);
                                String actURL = thisValue.toString().replaceAll("<", "").replaceAll(">", "");
                                if (urlValidator.isValid(actURL)) {
                                    aBriefRes2.put("data_url", actURL);
                                } else {
                                    aBriefRes2.put("data_url", "");
                                }
                            }
                            if (fieldStr.getName().equalsIgnoreCase("datasource")) {
                                fs = fieldStr.getValue();
                                descr = this.datasourceMapNames.get(fs);
                                if (null != descr && descr.length() > 0) {
                                    aBriefRes2.put(fieldStr.getName(), descr);
                                } else {
                                    aBriefRes2.put(fieldStr.getName(), fs);
                                }
                                aBriefRes2.put("actualDatasource", fieldStr.getValue());
                                if (null != fieldStr.getValue()) {
                                    st.setDatasource(fieldStr.getValue());
                                } else {
                                    st.setDatasource("default");
                                }
                                if (this.buildCartURLs) {
                                    HashMap hm = this.buildShopnCartURL(st);
                                    String shoppingCartUrl = (String)hm.get(fieldStr.getValue());
                                    solrTransactionDetail.setCart_urls(hm);
                                    aBriefRes2.put("complete_shoppingcart_url", shoppingCartUrl);
                                    String view_data_base = (String)hm.get("view_data_url");
                                    String view_data = view_data_base + "=" + (String)art.get("NsidcData_url");
                                    if (null != (String)art.get("NsidcData_url")) {
                                        aBriefRes2.put("view_dataURL", view_data);
                                    }
                                }
                            }
                        } else if (thisType.contains("date") && thisName.length() > 0 && thisValue.length() > 0) {
                            aBriefRes2.put(thisName, this.convertToBrief(thisValue));
                            if (thisName.contains("beginDate")) {
                                aBriefRes2.put("startDate", this.convertToBrief(thisValue));
                            }
                        } else if (thisType.contains("float") && thisName.length() > 0 && thisValue.length() > 0) {
                            aBriefRes2.put(thisName, thisValue);
                            if (thisName.contains("north")) {
                                aBriefRes2.put("NBound", thisValue);
                            }
                            if (thisName.contains("south")) {
                                aBriefRes2.put("SBound", thisValue);
                            }
                            if (thisName.contains("east")) {
                                aBriefRes2.put("EBound", thisValue);
                            }
                            if (thisName.contains("west")) {
                                aBriefRes2.put("WBound", thisValue);
                            }
                            try {
                                aBriefRes2.put("pSouthBoundCoord", prt.get("SouthBoundCoord"));
                                aBriefRes2.put("pEastBoundCoord", prt.get("EastBoundCoord"));
                                aBriefRes2.put("pNorthBoundCoord", prt.get("NorthBoundCoord"));
                                aBriefRes2.put("pWestBoundCoord", prt.get("WestBoundCoord"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (null != res.getMaxScore()) {
                            aBriefRes2.put("maxScore", res.getMaxScore());
                        }
                        aBriefRes2.put("starCounter", "star_" + i);
                        aBriefRes2.put("mapCounter", "map_" + i);
                    }
                    if ((aBriefRes2.get("mlt_id") == null || ((String)aBriefRes2.get("mlt_id")).length() == 0) && aBriefRes2.get("id") != null) {
                        String mlt_id = (String)aBriefRes2.get("id");
                        String mlt_id2 = "";
                        if (mlt_id != null && mlt_id.length() > 0) {
                            mlt_id2 = mlt_id.replaceAll("\\\\", "\\\\\\\\");
                            aBriefRes2.put("mlt_id", mlt_id2);
                        }
                    }
                    String citationDate = CitationDateDisplayUtil.getCitationDate((String)aBriefRes2.get("pubDate"), (String)aBriefRes2.get("beginDate"), (String)aBriefRes2.get("dateUploaded"));
                    aBriefRes2.put("citationDate", citationDate);
                    briefList2.add(aBriefRes2);
                }
                facets = res.getFacets();
                j_Docs = res.getJ_Docs();
                j_facets = new ArrayList<Map.Entry<FilterCatField, List>>(facets.entrySet());
                if (null != st.getSolr_facets_map() && st.getSolr_facets_map().size() > 0) {
                    Iterator fmit = st.getSolr_facets_map().keySet().iterator();
                    String facet_str = "<strong style='color:red;'>Filters: </strong> ";
                    String facet_str2 = "<strong style='color:red;'>Filters: </strong> ";
                    while (fmit.hasNext()) {
                        String facetkey = (String)fmit.next();
                        String value = (String)st.getSolr_facets_map().get(facetkey);
                        if (facetkey.equals("datasource") && this.use_mn_source_cache && this.datasourceMapNames.containsKey(value)) {
                            value = this.datasourceMapNames.get(value);
                        }
                        facet_str = facet_str + "  ";
                        String temp_queryString = st.getMercury3_query_string();
                        facet_str = facet_str + this.getDisplay(facetkey) + " : " + value + " (<a href=\"" + "../send/facetsQuerry2?" + temp_queryString + "&del_facet=" + facetkey + "&from=brief\">remove</a>) ";
                        facet_str2 = facet_str2 + this.getDisplay(facetkey) + " : " + value + " (<a href=\"" + "../send/facetsQuerry2?" + temp_queryString + "&del_facet=" + facetkey + "&from=brief\">remove</a>) ";
                        sb2.append(" AND " + facetkey + " : " + value);
                    }
                    solrTransactionDetail.setFacet_str(facet_str);
                    solrTransactionDetail.setFacet_str2(facet_str2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("ERROR=" + e.getMessage());
            }
        }
        if (!noQuery) {
            solrTransactionDetail.setSuggestion(res.getSuggestion());
            solrTransactionDetail.setFacets(facets);
            solrTransactionDetail.setDocuments(documents);
            solrTransactionDetail.setBriefResList(briefList2);
            solrTransactionDetail.setMlt_list(res.getMlt_list());
            solrTransactionDetail.setMaxScore(res.getMaxScore());
            solrTransactionDetail.setPageSize(st.getPageSize());
            if (null != facets && !facets.isEmpty()) {
                solrTransactionDetail.setJ_facets(j_facets);
            }
            solrTransactionDetail.setJ_Docs(j_Docs);
            solrTransactionDetail.setQueryString(query);
            try {
                if (null != res.getStatus() && res.getStatus() != 0) {
                    solrTransactionDetail.setSearchStatus(res.getStatus().toString());
                } else {
                    solrTransactionDetail.setSearchStatus("200");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (null != res.getFound()) {
                    solrTransactionDetail.setFound(res.getFound());
                    st.setResponses(res.getFound());
                } else {
                    solrTransactionDetail.setFound(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (null != res.getStart()) {
                    solrTransactionDetail.setStart(res.getStart());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                solrTransactionDetail.setCurrent_page(st.getCurrent_page());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                solrTransactionDetail.setNum_pages(st.getNum_pages());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                solrTransactionDetail.setPage_max_count(st.getPage_max_count());
                solrTransactionDetail.setGui_queryString(displaySB.toString().replaceAll("[\"]", "%22"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            st.setSource(this.source);
            st.setSolrdb(this.solrdb);
        } else {
            solrTransactionDetail.setFound(0);
        }
        solrTransactionDetail.setRes(res);
        return solrTransactionDetail;
    }

    public SolrTransactionDetail get_browse_details(Search_Terms st) {
        ArrayList<Object> j_Docs = new ArrayList();
        boolean browse = false;
        SolrTransactionDetail solrTransactionDetail = new SolrTransactionDetail();
        String query = "";
        ArrayList j_facets = null;
        Response res = new Response();
        Map<FilterCatField, List> facets = null;
        List<Map<String, Field>> documents = null;
        StringBuffer sb = new StringBuffer();
        try {
            SolrSearcher solrSearcher = new SolrSearcher(this.solrSelectURL);
            ArrayList<String> filedsList = new ArrayList<String>();
            try {
                filedsList.add(st.getBrowse_field());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            if (null != st.getTerm1() && null != st.getTerm1().getValue() && st.getTerm1().getValue().length() > 0 && null != st.getTerm1().getAttribute() && st.getTerm1().getAttribute().length() > 0) {
                sb.append(st.getTerm1().getAttribute().trim() + ":" + "\"" + st.getTerm1().getValue().trim() + "\"");
            }
            if (null != st.getTerm2() && null != st.getTerm2().getValue() && st.getTerm2().getValue().trim().length() > 0 && null != st.getTerm2().getAttribute() && st.getTerm2().getAttribute().trim().length() > 0) {
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                sb.append(st.getTerm2().getAttribute().trim() + ":" + "\"" + st.getTerm2().getValue().trim() + "\"");
            }
            if (null != st.getBrowse() && null != st.getBrowse().getValue() && st.getBrowse().getValue().trim().length() > 0 && null != st.getBrowse().getAttribute() && st.getBrowse().getAttribute().trim().length() > 0) {
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                sb.append(st.getBrowse().getAttribute().trim() + ":" + "\"" + st.getBrowse().getValue().trim() + "\"");
                browse = true;
            }
            if (null != st.getBrowse_source() && st.getBrowse_source().length() > 0 && sb.length() > 0) {
                sb.append(" AND datasource:" + st.getBrowse_source());
            }
            ArrayList<String> facetsList = new ArrayList<String>();
            query = sb.toString();
            res = solrSearcher.search(query, 0, 50000, filedsList, "", null, null, "true", "-1", facetsList, null, null);
            documents = res.getDocuments();
            j_Docs = res.getJ_Docs();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR=" + e.getMessage());
        }
        solrTransactionDetail.setFacets(facets);
        solrTransactionDetail.setDocuments(documents);
        solrTransactionDetail.setMaxScore(res.getMaxScore());
        solrTransactionDetail.setPageSize(st.getPageSize());
        solrTransactionDetail.setJ_facets(j_facets);
        solrTransactionDetail.setJ_Docs(j_Docs);
        solrTransactionDetail.setQueryString(query);
        try {
            if (null != res.getStatus()) {
                solrTransactionDetail.setSearchStatus(res.getStatus().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (null != res.getFound()) {
                solrTransactionDetail.setFound(res.getFound());
                st.setResponses(res.getFound());
            } else {
                solrTransactionDetail.setFound(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (null != res.getStart()) {
                solrTransactionDetail.setStart(res.getStart());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        st.setSource(this.source);
        st.setSolrdb(this.solrdb);
        solrTransactionDetail.setRes(res);
        return solrTransactionDetail;
    }

    private String getDisplay(String s1) {
        String s2 = "";
        try {
            s2 = this.keyMap.get(s1);
        }
        catch (Exception ex) {
            System.out.println("Problem with getDisplay lookup");
        }
        if (null != s2 && s2.length() > 0) {
            return s2;
        }
        return s1;
    }

    public HashMap<String, Object> getProps() {
        return this.hmProps;
    }
}

