/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.services;

import gov.ornl.mercury3.commands.CitationDateDisplayUtil;
import gov.ornl.mercury3.commands.CoinsBean;
import gov.ornl.mercury3.commands.Configuration;
import gov.ornl.mercury3.commands.Field;
import gov.ornl.mercury3.commands.FilterCatField;
import gov.ornl.mercury3.commands.Response;
import gov.ornl.mercury3.email_utils.EmailGenerator;
import gov.ornl.mercury3.services.DataSourceMapNamesBean;
import gov.ornl.mercury3.services.FilterslistMapBean;
import gov.ornl.mercury3.services.SimpleMapBean;
import gov.ornl.mercury3.web.util.D1DocTransferObject;
import gov.ornl.mercury3.web.util.MemberNodeSourcesMapCache;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dataone.client.D1RestClient;
import org.dataone.service.types.v1.Session;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.xml.sax.SAXException;

public class SolrSearcher {
    private boolean spellCheck = false;
    public SimpleMapBean mlt_bean = new SimpleMapBean();
    public DataSourceMapNamesBean dsmnb = new DataSourceMapNamesBean();
    public FilterslistMapBean flmb = new FilterslistMapBean();
    private String limitlessField = "";
    private String limitlessFieldLimit = "";
    private boolean isRSS = false;
    private boolean isMLT = false;
    private String spell = "";
    private final String COMMON = "common";
    private String feedValue = "common";
    private String toEMAIL = "";
    private String fromEMAIL = "";
    private String source = "";
    private String shards = "";
    private String publicFqPart = "";
    private ArrayList<HashMap<String, String>> mlt_list = new ArrayList();
    String url = null;
    ApplicationContext factory3 = null;
    public Map<String, String> datasourceMapNames = new HashMap<String, String>();
    public HashMap<String, String> filterslist = new HashMap();
    public HashMap<String, String> mlt_terms = new HashMap();
    public SimpleDateFormat Solr_ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    public SimpleDateFormat Brief_Format = new SimpleDateFormat("MM/dd/yyyy");
    public SimpleDateFormat Solr_RFC822DATEFORMAT = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);
    public SimpleDateFormat PRT_Format = new SimpleDateFormat("yyyy-MM-dd");

    public String convertToBrief(String date) {
        try {
            this.Solr_ISO8601FORMAT.parse(date, new ParsePosition(0));
        }
        catch (Exception pex) {
            pex.printStackTrace();
        }
        return this.Brief_Format.format(this.Solr_ISO8601FORMAT.getCalendar().getTime());
    }

    public String convertToPRT(String date) {
        try {
            this.Brief_Format.parse(date, new ParsePosition(0));
        }
        catch (Exception pex) {
            pex.printStackTrace();
        }
        return this.PRT_Format.format(this.Brief_Format.getCalendar().getTime());
    }

    public SolrSearcher(String _url) throws MalformedURLException {
        boolean use_mn_source_cache;
        boolean public_only;
        new URL(_url);
        this.factory3 = new ClassPathXmlApplicationContext("gov/ornl/mercury3/services/Mercury_term_maps.xml");
        this.dsmnb = (DataSourceMapNamesBean)this.factory3.getBean("datasource_map_names");
        this.datasourceMapNames = this.dsmnb.getDatasourceMapNames();
        this.flmb = (FilterslistMapBean)this.factory3.getBean("Filterslist_map");
        this.filterslist = this.flmb.getFilterslist();
        this.url = _url;
        ClassPathXmlApplicationContext factory = new ClassPathXmlApplicationContext("Mercury3Properties.xml");
        Configuration cv = (Configuration)factory.getBean("propertiesBean");
        HashMap<String, Object> hmProps = cv.getProperties();
        try {
            this.toEMAIL = (String)hmProps.get("toEMAIL");
            this.fromEMAIL = (String)hmProps.get("fromEMAIL");
            this.shards = (String)hmProps.get("shards");
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.toEMAIL = "mercury-support@ornl.gov";
            this.fromEMAIL = "palanisamyg@ornl.gov";
        }
        try {
            if (null != hmProps.get("spellCheck")) {
                this.spellCheck = Boolean.parseBoolean((String)hmProps.get("spellCheck"));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        try {
            this.shards = (String)hmProps.get("shards");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (null == this.toEMAIL || this.toEMAIL.length() == 0) {
            this.toEMAIL = "mercury-support@ornl.gov";
        }
        if (null == this.fromEMAIL || this.fromEMAIL.length() == 0) {
            this.fromEMAIL = "palanisamyg@ornl.gov";
        }
        if (public_only = Boolean.parseBoolean((String)hmProps.get("show_public_only"))) {
            this.publicFqPart = (String)hmProps.get("public_fq_part");
        }
        if (use_mn_source_cache = Boolean.parseBoolean((String)hmProps.get("use_mn_source_cache"))) {
            this.datasourceMapNames = MemberNodeSourcesMapCache.INSTANCE.getMNSourceMap();
        }
    }

    public Response search(String _query, int _start, int _rows, List<String> _fields, String _type, String _schema, String _dismaxSort, String _facet, String _facetLimit, List<String> _facetField, String imitlessFacet, String limtlessFieldValue, boolean isRSS, String feedValue, boolean isMLT, String spell, List<String> queryFilters, Session d1Session) {
        this.limitlessField = imitlessFacet;
        this.limitlessFieldLimit = limtlessFieldValue;
        return this.search(_query, _start, _rows, _fields, _type, _schema, _dismaxSort, _facet, _facetLimit, _facetField, isRSS, feedValue, isMLT, spell, queryFilters, d1Session);
    }

    public Response search(String _query, int _start, int _rows, List<String> _fields, String _type, String _schema, String _dismaxSort, String _facet, String _facetLimit, List<String> _facetField, List<String> queryFilters, Session d1Session) {
        this.isRSS = false;
        this.isMLT = false;
        this.spell = "";
        return this.search(_query, _start, _rows, _fields, _type, _schema, _dismaxSort, _facet, _facetLimit, _facetField, this.isRSS, this.feedValue, this.isMLT, this.spell, queryFilters, d1Session);
    }

    public List<D1DocTransferObject> findRelatedDocByResourceMap(String pid, Session d1Session) {
        ArrayList<D1DocTransferObject> results = new ArrayList<D1DocTransferObject>();
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("q", "isDocumentedBy:" + ClientUtils.escapeQueryChars((String)pid)));
        params.add(new NameValuePair("fl", "id,dataUrl,isPublic,size,formatId,formatType,resourceMap"));
        params.add(new NameValuePair("sort", "formatType desc,formatId asc,size desc"));
        params.add(new NameValuePair("wt", "json"));
        params.add(new NameValuePair("rows", "1000"));
        String paramString = EncodingUtil.formUrlEncode((NameValuePair[])params.toArray(new NameValuePair[0]), (String)"UTF-8");
        try {
            D1RestClient restClient = new D1RestClient(d1Session);
            InputStream response = restClient.doGetRequest(this.url + "/?" + paramString);
            String responseBody = IOUtils.toString((InputStream)response, (String)"UTF-8");
            JSONObject resultObject = new JSONObject(responseBody);
            if (resultObject.has("response")) {
                JSONArray docs = resultObject.getJSONObject("response").getJSONArray("docs");
                for (int i = 0; i < docs.length(); ++i) {
                    JSONObject result = docs.getJSONObject(i);
                    D1DocTransferObject d1Doc = new D1DocTransferObject(result.getString("id"), result.getString("dataUrl"), result.getString("formatId"), result.getString("size"), result.getString("isPublic"));
                    if (result.has("resourceMap")) {
                        d1Doc.setResourceMap(result.getJSONArray("resourceMap"));
                    }
                    if ("METADATA".equals(result.getString("formatType"))) {
                        d1Doc.setMetadata(true);
                    }
                    results.add(d1Doc);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in Solr Searcher findRelatedD1Docs: ");
            e.printStackTrace();
        }
        return results;
    }

    public D1DocTransferObject getD1DocInfo(String pid, Session d1Session) {
        D1DocTransferObject d1DocDto = null;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("q", "id:" + ClientUtils.escapeQueryChars((String)pid)));
        params.add(new NameValuePair("fl", "id,dataUrl,isPublic,size,formatId,formatType,resourceMap"));
        params.add(new NameValuePair("wt", "json"));
        String paramString = EncodingUtil.formUrlEncode((NameValuePair[])params.toArray(new NameValuePair[0]), (String)"UTF-8");
        try {
            JSONArray docs;
            D1RestClient restClient = new D1RestClient(d1Session);
            InputStream response = restClient.doGetRequest(this.url + "/?" + paramString);
            String responseBody = IOUtils.toString((InputStream)response, (String)"UTF-8");
            JSONObject resultObject = new JSONObject(responseBody);
            if (resultObject.has("response") && (docs = resultObject.getJSONObject("response").getJSONArray("docs")).length() == 1) {
                JSONObject result = docs.getJSONObject(0);
                d1DocDto = new D1DocTransferObject(result.getString("id"), result.getString("dataUrl"), result.getString("formatId"), result.getString("size"), result.getString("isPublic"));
                if ("METADATA".equals(result.getString("formatType"))) {
                    d1DocDto.setMetadata(true);
                }
                if (result.has("resourceMap")) {
                    d1DocDto.setResourceMap(result.getJSONArray("resourceMap"));
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in SolrSearcher getD1DocInfo method: ");
            e.printStackTrace();
        }
        return d1DocDto;
    }

    public CoinsBean getCoinsData(String pid, Session d1Session) {
        CoinsBean coins = new CoinsBean();
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("q", "id:" + ClientUtils.escapeQueryChars((String)pid)));
        params.add(new NameValuePair("fl", "id, dataUrl, title, abstract, datasource, author, pubDate, beginDate, dateUploaded, keywords, investigator"));
        params.add(new NameValuePair("wt", "json"));
        String paramString = EncodingUtil.formUrlEncode((NameValuePair[])params.toArray(new NameValuePair[0]), (String)"UTF-8");
        try {
            JSONArray docs;
            D1RestClient restClient = new D1RestClient(d1Session);
            InputStream response = restClient.doGetRequest(this.url + "/?" + paramString);
            String responseBody = IOUtils.toString((InputStream)response, (String)"UTF-8");
            JSONObject resultObject = new JSONObject(responseBody);
            if (resultObject.has("response") && (docs = resultObject.getJSONObject("response").getJSONArray("docs")).length() == 1) {
                JSONObject result = docs.getJSONObject(0);
                coins.setPid(this.getJsonString(result, "id"));
                coins.setDataUrl(this.getJsonString(result, "dataUrl"));
                coins.setTitle(this.getJsonString(result, "title"));
                coins.setAbstractText(this.getJsonString(result, "abstract"));
                coins.setDatasource(this.getJsonString(result, "datasource"));
                coins.setAuthor(this.getJsonString(result, "author"));
                String citationDate = CitationDateDisplayUtil.getCitationDate(this.getJsonString(result, "pubDate"), this.getJsonString(result, "beginDate"), this.getJsonString(result, "dateUploaded"));
                coins.setCitationDate(citationDate);
                if (result.has("keywords")) {
                    coins.setKeywordsFromJsonArray(result.getJSONArray("keywords"));
                }
                if (result.has("investigator")) {
                    coins.setAdditionalInvestigatorsFromJsonArray(result.getJSONArray("investigator"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return coins;
    }

    public String solrPass(Map parameters, Session d1Session) {
        String responseBody = "";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (Object key : parameters.keySet()) {
            String keyString = (String)key;
            String[] values = (String[])parameters.get(keyString);
            if (values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                params.add(new NameValuePair(keyString, value));
            }
        }
        String paramString = EncodingUtil.formUrlEncode((NameValuePair[])params.toArray(new NameValuePair[0]), (String)"UTF-8");
        try {
            D1RestClient restClient = new D1RestClient(d1Session);
            InputStream response = restClient.doGetRequest(this.url + "/?" + paramString);
            responseBody = IOUtils.toString((InputStream)response, (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return responseBody;
    }

    private String getJsonString(JSONObject result, String fieldName) {
        String value = "";
        if (result.has(fieldName)) {
            try {
                return result.getString(fieldName);
            }
            catch (JSONException jse) {
                jse.printStackTrace();
            }
        }
        return value;
    }

    public Response search(String _query, int _start, int _rows, List<String> _fields, String _type, String _schema, String _dismaxSort, String _facet, String _facetLimit, List<String> _facetField, boolean isRSS, String feedValue, boolean isMLT, String spell, List<String> queryFilters, Session d1Session) {
        int order;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        String q3 = _query;
        String q2 = _query;
        if (q2.trim().replaceAll(" ", "").equalsIgnoreCase("((*))")) {
            q2 = "((*:*))";
        }
        if (q2.trim().replaceAll(" ", "").contains("(*)")) {
            q2 = _query.trim().replaceAll("( \\* )", "(\\*:\\*)");
        }
        if (feedValue.equalsIgnoreCase("gfis")) {
            q3 = q2.concat(" AND pubDate:[NOW/YEAR-10YEAR TO * ]");
        }
        params.add(new NameValuePair("q", q3));
        params.add(new NameValuePair("spellcheck.q", spell));
        params.add(new NameValuePair("spellcheck", "true"));
        params.add(new NameValuePair("spellcheck.collate", "true"));
        if (isMLT) {
            this.mlt_bean = (SimpleMapBean)this.factory3.getBean("MLT_Map");
            this.mlt_terms = this.mlt_bean.getTerm1Map();
            for (String var : this.mlt_terms.keySet()) {
                params.add(new NameValuePair(var, this.mlt_terms.get(var)));
            }
        }
        if (_dismaxSort != null) {
            params.add(new NameValuePair("sort", _dismaxSort));
        }
        if (_start > 0) {
            params.add(new NameValuePair("start", _start + ""));
        }
        params.add(new NameValuePair("rows", _rows + ""));
        if (_type != null) {
            params.add(new NameValuePair("qt", _type));
        }
        if (_schema != null) {
            params.add(new NameValuePair("df", _schema));
        }
        if (this.shards != null && this.shards.length() > 0) {
            params.add(new NameValuePair("shards", this.shards));
        }
        if (_fields != null) {
            StringBuilder sb = new StringBuilder();
            for (String string : _fields) {
                sb.append(string);
                sb.append(",");
            }
            params.add(new NameValuePair("fl", sb.toString()));
        }
        if (_facet != null) {
            params.add(new NameValuePair("facet", "true"));
        }
        if (_facetLimit != null) {
            params.add(new NameValuePair("facet.limit", _facetLimit));
        }
        if ((order = Integer.parseInt(_facetLimit)) == -1) {
            params.add(new NameValuePair("facet.sort", "false"));
        }
        if (_facetField != null) {
            StringBuilder sb2 = new StringBuilder();
            for (String string : _facetField) {
                params.add(new NameValuePair("facet.field", string));
            }
        }
        params.add(new NameValuePair("facet.zeros", "false"));
        if (this.limitlessField.length() > 0 && this.limitlessFieldLimit.length() > 0) {
            params.add(new NameValuePair("f." + this.limitlessField + ".facet.limit", this.limitlessFieldLimit));
        }
        if (this.publicFqPart != null && !this.publicFqPart.isEmpty()) {
            params.add(new NameValuePair("fq", this.publicFqPart));
        }
        if (queryFilters != null && !queryFilters.isEmpty()) {
            for (String queryFilter : queryFilters) {
                params.add(new NameValuePair("fq", queryFilter));
            }
        }
        String encoded = EncodingUtil.formUrlEncode((NameValuePair[])params.toArray(new NameValuePair[0]), (String)"UTF-8");
        String requestUrl = this.url + "/?" + encoded;
        Response res = new Response();
        try {
            String rss1;
            ByteArrayInputStream is;
            String inputString;
            File xslFilename;
            ClassPathXmlApplicationContext factory;
            D1RestClient restClient = new D1RestClient(d1Session);
            InputStream response = restClient.doGetRequest(requestUrl);
            String responseBody = IOUtils.toString((InputStream)response, (String)"UTF-8");
            res = this.createResponse(responseBody, _fields);
            if (isRSS) {
                factory = new ClassPathXmlApplicationContext("gov/ornl/mercury3/services/applicationContext.xml");
                xslFilename = null;
                try {
                    xslFilename = feedValue.equalsIgnoreCase("common") || feedValue.length() < 1 ? factory.getResource("gov/ornl/mercury3/services/example_rss.xsl").getFile() : factory.getResource("gov/ornl/mercury3/services/" + feedValue + "_rss.xsl").getFile();
                    inputString = this.getCleanString(responseBody);
                    is = new ByteArrayInputStream(inputString.getBytes("UTF-8"));
                    rss1 = this.getTransform(xslFilename, is);
                    res.setRss1(rss1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (isMLT) {
                factory = new ClassPathXmlApplicationContext("gov/ornl/mercury3/services/applicationContext.xml");
                xslFilename = null;
                try {
                    xslFilename = factory.getResource("gov/ornl/mercury3/services/mlt.xsl").getFile();
                    inputString = this.getCleanString(responseBody);
                    is = new ByteArrayInputStream(inputString.getBytes("UTF-8"));
                    rss1 = this.getTransform(xslFilename, is);
                    res.setRss1(rss1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            System.out.println("**** Error in SolrSearch search method: ");
            ex.printStackTrace();
        }
        return res;
    }

    public String getTransform(File xslFilename, InputStream is) {
        File xsltFile = xslFilename;
        StreamResult strResult = new StreamResult(new StringWriter());
        String rss = null;
        try {
            StreamSource xmlSource3 = new StreamSource(is);
            StreamSource xsltSource = new StreamSource(xsltFile);
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(xmlSource3, strResult);
            rss = strResult.getWriter().toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            System.out.println("An error occurred in the XSL file" + e);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            SourceLocator locator = e.getLocator();
            int col = locator.getColumnNumber();
            int line = locator.getLineNumber();
            System.out.println(" An error occurred while applying the XSL file");
            System.out.println("line : " + line + "  col : " + col);
        }
        return rss;
    }

    protected Response createResponse(String _xml, List<String> _fields) throws SAXException, IOException, ParserConfigurationException, JDOMException {
        int ch;
        Response res = new Response();
        byte[] xmlBytes = _xml.getBytes("UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream(xmlBytes);
        StringBuffer buffer = new StringBuffer();
        InputStreamReader isr2 = new InputStreamReader((InputStream)is, "UTF-8");
        BufferedReader in2 = new BufferedReader(isr2);
        while ((ch = ((Reader)in2).read()) > -1) {
            if (ch == 9 || ch == 10 || ch == 13 || ch >= 32 && ch <= 55295 || ch >= 57344 && ch <= 65533 || ch >= 65536 && ch <= 0x10FFFF) {
                buffer.append((char)ch);
                continue;
            }
            System.out.println("Filtering characters = > " + ch);
            System.out.println("");
        }
        ((Reader)in2).close();
        String myString = buffer.toString();
        byte[] xmlBytes2 = myString.getBytes("UTF-8");
        ByteArrayInputStream is2 = new ByteArrayInputStream(xmlBytes2);
        Document doc = new SAXBuilder().build((InputStream)is2);
        if (this.spellCheck) {
            String xexprBean = "//response/ lst[@name='spellcheck']/ lst[@name='suggestions']/ str[@name='collation']/text()";
            XPath beans = XPath.newInstance((String)xexprBean);
            String suggestion = beans.valueOf((Object)doc);
            res.setSuggestion(suggestion);
            System.out.println("SpellChecker suggestion => " + suggestion);
        }
        Element root = doc.getRootElement();
        List responseHeaderList = root.getChildren("lst");
        for (Element rDocument : responseHeaderList) {
            if (rDocument.getAttributeValue("name").equals("responseHeader")) {
                for (Element intElm : rDocument.getChildren("int")) {
                    if (intElm.getAttributeValue("name").equals("status")) {
                        res.setStatus(new Integer(intElm.getValue()));
                    }
                    if (!intElm.getAttributeValue("name").equals("QTime")) continue;
                    res.setQtime(new Integer(intElm.getValue()));
                }
                continue;
            }
            if (rDocument.getAttributeValue("name").equals("moreLikeThis")) {
                for (Element intElm : rDocument.getChildren("result")) {
                    Iterator rDIT2 = intElm.getChildren("doc").iterator();
                    while (rDIT2.hasNext()) {
                        HashMap<String, String> mlt_hm = new HashMap<String, String>();
                        Element intElm2 = (Element)rDIT2.next();
                        for (Element intElm3 : intElm2.getChildren("str")) {
                            String s2 = intElm3.getText();
                            String s3 = intElm3.getAttributeValue("name");
                            if (s3.equals("id")) {
                                mlt_hm.put(s3, s2);
                                mlt_hm.put("mlt_id", s2.replaceAll("\\\\", "\\\\\\\\"));
                                continue;
                            }
                            mlt_hm.put(s3, s2);
                        }
                        for (Element intElm4 : intElm2.getChildren("date")) {
                            String s2 = intElm4.getText();
                            String s3 = intElm4.getAttributeValue("name");
                            String date = this.convertToBrief(s2);
                            mlt_hm.put(s3, date);
                        }
                        this.mlt_list.add(mlt_hm);
                    }
                    res.setMlt_list(this.mlt_list);
                }
                continue;
            }
            if (!rDocument.getAttributeValue("name").equals("facet_counts")) continue;
            for (Element facetElm : rDocument.getChildren("lst")) {
                if (!facetElm.getAttributeValue("name").equals("facet_fields")) continue;
                Iterator ffIT = facetElm.getChildren("lst").iterator();
                LinkedHashMap<FilterCatField, List> facetFieldsList = new LinkedHashMap<FilterCatField, List>();
                HashMap facetFieldsLists = new HashMap();
                while (ffIT.hasNext()) {
                    Element facetFldElm = (Element)ffIT.next();
                    ArrayList<Field> facetValues = new ArrayList<Field>();
                    for (Element facetChildElm : facetFldElm.getChildren("int")) {
                        if (facetChildElm.getAttributeValue("name").trim().length() <= 0) continue;
                        Field aField = new Field();
                        aField.setName(facetChildElm.getAttributeValue("name"));
                        aField.setEncodedString(URLEncoder.encode(facetChildElm.getAttributeValue("name"), "UTF-8"));
                        aField.setValue(facetChildElm.getValue());
                        aField.setType(facetChildElm.getName());
                        aField.setDescription(this.datasourceMapNames.get(facetChildElm.getAttributeValue("name")));
                        if (Integer.parseInt(aField.getValue()) == 0) continue;
                        facetValues.add(aField);
                    }
                    if (facetValues.isEmpty()) continue;
                    FilterCatField filtercatField = new FilterCatField();
                    filtercatField.setFilterCatCode(facetFldElm.getAttributeValue("name"));
                    String localvalue = this.filterslist.get(facetFldElm.getAttributeValue("name"));
                    if (null != localvalue && localvalue.length() > 0) {
                        filtercatField.setFilterCatName(localvalue);
                    } else {
                        filtercatField.setFilterCatName(facetFldElm.getAttributeValue("name"));
                    }
                    facetFieldsList.put(filtercatField, facetValues);
                }
                res.setFacets(facetFieldsList);
            }
        }
        Element result = root.getChild("result");
        Integer numFound = new Integer(result.getAttributeValue("numFound"));
        if (null != result.getAttributeValue("maxScore")) {
            Float maxScore = new Float(result.getAttributeValue("maxScore"));
            res.setMaxScore(maxScore);
        }
        res.setFound(numFound);
        Integer start = new Integer(result.getAttributeValue("start"));
        res.setStart(start);
        ArrayList<String> al = new ArrayList<String>();
        ArrayList<String> al2 = new ArrayList<String>();
        Iterator dox = result.getChildren("doc").iterator();
        int count = 0;
        int childctr = 0;
        while (dox.hasNext()) {
            Element resultDocument = (Element)dox.next();
            List fieldList = resultDocument.getChildren();
            ++childctr;
            HashMap<String, Field> docFields = new HashMap<String, Field>();
            for (Element triple : fieldList) {
                int k;
                Field f = new Field();
                f.setName(triple.getAttributeValue("name"));
                f.setValue(triple.getValue());
                List tripleContents = triple.getContent();
                ArrayList<String> extractedValues = new ArrayList<String>();
                if (triple.getName().trim().equalsIgnoreCase("arr")) {
                    for (k = 0; k < tripleContents.size(); ++k) {
                        extractedValues.add(((Element)tripleContents.get(k)).getValue());
                    }
                }
                if (triple.getName().trim().equalsIgnoreCase("str")) {
                    for (k = 0; k < tripleContents.size(); ++k) {
                        extractedValues.add(triple.getTextTrim());
                    }
                }
                if (res.getFound() > 0 && tripleContents.size() == 0) {
                    extractedValues.add("MetaData Error Encountered  " + triple.getAttributes().get(0).toString());
                }
                f.setType(triple.getName());
                f.setValueList(extractedValues);
                docFields.put(f.getName(), f);
                al.add(f.getValue());
                if (!f.getName().equalsIgnoreCase(_fields.get(0))) continue;
                ArrayList tempValues = f.getValueList();
                for (String kvalue : tempValues) {
                    if (al2.contains(kvalue)) continue;
                    al2.add(kvalue);
                }
            }
            Collections.sort(al2);
            res.getDocuments().add(count, docFields);
            res.setJ_Docs(al2);
            ++count;
        }
        return res;
    }

    private String getCleanString(String stringToClean) throws IOException {
        int ch;
        byte[] xmlBytes = stringToClean.getBytes();
        StringBuffer buffer = new StringBuffer();
        ByteArrayInputStream is = new ByteArrayInputStream(xmlBytes);
        InputStreamReader isr2 = new InputStreamReader((InputStream)is, "UTF-8");
        BufferedReader in2 = new BufferedReader(isr2);
        while ((ch = ((Reader)in2).read()) > -1) {
            if (!(ch == 9 || ch == 10 || ch == 13 || ch >= 32 && ch <= 55295 || ch >= 57344 && ch <= 65533) && (ch < 65536 || ch > 0x10FFFF)) continue;
            buffer.append((char)ch);
        }
        ((Reader)in2).close();
        String myString = buffer.toString();
        return myString;
    }

    private void mail(String message, Throwable ex, List<NameValuePair> params) {
        StringBuffer solrInput = new StringBuffer();
        for (NameValuePair parm : params) {
            String name = parm.getName();
            String value = parm.getValue();
            solrInput.append(name + " -> " + value + "\n");
        }
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        ex.printStackTrace(printWriter);
        this.mail(message + "\n\n" + solrInput.toString() + "\n\n" + ((Object)result).toString());
    }

    private void mail(String message) {
        try {
            EmailGenerator.sendTextMail(this.toEMAIL, this.source.toUpperCase() + " Search Error", message, this.fromEMAIL);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

